/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.potion;

import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.bomb.BlockTaint;
import com.hbm.capability.HbmLivingCapability;
import com.hbm.config.CompatibilityConfig;
import com.hbm.config.GeneralConfig;
import com.hbm.entity.mob.EntityTaintedCreeper;
import com.hbm.explosion.ExplosionLarge;
import com.hbm.lib.HBMSoundHandler;
import com.hbm.lib.ModDamageSource;
import com.hbm.util.ContaminationUtil;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class HbmPotion
extends Potion {
    public static HbmPotion taint;
    public static HbmPotion radiation;
    public static HbmPotion bang;
    public static HbmPotion mutation;
    public static HbmPotion radx;
    public static HbmPotion lead;
    public static HbmPotion radaway;
    public static HbmPotion telekinesis;
    public static HbmPotion phosphorus;
    public static HbmPotion stability;
    public static HbmPotion potionsickness;

    public HbmPotion(boolean isBad, int color, String name, int x, int y) {
        super(isBad, color);
        this.func_76390_b(name);
        this.setRegistryName("hbm", name);
        this.func_76399_b(x, y);
    }

    public static void init() {
        taint = HbmPotion.registerPotion(true, 0x800080, "potion.hbm_taint", 0, 0);
        radiation = HbmPotion.registerPotion(true, 8700200, "potion.hbm_radiation", 1, 0);
        bang = HbmPotion.registerPotion(true, 0x111111, "potion.hbm_bang", 3, 0);
        mutation = HbmPotion.registerPotion(false, 16744754, "potion.hbm_mutation", 2, 0);
        radx = HbmPotion.registerPotion(false, 2251008, "potion.hbm_radx", 5, 0);
        lead = HbmPotion.registerPotion(true, 7763586, "potion.hbm_lead", 6, 0);
        radaway = HbmPotion.registerPotion(false, 16770048, "potion.hbm_radaway", 7, 0);
        telekinesis = HbmPotion.registerPotion(true, 62463, "potion.hbm_telekinesis", 0, 1);
        phosphorus = HbmPotion.registerPotion(true, 16726528, "potion.hbm_phosphorus", 1, 1);
        stability = HbmPotion.registerPotion(false, 0xD0D0D0, "potion.hbm_stability", 2, 1);
        potionsickness = HbmPotion.registerPotion(false, 0xFF8080, "potion.hbm_potionsickness", 3, 1);
    }

    public static HbmPotion registerPotion(boolean isBad, int color, String name, int x, int y) {
        HbmPotion effect = new HbmPotion(isBad, color, name, x, y);
        ForgeRegistries.POTIONS.register((IForgeRegistryEntry)effect);
        return effect;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_76392_e() {
        ResourceLocation loc = new ResourceLocation("hbm", "textures/gui/potions.png");
        Minecraft.func_71410_x().field_71446_o.func_110577_a(loc);
        return super.func_76392_e();
    }

    public void func_76394_a(EntityLivingBase entity, int level) {
        int remaining;
        if (this == taint) {
            int z;
            int y;
            int x;
            BlockPos pos;
            if (!(entity instanceof EntityTaintedCreeper) && entity.field_70170_p.field_73012_v.nextInt(80) == 0) {
                entity.func_70097_a(ModDamageSource.taint, (float)(level + 1));
            }
            if (GeneralConfig.enableHardcoreTaint && !entity.field_70170_p.field_72995_K && CompatibilityConfig.isWarDim(entity.field_70170_p) && entity.field_70170_p.func_180495_p(pos = new BlockPos(x = (int)(entity.field_70165_t - 1.0), y = (int)entity.field_70163_u, z = (int)entity.field_70161_v)).func_177230_c().func_176200_f((IBlockAccess)entity.field_70170_p, pos) && BlockTaint.hasPosNeightbour(entity.field_70170_p, pos)) {
                entity.field_70170_p.func_180501_a(pos, ModBlocks.taint.func_176194_O().func_177621_b().func_177226_a((IProperty)BlockTaint.TEXTURE, (Comparable)Integer.valueOf(14)), 2);
            }
        }
        if (this == radiation) {
            ContaminationUtil.contaminate(entity, ContaminationUtil.HazardType.RADIATION, ContaminationUtil.ContaminationType.CREATIVE, ((float)level + 1.0f) * 0.05f);
        }
        if (this == radaway && entity.hasCapability(HbmLivingCapability.EntityHbmPropsProvider.ENT_HBM_PROPS_CAP, null)) {
            ((HbmLivingCapability.IEntityHbmProps)entity.getCapability(HbmLivingCapability.EntityHbmPropsProvider.ENT_HBM_PROPS_CAP, null)).decreaseRads((float)(level + 1) * 0.05f);
        }
        if (this == bang) {
            if (CompatibilityConfig.isWarDim(entity.field_70170_p)) {
                entity.func_70097_a(ModDamageSource.bang, (float)(10000 * (level + 1)));
                if (!(entity instanceof EntityPlayer)) {
                    entity.func_70645_a(ModDamageSource.bang);
                    entity.func_70606_j(0.0f);
                }
            }
            entity.field_70170_p.func_184133_a(null, new BlockPos((Entity)entity), HBMSoundHandler.laserBang, SoundCategory.AMBIENT, 100.0f, 1.0f);
            ExplosionLarge.spawnParticles(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 10);
        }
        if (this == lead) {
            entity.func_70097_a(ModDamageSource.lead, (float)(level + 1));
        }
        if (this == telekinesis && (remaining = entity.func_70660_b((Potion)this).func_76459_b()) > 1) {
            entity.field_70159_w += ((double)entity.func_70681_au().nextFloat() - 0.5) * (double)(level + 1) * 0.5;
            entity.field_70181_x += ((double)entity.func_70681_au().nextFloat() - 0.5) * (double)(level + 1) * 0.5;
            entity.field_70179_y += ((double)entity.func_70681_au().nextFloat() - 0.5) * (double)(level + 1) * 0.5;
        }
        if (this == phosphorus && !entity.field_70170_p.field_72995_K && CompatibilityConfig.isWarDim(entity.field_70170_p)) {
            entity.func_70015_d(level + 1);
        }
        if (this == potionsickness && !entity.field_70170_p.field_72995_K && entity.field_70170_p.field_73012_v.nextInt(128) == 0) {
            entity.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 160, 0));
        }
    }

    public boolean func_76397_a(int par1, int par2) {
        if (this == taint || this == potionsickness) {
            return par1 % 2 == 0;
        }
        if (this == radiation || this == radaway || this == telekinesis || this == phosphorus) {
            return true;
        }
        if (this == bang) {
            return par1 <= 10;
        }
        if (this == lead) {
            int k = 60;
            return k > 0 ? par1 % k == 0 : true;
        }
        return false;
    }
}

