/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.gui;

import com.hbm.forgefluid.FFUtils;
import com.hbm.inventory.container.ContainerIGenerator;
import com.hbm.inventory.gui.GuiInfoContainer;
import com.hbm.lib.Library;
import com.hbm.packet.AuxButtonPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.render.amlfrom1710.Vec3;
import com.hbm.render.util.GaugeUtil;
import com.hbm.tileentity.machine.TileEntityMachineIGenerator;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Mouse;

public class GUIIGenerator
extends GuiInfoContainer {
    private static ResourceLocation texture = new ResourceLocation("hbm:textures/gui/generators/gui_igen.png");
    private TileEntityMachineIGenerator igen;
    boolean caughtMouse = false;

    public GUIIGenerator(InventoryPlayer invPlayer, TileEntityMachineIGenerator tedf) {
        super(new ContainerIGenerator(invPlayer, tedf));
        this.igen = tedf;
        this.field_146999_f = 188;
        this.field_147000_g = 222;
    }

    public void func_73863_a(int x, int y, float f) {
        super.func_73863_a(x, y, f);
        if (!this.caughtMouse && Mouse.isButtonDown((int)0) && this.field_147003_i + 85 <= x && this.field_147003_i + 85 + 18 > x && this.field_147009_r + 71 < y && this.field_147009_r + 71 + 18 >= y) {
            this.caughtMouse = true;
        }
        if (this.caughtMouse && !Mouse.isButtonDown((int)0)) {
            int dial = (int)Math.round(Math.toDegrees(this.getAngle(x, y)));
            this.igen.setDialByAngle(dial);
            PacketDispatcher.wrapper.sendToServer((IMessage)new AuxButtonPacket(this.igen.func_174877_v(), dial, 2));
            this.caughtMouse = false;
        }
        this.drawCustomInfoStat(x, y, this.field_147003_i + 76, this.field_147009_r + 20, 36, 12, x, y, new String[]{this.igen.temperature + 300 + "K"});
        this.drawCustomInfoStat(x, y, this.field_147003_i + 76, this.field_147009_r + 56, 36, 12, x, y, new String[]{(double)Math.round((double)(this.igen.torque * 50) / 7200.0 * 10.0) / 10.0 + "RPM"});
        this.drawCustomInfoStat(x, y, this.field_147003_i + 76, this.field_147009_r + 92, 36, 12, x, y, new String[]{Library.getShortNumber(this.igen.power) + "HE"});
        this.drawCustomInfoStat(x, y, this.field_147003_i + 40, this.field_147009_r + 26, 18, 18, x, y, new String[]{this.igen.burnTime / 20 + "s"});
        this.drawCustomInfoStat(x, y, this.field_147003_i + 24, this.field_147009_r + 64, 14, 14, x, y, new String[]{"Add pellet to stack"});
        this.drawCustomInfoStat(x, y, this.field_147003_i + 24, this.field_147009_r + 100, 14, 14, x, y, new String[]{"Take pellet from stack"});
        FFUtils.renderTankInfo(this, x, y, this.field_147003_i + 148, this.field_147009_r + 26, 18, 18, this.igen.tanks[0], this.igen.tankTypes[0]);
        FFUtils.renderTankInfo(this, x, y, this.field_147003_i + 148, this.field_147009_r + 62, 18, 18, this.igen.tanks[1], this.igen.tankTypes[1]);
        FFUtils.renderTankInfo(this, x, y, this.field_147003_i + 148, this.field_147009_r + 84, 18, 18, this.igen.tanks[2], this.igen.tankTypes[2]);
        super.func_191948_b(x, y);
    }

    protected void func_73864_a(int x, int y, int i) throws IOException {
        super.func_73864_a(x, y, i);
        if (this.field_147003_i + 24 <= x && this.field_147003_i + 24 + 14 > x && this.field_147009_r + 64 < y && this.field_147009_r + 64 + 14 >= y) {
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            PacketDispatcher.wrapper.sendToServer((IMessage)new AuxButtonPacket(this.igen.func_174877_v(), 0, 0));
        }
        if (this.field_147003_i + 24 <= x && this.field_147003_i + 24 + 14 > x && this.field_147009_r + 100 < y && this.field_147009_r + 100 + 14 >= y) {
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            PacketDispatcher.wrapper.sendToServer((IMessage)new AuxButtonPacket(this.igen.func_174877_v(), 0, 1));
        }
    }

    protected void func_146979_b(int i, int j) {
        String name = this.igen.hasCustomInventoryName() ? this.igen.getInventoryName() : I18n.func_135052_a((String)this.igen.getInventoryName(), (Object[])new Object[0]);
        this.field_146289_q.func_78276_b(name, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(name) / 2, 6, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 14, this.field_147000_g - 96 + 2, 0x404040);
    }

    protected void func_146976_a(float iinterpolation, int x, int y) {
        int i;
        super.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        for (i = 0; i < this.igen.pellets.length; ++i) {
            if (this.igen.pellets[i] == null) continue;
            this.func_73729_b(this.field_147003_i + 6, this.field_147009_r + 106 - 4 * i, 188, this.igen.pellets[i].offset, 14, 9);
        }
        for (i = 0; i < 3; ++i) {
            if (this.igen.tanks[i].getFluidAmount() <= 0) continue;
            int offset = 0;
            if (i == 1) {
                offset = 36;
            } else if (i == 2) {
                offset = 58;
            }
            FFUtils.drawLiquid(this.igen.tanks[i].getFluid(), this.field_147003_i, this.field_147009_r, this.field_73735_i, 16, 4, 149, 27 + offset);
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawDial(x, y);
        GaugeUtil.renderGauge(GaugeUtil.Gauge.BOW_SMALL, this.field_147003_i + 40, this.field_147009_r + 26, this.field_73735_i, this.igen.getSolidGauge());
        GaugeUtil.renderGauge(GaugeUtil.Gauge.BAR_SMALL, this.field_147003_i + 76, this.field_147009_r + 20, this.field_73735_i, this.igen.getTempGauge());
        GaugeUtil.renderGauge(GaugeUtil.Gauge.BAR_SMALL, this.field_147003_i + 76, this.field_147009_r + 56, this.field_73735_i, this.igen.getTorqueGauge());
        GaugeUtil.renderGauge(GaugeUtil.Gauge.BAR_SMALL, this.field_147003_i + 76, this.field_147009_r + 92, this.field_73735_i, this.igen.getPowerGauge());
        GaugeUtil.renderGauge(GaugeUtil.Gauge.WIDE_SMALL, this.field_147003_i + 148, this.field_147009_r + 26, this.field_73735_i, (double)this.igen.tanks[0].getFluidAmount() / (double)this.igen.tanks[0].getCapacity());
        GaugeUtil.renderGauge(GaugeUtil.Gauge.WIDE_SMALL, this.field_147003_i + 148, this.field_147009_r + 62, this.field_73735_i, (double)this.igen.tanks[1].getFluidAmount() / (double)this.igen.tanks[1].getCapacity());
        GaugeUtil.renderGauge(GaugeUtil.Gauge.WIDE_SMALL, this.field_147003_i + 148, this.field_147009_r + 84, this.field_73735_i, (double)this.igen.tanks[2].getFluidAmount() / (double)this.igen.tanks[2].getCapacity());
    }

    private void drawDial(float x, float y) {
        float angle = (float)this.getAngle(x, y);
        double pixel = 0.00390625;
        Vec3 vec = Vec3.createVectorHelper(8.0, 8.0, 0.0);
        vec.rotateAroundZ(-angle);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buf = tessellator.func_178180_c();
        buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buf.func_181662_b((double)(this.field_147003_i + 94) + vec.xCoord, (double)(this.field_147009_r + 80) + vec.yCoord, (double)this.field_73735_i).func_187315_a(pixel * 218.0, 0.0).func_181675_d();
        vec.rotateAroundZ((float)Math.toRadians(90.0));
        buf.func_181662_b((double)(this.field_147003_i + 94) + vec.xCoord, (double)(this.field_147009_r + 80) + vec.yCoord, (double)this.field_73735_i).func_187315_a(pixel * 218.0, pixel * 16.0).func_181675_d();
        vec.rotateAroundZ((float)Math.toRadians(90.0));
        buf.func_181662_b((double)(this.field_147003_i + 94) + vec.xCoord, (double)(this.field_147009_r + 80) + vec.yCoord, (double)this.field_73735_i).func_187315_a(pixel * 202.0, pixel * 16.0).func_181675_d();
        vec.rotateAroundZ((float)Math.toRadians(90.0));
        buf.func_181662_b((double)(this.field_147003_i + 94) + vec.xCoord, (double)(this.field_147009_r + 80) + vec.yCoord, (double)this.field_73735_i).func_187315_a(pixel * 202.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
    }

    private double getAngle(float x, float y) {
        if (!this.caughtMouse) {
            return Math.toRadians(this.igen.getAngleFromDial());
        }
        double angle = -Math.atan2((float)(this.field_147003_i + 94) - x, (float)(this.field_147009_r + 80) - y) + 3.1415927410125732;
        angle = Math.max(angle, 0.7853981633974483);
        angle = Math.min(angle, 5.497787143782138);
        return angle;
    }
}

