/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.hazard;

import com.hbm.hazard.HazardData;
import com.hbm.hazard.HazardEntry;
import com.hbm.hazard.transformer.HazardTransformerBase;
import com.hbm.interfaces.Untested;
import com.hbm.inventory.RecipesCommon;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

@Untested
public class HazardSystem {
    public static final HashMap<String, HazardData> oreMap = new HashMap();
    public static final HashMap<Item, HazardData> itemMap = new HashMap();
    public static final HashMap<RecipesCommon.ComparableStack, HazardData> stackMap = new HashMap();
    public static final HashSet<RecipesCommon.ComparableStack> blacklist = new HashSet();
    public static final List<HazardTransformerBase> trafos = new ArrayList<HazardTransformerBase>();

    public static void register(Object o, HazardData data) {
        if (o instanceof String) {
            oreMap.put((String)o, data);
        }
        if (o instanceof Item) {
            itemMap.put((Item)o, data);
        }
        if (o instanceof Block) {
            itemMap.put(Item.func_150898_a((Block)((Block)o)), data);
        }
        if (o instanceof ItemStack) {
            stackMap.put(new RecipesCommon.ComparableStack((ItemStack)o), data);
        }
        if (o instanceof RecipesCommon.ComparableStack) {
            stackMap.put((RecipesCommon.ComparableStack)o, data);
        }
    }

    public static void blacklist(ItemStack stack) {
        blacklist.add(new RecipesCommon.ComparableStack(stack).makeSingular());
    }

    public static boolean isItemBlacklisted(ItemStack stack) {
        return blacklist.contains(new RecipesCommon.ComparableStack(stack).makeSingular());
    }

    public static List<HazardEntry> getHazardsFromStack(ItemStack stack) {
        RecipesCommon.ComparableStack comp;
        int[] ids;
        if (HazardSystem.isItemBlacklisted(stack)) {
            return new ArrayList<HazardEntry>();
        }
        ArrayList<HazardData> chronological = new ArrayList<HazardData>();
        for (int id : ids = OreDictionary.getOreIDs((ItemStack)stack)) {
            String name = OreDictionary.getOreName((int)id);
            if (!oreMap.containsKey(name)) continue;
            chronological.add(oreMap.get(name));
        }
        if (itemMap.containsKey(stack.func_77973_b())) {
            chronological.add(itemMap.get(stack.func_77973_b()));
        }
        if (stackMap.containsKey(comp = new RecipesCommon.ComparableStack(stack).makeSingular())) {
            chronological.add(stackMap.get(comp));
        }
        ArrayList<HazardEntry> entries = new ArrayList<HazardEntry>();
        for (HazardTransformerBase trafo : trafos) {
            trafo.transformPre(stack, entries);
        }
        int mutex = 0;
        for (HazardData data : chronological) {
            if (data.doesOverride) {
                entries.clear();
            }
            if ((data.getMutex() & mutex) != 0) continue;
            entries.addAll(data.entries);
            mutex |= data.getMutex();
        }
        for (HazardTransformerBase trafo : trafos) {
            trafo.transformPost(stack, entries);
        }
        return entries;
    }

    public static void applyHazards(ItemStack stack, EntityLivingBase entity) {
        List<HazardEntry> hazards = HazardSystem.getHazardsFromStack(stack);
        for (HazardEntry hazard : hazards) {
            hazard.applyHazard(stack, entity);
        }
    }

    public static void updatePlayerInventory(EntityPlayer player) {
        for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
            ItemStack stack = (ItemStack)player.field_71071_by.field_70462_a.get(i);
            if (stack == null) continue;
            HazardSystem.applyHazards(stack, (EntityLivingBase)player);
            if (!stack.func_190926_b()) continue;
            player.field_71071_by.field_70462_a.set(i, (Object)ItemStack.field_190927_a);
        }
        for (ItemStack stack : player.field_71071_by.field_70460_b) {
            if (stack == null) continue;
            HazardSystem.applyHazards(stack, (EntityLivingBase)player);
        }
    }

    public static void updateLivingInventory(EntityLivingBase entity) {
        for (int i = 0; i < 6; ++i) {
            ItemStack stack = entity.func_184582_a(EntityEquipmentSlot.values()[i]);
            if (stack == null) continue;
            HazardSystem.applyHazards(stack, entity);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void addFullTooltip(ItemStack stack, EntityPlayer player, List<String> list) {
        List<HazardEntry> hazards = HazardSystem.getHazardsFromStack(stack);
        for (HazardEntry hazard : hazards) {
            hazard.type.addHazardInformation(player, list, hazard.baseLevel, stack, hazard.mods);
        }
    }
}

