/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.guncfg;

import com.hbm.entity.projectile.EntityBulletBase;
import com.hbm.handler.BulletConfigSyncingUtil;
import com.hbm.handler.BulletConfiguration;
import com.hbm.handler.guncfg.BulletConfigFactory;
import com.hbm.handler.guncfg.GunRocketFactory;
import com.hbm.interfaces.IBulletImpactBehavior;
import com.hbm.interfaces.IBulletUpdateBehavior;
import com.hbm.items.ModItems;
import com.hbm.lib.HBMSoundHandler;
import com.hbm.main.MainRegistry;
import com.hbm.packet.AuxParticlePacketNT;
import com.hbm.packet.PacketDispatcher;
import com.hbm.render.amlfrom1710.Vec3;
import com.hbm.util.BobMathUtil;
import com.hbm.util.ContaminationUtil;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GunNPCFactory {
    public static BulletConfiguration getMaskmanOrb() {
        BulletConfiguration bullet = new BulletConfiguration();
        bullet.ammo = ModItems.coin_maskman;
        bullet.velocity = 0.25f;
        bullet.spread = 0.0f;
        bullet.wear = 10;
        bullet.bulletsMin = 1;
        bullet.bulletsMax = 1;
        bullet.dmgMin = 100.0f;
        bullet.dmgMax = 100.0f;
        bullet.gravity = 0.0;
        bullet.maxAge = 60;
        bullet.doesRicochet = false;
        bullet.ricochetAngle = 0.0;
        bullet.HBRC = 0;
        bullet.LBRC = 0;
        bullet.bounceMod = 1.0;
        bullet.doesPenetrate = false;
        bullet.doesBreakGlass = false;
        bullet.style = 11;
        bullet.trail = 1;
        bullet.explosive = 1.5f;
        bullet.bUpdate = new IBulletUpdateBehavior(){

            @Override
            public void behaveUpdate(EntityBulletBase bullet) {
                if (bullet.field_70170_p.field_72995_K) {
                    return;
                }
                if (bullet.field_70173_aa % 10 != 5) {
                    return;
                }
                List players = bullet.field_70170_p.func_72872_a(EntityPlayer.class, bullet.func_174813_aQ().func_72314_b(50.0, 50.0, 50.0));
                for (EntityPlayer player : players) {
                    Vec3 motion = Vec3.createVectorHelper(player.field_70165_t - bullet.field_70165_t, player.field_70163_u + (double)player.func_70047_e() - bullet.field_70163_u, player.field_70161_v - bullet.field_70161_v);
                    motion = motion.normalize();
                    EntityBulletBase bolt = new EntityBulletBase(bullet.field_70170_p, BulletConfigSyncingUtil.MASKMAN_BOLT);
                    bolt.shooter = bullet.shooter;
                    bolt.func_70107_b(bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v);
                    bolt.func_70186_c(motion.xCoord, motion.yCoord, motion.zCoord, 0.5f, 0.05f);
                    bullet.field_70170_p.func_72838_d((Entity)bolt);
                }
            }
        };
        return bullet;
    }

    public static BulletConfiguration getMaskmanBolt() {
        BulletConfiguration bullet = BulletConfigFactory.standardBulletConfig();
        bullet.ammo = ModItems.coin_maskman;
        bullet.spread = 0.0f;
        bullet.dmgMin = 15.0f;
        bullet.dmgMax = 20.0f;
        bullet.wear = 10;
        bullet.leadChance = 0;
        bullet.explosive = 0.5f;
        bullet.setToBolt(0);
        bullet.vPFX = "reddust";
        return bullet;
    }

    public static BulletConfiguration getMaskmanBullet() {
        BulletConfiguration bullet = BulletConfigFactory.standardBulletConfig();
        bullet.ammo = ModItems.coin_maskman;
        bullet.spread = 0.0f;
        bullet.dmgMin = 5.0f;
        bullet.dmgMax = 10.0f;
        bullet.wear = 10;
        bullet.leadChance = 15;
        bullet.style = 1;
        bullet.vPFX = "bluedust";
        return bullet;
    }

    public static BulletConfiguration getMaskmanTracer() {
        BulletConfiguration bullet = BulletConfigFactory.standardBulletConfig();
        bullet.ammo = ModItems.coin_maskman;
        bullet.spread = 0.0f;
        bullet.dmgMin = 15.0f;
        bullet.dmgMax = 20.0f;
        bullet.wear = 10;
        bullet.leadChance = 0;
        bullet.setToBolt(1);
        bullet.vPFX = "reddust";
        bullet.bImpact = new IBulletImpactBehavior(){

            @Override
            public void behaveBlockHit(EntityBulletBase bullet, int x, int y, int z) {
                if (bullet.field_70170_p.field_72995_K) {
                    return;
                }
                EntityBulletBase meteor = new EntityBulletBase(bullet.field_70170_p, BulletConfigSyncingUtil.MASKMAN_METEOR);
                meteor.func_70107_b(bullet.field_70165_t, bullet.field_70163_u + 30.0 + (double)meteor.field_70170_p.field_73012_v.nextInt(10), bullet.field_70161_v);
                meteor.field_70181_x = -1.0;
                meteor.shooter = bullet.shooter;
                bullet.field_70170_p.func_72838_d((Entity)meteor);
            }
        };
        return bullet;
    }

    public static BulletConfiguration getMaskmanRocket() {
        BulletConfiguration bullet = BulletConfigFactory.standardGrenadeConfig();
        bullet.ammo = ModItems.coin_maskman;
        bullet.gravity = 0.1;
        bullet.velocity = 1.0f;
        bullet.dmgMin = 15.0f;
        bullet.dmgMax = 20.0f;
        bullet.blockDamage = false;
        bullet.explosive = 5.0f;
        bullet.style = 5;
        return bullet;
    }

    public static BulletConfiguration getMaskmanMeteor() {
        BulletConfiguration bullet = BulletConfigFactory.standardGrenadeConfig();
        bullet.ammo = ModItems.coin_maskman;
        bullet.gravity = 0.1;
        bullet.velocity = 1.0f;
        bullet.dmgMin = 20.0f;
        bullet.dmgMax = 30.0f;
        bullet.incendiary = 3;
        bullet.explosive = 2.5f;
        bullet.style = 12;
        bullet.bUpdate = new IBulletUpdateBehavior(){

            @Override
            public void behaveUpdate(EntityBulletBase bullet) {
                if (!bullet.field_70170_p.field_72995_K) {
                    return;
                }
                Random rand = bullet.field_70170_p.field_73012_v;
                for (int i = 0; i < 5; ++i) {
                    NBTTagCompound nbt = new NBTTagCompound();
                    nbt.func_74778_a("type", "vanillaExt");
                    nbt.func_74778_a("mode", "flame");
                    nbt.func_74780_a("posX", bullet.field_70165_t + rand.nextDouble() * 0.5 - 0.25);
                    nbt.func_74780_a("posY", bullet.field_70163_u + rand.nextDouble() * 0.5 - 0.25);
                    nbt.func_74780_a("posZ", bullet.field_70161_v + rand.nextDouble() * 0.5 - 0.25);
                    MainRegistry.proxy.effectNT(nbt);
                }
            }
        };
        return bullet;
    }

    public static BulletConfiguration getWormBolt() {
        BulletConfiguration bullet = BulletConfigFactory.standardBulletConfig();
        bullet.ammo = ModItems.coin_worm;
        bullet.spread = 0.0f;
        bullet.maxAge = 60;
        bullet.dmgMin = 15.0f;
        bullet.dmgMax = 25.0f;
        bullet.leadChance = 0;
        bullet.doesRicochet = false;
        bullet.setToBolt(4);
        return bullet;
    }

    public static BulletConfiguration getWormHeadBolt() {
        BulletConfiguration bullet = BulletConfigFactory.standardBulletConfig();
        bullet.ammo = ModItems.coin_worm;
        bullet.spread = 0.0f;
        bullet.maxAge = 100;
        bullet.dmgMin = 35.0f;
        bullet.dmgMax = 60.0f;
        bullet.leadChance = 0;
        bullet.doesRicochet = false;
        bullet.setToBolt(2);
        return bullet;
    }

    public static BulletConfiguration getRocketUFOConfig() {
        BulletConfiguration bullet = GunRocketFactory.getRocketConfig();
        bullet.vPFX = "reddust";
        bullet.destroysBlocks = false;
        bullet.explosive = 0.0f;
        bullet.bUpdate = new IBulletUpdateBehavior(){
            double angle = 90.0;
            double range = 100.0;

            @Override
            public void behaveUpdate(EntityBulletBase bullet) {
                Entity target;
                if (bullet.field_70170_p.field_72995_K) {
                    return;
                }
                if (bullet.field_70170_p.func_73045_a(bullet.getEntityData().func_74762_e("homingTarget")) == null) {
                    this.chooseTarget(bullet);
                }
                if ((target = bullet.field_70170_p.func_73045_a(bullet.getEntityData().func_74762_e("homingTarget"))) != null) {
                    if (bullet.func_70032_d(target) < 5.0f) {
                        bullet.getConfig().bImpact.behaveBlockHit(bullet, -1, -1, -1);
                        bullet.func_70106_y();
                        return;
                    }
                    Vec3 delta = Vec3.createVectorHelper(target.field_70165_t - bullet.field_70165_t, target.field_70163_u + (double)(target.field_70131_O / 2.0f) - bullet.field_70163_u, target.field_70161_v - bullet.field_70161_v);
                    delta = delta.normalize();
                    double vel = Vec3.createVectorHelper(bullet.field_70159_w, bullet.field_70181_x, bullet.field_70179_y).lengthVector();
                    bullet.field_70159_w = delta.xCoord * vel;
                    bullet.field_70181_x = delta.yCoord * vel;
                    bullet.field_70179_y = delta.zCoord * vel;
                }
            }

            private void chooseTarget(EntityBulletBase bullet) {
                List entities = bullet.field_70170_p.func_72872_a(EntityLivingBase.class, bullet.func_174813_aQ().func_72314_b(this.range, this.range, this.range));
                Vec3 mot = Vec3.createVectorHelper(bullet.field_70159_w, bullet.field_70181_x, bullet.field_70179_y);
                EntityLivingBase target = null;
                double targetAngle = this.angle;
                for (EntityLivingBase e : entities) {
                    double deltaAngle;
                    double dist;
                    if (!e.func_70089_S() || e == bullet.shooter) continue;
                    Vec3 delta = Vec3.createVectorHelper(e.field_70165_t - bullet.field_70165_t, e.field_70163_u + (double)(e.field_70131_O / 2.0f) - bullet.field_70163_u, e.field_70161_v - bullet.field_70161_v);
                    RayTraceResult r = bullet.field_70170_p.func_147447_a(Vec3.createVectorHelper(bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v).toVec3d(), Vec3.createVectorHelper(e.field_70165_t, e.field_70163_u + (double)(e.field_70131_O / 2.0f), e.field_70161_v).toVec3d(), false, true, false);
                    if (r != null && r.field_72313_a != RayTraceResult.Type.MISS || !((dist = e.func_70068_e((Entity)bullet)) < this.range * this.range) || !((deltaAngle = BobMathUtil.getCrossAngle(mot, delta)) < targetAngle)) continue;
                    target = e;
                    targetAngle = deltaAngle;
                }
                if (target != null) {
                    bullet.getEntityData().func_74768_a("homingTarget", target.func_145782_y());
                }
            }
        };
        bullet.bImpact = new IBulletImpactBehavior(){

            @Override
            public void behaveBlockHit(EntityBulletBase bullet, int x, int y, int z) {
                bullet.field_70170_p.func_184148_a(null, bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v, HBMSoundHandler.ufoBlast, SoundCategory.HOSTILE, 5.0f, 0.9f + bullet.field_70170_p.field_73012_v.nextFloat() * 0.2f);
                bullet.field_70170_p.func_184148_a(null, bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v, SoundEvents.field_187619_bk, SoundCategory.HOSTILE, 5.0f, 0.5f);
                ContaminationUtil.radiate(bullet.field_70170_p, bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v, 50.0, 0.0f, 0.0f, 500.0f);
                for (int i = 0; i < 3; ++i) {
                    NBTTagCompound data = new NBTTagCompound();
                    data.func_74778_a("type", "plasmablast");
                    data.func_74776_a("r", 0.0f);
                    data.func_74776_a("g", 0.75f);
                    data.func_74776_a("b", 1.0f);
                    data.func_74776_a("pitch", -30.0f + 30.0f * (float)i);
                    data.func_74776_a("yaw", bullet.field_70170_p.field_73012_v.nextFloat() * 180.0f);
                    data.func_74776_a("scale", 5.0f);
                    PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(data, bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v), new NetworkRegistry.TargetPoint(bullet.field_70170_p.field_73011_w.getDimension(), bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v, 100.0));
                }
            }
        };
        return bullet;
    }
}

