/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler;

import com.hbm.forgefluid.ModForgeFluids;
import com.hbm.items.ModItems;
import com.hbm.items.special.ItemCell;
import com.hbm.items.tool.IItemAbility;
import com.hbm.lib.HBMSoundHandler;
import com.hbm.packet.AuxParticlePacketNT;
import com.hbm.packet.PacketDispatcher;
import com.hbm.potion.HbmPotion;
import com.hbm.util.ContaminationUtil;
import com.hbm.util.WeightedRandomObject;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class WeaponAbility {
    public abstract void onHit(World var1, EntityPlayer var2, Entity var3, IItemAbility var4);

    public abstract String getName();

    @SideOnly(value=Side.CLIENT)
    public abstract String getFullName();

    public static class FireAbility
    extends WeaponAbility {
        int duration;

        public FireAbility(int duration) {
            this.duration = duration;
        }

        @Override
        public void onHit(World world, EntityPlayer player, Entity victim, IItemAbility tool) {
            if (victim instanceof EntityLivingBase) {
                victim.func_70015_d(this.duration);
            }
        }

        @Override
        public String getName() {
            return "weapon.ability.fire";
        }

        @Override
        public String getFullName() {
            return I18n.func_135052_a((String)this.getName(), (Object[])new Object[0]) + " (" + this.duration + ")";
        }
    }

    public static class BeheaderAbility
    extends WeaponAbility {
        @Override
        public void onHit(World world, EntityPlayer player, Entity victim, IItemAbility tool) {
            if (victim instanceof EntityLivingBase && ((EntityLivingBase)victim).func_110143_aJ() <= 0.0f) {
                EntityLivingBase living = (EntityLivingBase)victim;
                if (living instanceof EntitySkeleton) {
                    living.func_70099_a(new ItemStack(Items.field_151144_bL, 1, 0), 0.0f);
                } else if (living instanceof EntityWitherSkeleton) {
                    living.func_70099_a(ItemCell.getFullCell(ModForgeFluids.amat), 0.0f);
                } else if (living instanceof EntityZombie) {
                    living.func_70099_a(new ItemStack(Items.field_151144_bL, 1, 2), 0.0f);
                } else if (living instanceof EntityCreeper) {
                    living.func_70099_a(new ItemStack(Items.field_151144_bL, 1, 4), 0.0f);
                } else if (living instanceof EntityPlayer) {
                    ItemStack head = new ItemStack(Items.field_151144_bL, 1, 3);
                    head.func_77982_d(new NBTTagCompound());
                    head.func_77978_p().func_74778_a("SkullOwner", ((EntityPlayer)living).func_145748_c_().func_150260_c());
                    living.func_70099_a(head, 0.0f);
                } else {
                    living.func_70099_a(new ItemStack(Items.field_151078_bh, 3, 0), 0.0f);
                    living.func_70099_a(new ItemStack(Items.field_151103_aS, 2, 0), 0.0f);
                }
            }
        }

        @Override
        public String getName() {
            return "weapon.ability.beheader";
        }

        @Override
        public String getFullName() {
            return I18n.func_135052_a((String)this.getName(), (Object[])new Object[0]);
        }
    }

    public static class ChainsawAbility
    extends WeaponAbility {
        int divider;

        public ChainsawAbility(int divider) {
            this.divider = divider;
        }

        @Override
        public void onHit(World world, EntityPlayer player, Entity victim, IItemAbility tool) {
            EntityLivingBase living;
            if (victim instanceof EntityLivingBase && (living = (EntityLivingBase)victim).func_110143_aJ() <= 0.0f) {
                WeightedRandomObject[] ammo = new WeightedRandomObject[]{new WeightedRandomObject(ModItems.ammo_12gauge, 10), new WeightedRandomObject(ModItems.ammo_12gauge_shrapnel, 5), new WeightedRandomObject(ModItems.ammo_12gauge_du, 3), new WeightedRandomObject(ModItems.ammo_20gauge, 10), new WeightedRandomObject(ModItems.ammo_20gauge_flechette, 5), new WeightedRandomObject(ModItems.ammo_20gauge_slug, 5), new WeightedRandomObject(ModItems.ammo_9mm, 10), new WeightedRandomObject(ModItems.ammo_9mm_ap, 5), new WeightedRandomObject(ModItems.ammo_5mm, 10), new WeightedRandomObject(ModItems.ammo_5mm_du, 3), new WeightedRandomObject(ModItems.ammo_556, 10), new WeightedRandomObject(ModItems.ammo_556_phosphorus, 5), new WeightedRandomObject(ModItems.ammo_556_flechette, 10), new WeightedRandomObject(ModItems.ammo_556_flechette_phosphorus, 5), new WeightedRandomObject(ModItems.ammo_50bmg, 10), new WeightedRandomObject(ModItems.ammo_50bmg_incendiary, 5), new WeightedRandomObject(ModItems.ammo_50bmg_ap, 5), new WeightedRandomObject(ModItems.ammo_grenade, 5), new WeightedRandomObject(ModItems.ammo_grenade_concussion, 3), new WeightedRandomObject(ModItems.ammo_grenade_phosphorus, 3), new WeightedRandomObject(ModItems.ammo_rocket, 5), new WeightedRandomObject(ModItems.ammo_rocket_glare, 5), new WeightedRandomObject(ModItems.ammo_rocket_phosphorus, 5), new WeightedRandomObject(ModItems.ammo_rocket_rpc, 1), new WeightedRandomObject(ModItems.syringe_metal_stimpak, 25)};
                int count = Math.min((int)Math.ceil(living.func_110138_aP() / (float)this.divider), 250);
                for (int i = 0; i < count; ++i) {
                    living.func_145779_a(((WeightedRandomObject)WeightedRandom.func_76271_a((Random)living.func_70681_au(), Arrays.asList(ammo))).asItem(), 1);
                    world.func_72838_d((Entity)new EntityXPOrb(world, living.field_70165_t, living.field_70163_u, living.field_70161_v, 1));
                }
                if (player instanceof EntityPlayerMP) {
                    NBTTagCompound data = new NBTTagCompound();
                    data.func_74778_a("type", "vanillaburst");
                    data.func_74768_a("count", count * 4);
                    data.func_74780_a("motion", 0.1);
                    data.func_74778_a("mode", "blockdust");
                    data.func_74768_a("block", Block.func_149682_b((Block)Blocks.field_150451_bX));
                    PacketDispatcher.wrapper.sendTo((IMessage)new AuxParticlePacketNT(data, living.field_70165_t, living.field_70163_u + (double)living.field_70131_O * 0.5, living.field_70161_v), (EntityPlayerMP)player);
                }
                world.func_184148_a(null, living.field_70165_t, living.field_70163_u + (double)living.field_70131_O * 0.5, living.field_70161_v, HBMSoundHandler.chainsaw, SoundCategory.PLAYERS, 0.5f, 1.0f);
            }
        }

        @Override
        public String getName() {
            return "weapon.ability.chainsaw";
        }

        @Override
        public String getFullName() {
            return I18n.func_135052_a((String)this.getName(), (Object[])new Object[0]) + " (1:" + this.divider + ")";
        }
    }

    public static class PhosphorusAbility
    extends WeaponAbility {
        int duration;

        public PhosphorusAbility(int duration) {
            this.duration = duration;
        }

        @Override
        public void onHit(World world, EntityPlayer player, Entity victim, IItemAbility tool) {
            if (victim instanceof EntityLivingBase) {
                EntityLivingBase living = (EntityLivingBase)victim;
                living.func_70690_d(new PotionEffect((Potion)HbmPotion.phosphorus, this.duration * 20, 4));
            }
        }

        @Override
        public String getName() {
            return "weapon.ability.phosphorus";
        }

        @Override
        public String getFullName() {
            return I18n.func_135052_a((String)this.getName(), (Object[])new Object[0]) + " (" + this.duration + ")";
        }
    }

    public static class StunAbility
    extends WeaponAbility {
        int duration;

        public StunAbility(int duration) {
            this.duration = duration;
        }

        @Override
        public void onHit(World world, EntityPlayer player, Entity victim, IItemAbility tool) {
            if (victim instanceof EntityLivingBase) {
                EntityLivingBase living = (EntityLivingBase)victim;
                living.func_70690_d(new PotionEffect(MobEffects.field_76421_d, this.duration * 20, 4));
                living.func_70690_d(new PotionEffect(MobEffects.field_76437_t, this.duration * 20, 4));
            }
        }

        @Override
        public String getName() {
            return "weapon.ability.stun";
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public String getFullName() {
            return I18n.func_135052_a((String)this.getName(), (Object[])new Object[0]) + " (" + this.duration + ")";
        }
    }

    public static class VampireAbility
    extends WeaponAbility {
        float amount;

        public VampireAbility(float amount) {
            this.amount = amount;
        }

        @Override
        public void onHit(World world, EntityPlayer player, Entity victim, IItemAbility tool) {
            if (victim instanceof EntityLivingBase) {
                EntityLivingBase living = (EntityLivingBase)victim;
                living.func_70606_j(living.func_110143_aJ() - this.amount);
                player.func_70691_i(this.amount);
            }
        }

        @Override
        public String getName() {
            return "weapon.ability.vampire";
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public String getFullName() {
            return I18n.func_135052_a((String)this.getName(), (Object[])new Object[0]) + " (" + this.amount + ")";
        }
    }

    public static class RadiationAbility
    extends WeaponAbility {
        float rad;

        public RadiationAbility(float rad) {
            this.rad = rad;
        }

        @Override
        public void onHit(World world, EntityPlayer player, Entity victim, IItemAbility tool) {
            if (victim instanceof EntityLivingBase) {
                ContaminationUtil.contaminate((EntityLivingBase)victim, ContaminationUtil.HazardType.RADIATION, ContaminationUtil.ContaminationType.CREATIVE, this.rad);
            }
        }

        @Override
        public String getName() {
            return "weapon.ability.radiation";
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public String getFullName() {
            return I18n.func_135052_a((String)this.getName(), (Object[])new Object[0]) + " (" + this.rad + ")";
        }
    }
}

