/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.machine;

import com.hbm.blocks.ModBlocks;
import com.hbm.handler.RadiationSystemNT;
import com.hbm.interfaces.IBomb;
import com.hbm.interfaces.IDoor;
import com.hbm.interfaces.IMultiBlock;
import com.hbm.interfaces.IRadResistantBlock;
import com.hbm.items.ModItems;
import com.hbm.items.tool.ItemLock;
import com.hbm.tileentity.machine.TileEntitySiloHatch;
import com.hbm.util.I18nUtil;
import java.util.List;
import micdoodle8.mods.galacticraft.api.block.IPartialSealableBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;

@Optional.InterfaceList(value={@Optional.Interface(iface="micdoodle8.mods.galacticraft.api.block.IPartialSealableBlock", modid="galacticraftcore")})
public class BlockSiloHatch
extends BlockContainer
implements IBomb,
IMultiBlock,
IRadResistantBlock,
IPartialSealableBlock {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;

    public BlockSiloHatch(Material materialIn, String s) {
        super(materialIn);
        this.func_149663_c(s);
        this.setRegistryName(s);
        ModBlocks.ALL_BLOCKS.add((Block)this);
    }

    public boolean isSealed(World world, BlockPos blockPos, EnumFacing direction) {
        TileEntity entity;
        if (world != null && (entity = world.func_175625_s(blockPos)) != null && IDoor.class.isAssignableFrom(entity.getClass())) {
            return ((IDoor)entity).getState() == IDoor.DoorState.CLOSED;
        }
        return false;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntitySiloHatch();
    }

    @Override
    public void explode(World world, BlockPos pos) {
        TileEntitySiloHatch entity = (TileEntitySiloHatch)world.func_175625_s(pos);
        if (entity != null && !entity.isLocked()) {
            entity.tryToggle();
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (player.func_184614_ca().func_77973_b() instanceof ItemLock || player.func_184614_ca().func_77973_b() == ModItems.key_kit) {
            return false;
        }
        if (!player.func_70093_af()) {
            TileEntitySiloHatch entity = (TileEntitySiloHatch)world.func_175625_s(pos);
            if (entity != null && entity.canAccess(player)) {
                entity.tryToggle();
                return true;
            }
            return false;
        }
        return false;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntitySiloHatch te = (TileEntitySiloHatch)world.func_175625_s(pos);
        BlockPos center = pos.func_177967_a(placer.func_174811_aO(), 3);
        for (int i = -3; i <= 3; ++i) {
            for (int j = -3; j <= 3; ++j) {
                BlockPos b;
                if (Math.abs(i) == 3 && Math.abs(j) == 3 || Math.abs(i) == 2 && Math.abs(j) == 3 || Math.abs(i) == 3 && Math.abs(j) == 2 || (b = center.func_177982_a(i, 0, j)).equals((Object)pos) || te.placeDummy(b)) continue;
                world.func_175655_b(pos, true);
                return;
            }
        }
        world.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()), 2);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return false;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        RadiationSystemNT.markChunkForRebuild(world, pos);
        super.func_176213_c(world, pos, state);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        RadiationSystemNT.markChunkForRebuild(world, pos);
        super.func_180663_b(world, pos, state);
    }

    @Override
    public boolean isRadResistant(World worldIn, BlockPos blockPos) {
        TileEntity entity;
        if (worldIn != null && (entity = worldIn.func_175625_s(blockPos)) != null && IDoor.class.isAssignableFrom(entity.getClass())) {
            return ((IDoor)entity).getState() == IDoor.DoorState.CLOSED;
        }
        return true;
    }

    public void func_190948_a(ItemStack stack, World player, List<String> tooltip, ITooltipFlag advanced) {
        float hardness = this.func_149638_a(null);
        tooltip.add("\u00a72[" + I18nUtil.resolveKey("trait.radshield", new Object[0]) + "]");
        if (hardness > 50.0f) {
            tooltip.add("\u00a76" + I18nUtil.resolveKey("trait.blastres", Float.valueOf(hardness)));
        }
    }
}

