/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.signals.signalbox.debug;

import com.troblecodings.signals.OpenSignalsMain;
import com.troblecodings.signals.handler.SignalStateFile;
import com.troblecodings.signals.handler.SignalStatePos;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import org.apache.logging.log4j.Logger;

public class DebugSignalStateFile
extends SignalStateFile {
    private final HashMap<BlockPos, SignalStatePos> createdPositions = new HashMap();
    private final HashMap<BlockPos, SignalStatePos> foundPositions = new HashMap();
    private final HashMap<SignalStatePos, byte[]> dataCache = new HashMap();
    private final Logger logger = OpenSignalsMain.getLogger();

    public DebugSignalStateFile(Path path) {
        super(path);
    }

    @Override
    @Nullable
    public synchronized SignalStatePos create(BlockPos pos) {
        if (this.createdPositions.containsKey(pos)) {
            this.logger.warn("{} was already created!", (Object)pos.toString());
        }
        SignalStatePos statePos = super.create(pos);
        this.createdPositions.put(pos, statePos);
        return statePos;
    }

    @Override
    @Nullable
    public synchronized SignalStatePos find(BlockPos pos) {
        SignalStatePos oldPosition;
        SignalStatePos statePos = super.find(pos);
        if (this.foundPositions.containsKey(pos) && statePos != null && !(oldPosition = this.foundPositions.get(pos)).equals(statePos)) {
            this.logger.warn("{} unpersistent data detected!", (Object)pos.toString());
            this.logger.warn("Old: {}, New: {}", (Object)oldPosition.toString(), (Object)statePos.toString());
        }
        return statePos;
    }

    @Override
    @Nullable
    public synchronized ByteBuffer read(SignalStatePos pos) {
        byte[] array;
        ByteBuffer buffer = super.read(pos);
        if (this.dataCache.containsKey(pos) && !Arrays.equals(array = this.dataCache.get(pos), buffer.array())) {
            this.logger.warn("Data wrong from read!");
            this.logger.warn("Old: {}, New: {}", (Object)Arrays.toString(array), (Object)Arrays.toString(buffer.array()));
        }
        if (buffer.array().length != 256) {
            this.logger.warn("Wrong buffer size for read: {}!", (Object)buffer.array().length);
        }
        return buffer;
    }

    @Override
    public synchronized void write(SignalStatePos pos, ByteBuffer buffer) {
        if (buffer.array().length != 256) {
            this.logger.warn("Wrong buffer size for write: {}!", (Object)buffer.array().length);
        }
        super.write(pos, buffer);
        this.dataCache.put(pos, Arrays.copyOf(buffer.array(), buffer.array().length));
    }

    @Override
    public synchronized SignalStatePos deleteIndex(BlockPos pos) {
        SignalStatePos statePos = super.deleteIndex(pos);
        this.createdPositions.remove(pos);
        this.dataCache.remove(statePos);
        return statePos;
    }
}

