/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.signals.handler;

import com.google.common.collect.Maps;
import com.troblecodings.signals.OpenSignalsMain;
import com.troblecodings.signals.handler.SignalStatePos;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;

public class SignalStateFile {
    public static final int HEADER_SIZE = 4;
    public static final int START_OFFSET = 8;
    public static final int MAX_ELEMENTS_PER_FILE = 16000;
    public static final int ALIGNMENT_PER_INDEX_ITEM = 16;
    public static final int SIZE_OF_INDEX = 256000;
    public static final int MAX_OFFSET_OF_INDEX = 256008;
    public static final byte HEADER_VERSION = 1;
    public static final int STATE_BLOCK_SIZE = 256;
    private static final byte[] DEFAULT_HEADER = new byte[]{1, 0, 0, 0};
    private final Path path;
    private final List<Path> pathCache = new ArrayList<Path>();
    private final HashMap<BlockPos, SignalStatePos> posCache = new HashMap();

    public SignalStateFile(Path path) {
        this.path = path;
        int count = 0;
        Path current = null;
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        while (Files.exists(current = path.resolve(String.valueOf(count++)), new LinkOption[0])) {
            this.pathCache.add(current);
        }
        if (this.pathCache.isEmpty()) {
            this.pathCache.add(this.createNextFile());
        }
    }

    public Map<BlockPos, ByteBuffer> getAllEntries() {
        HashMap<BlockPos, ByteBuffer> map = new HashMap<BlockPos, ByteBuffer>();
        for (int i = 0; i < this.pathCache.size(); ++i) {
            Path path = this.pathCache.get(i);
            try (RandomAccessFile stream = new RandomAccessFile(path.toFile(), "r");){
                ArrayList<Map.Entry> posList = new ArrayList<Map.Entry>();
                stream.seek(8L);
                do {
                    BlockPos pos = new BlockPos(stream.readInt(), stream.readInt(), stream.readInt());
                    long offset = Integer.toUnsignedLong(stream.readInt());
                    if (pos.equals((Object)BlockPos.field_177992_a)) continue;
                    posList.add(Maps.immutableEntry((Object)pos, (Object)offset));
                } while (stream.getFilePointer() < 256008L);
                int counter = i;
                posList.forEach(entry -> map.put((BlockPos)entry.getKey(), this.read(new SignalStatePos(counter, (Long)entry.getValue()))));
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return map;
    }

    private Path createNextFile() {
        Path nextFile = this.path.resolve(String.valueOf(this.pathCache.size()));
        try (RandomAccessFile stream = new RandomAccessFile(nextFile.toFile(), "rw");){
            stream.write(DEFAULT_HEADER);
            byte[] zeroMemory = new byte[256000];
            stream.write(zeroMemory);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return nextFile;
    }

    private static long hash(BlockPos pos) {
        return Integer.toUnsignedLong(pos.hashCode()) % 16000L * 16L + 8L;
    }

    @Nullable
    public synchronized SignalStatePos find(BlockPos pos) {
        SignalStatePos cachePos = this.posCache.get(pos);
        if (cachePos != null) {
            return cachePos;
        }
        return (SignalStatePos)this.internalFind(pos, (stream, blockPos, offset, file) -> new SignalStatePos(file, offset), "r");
    }

    public synchronized SignalStatePos deleteIndex(BlockPos pos) {
        this.internalFind(pos, (stream, blockPos, offset, file) -> {
            try {
                long pointer = stream.getFilePointer();
                stream.seek(pointer - 16L);
                stream.writeLong(0L);
                stream.writeLong(0L);
                this.posCache.remove(pos);
                return new SignalStatePos(file, offset);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }, "rw");
        return null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private synchronized Object internalFind(BlockPos pos, InternalFunction function, String access) {
lbl1:
        // 3 sources

        try {
            for (counter = 0; counter < this.pathCache.size(); ++counter) {
                next = this.pathCache.get(counter);
                stream = new RandomAccessFile(next.toFile(), access);
                var7_8 = null;
                try {
                    header = new byte[4];
                    stream.read(header);
                    if (header[0] != 1) ** GOTO lbl1
                    if (stream.readInt() == 0) {
                        var9_12 = null;
                        return var9_12;
                    }
                    hashOffset = SignalStateFile.hash(pos);
                    stream.seek(hashOffset);
                    currenPosition = null;
                    offset = 0L;
                    do {
                        currenPosition = new BlockPos(stream.readInt(), stream.readInt(), stream.readInt());
                        offset = Integer.toUnsignedLong(stream.readInt());
                        currentOffset = stream.getFilePointer();
                        if (currentOffset >= 256008L) {
                            stream.seek(8L);
                        }
                        if (currentOffset == hashOffset) ** GOTO lbl1
                    } while (!pos.equals((Object)currenPosition));
                    this.posCache.put(pos, new SignalStatePos(counter, offset));
                    var14_17 = function.apply(stream, currenPosition, offset, counter);
                    return var14_17;
                }
                catch (Throwable var8_10) {
                    var7_8 = var8_10;
                    throw var8_10;
                }
                finally {
                    if (stream != null) {
                        if (var7_8 != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable var9_11) {
                                var7_8.addSuppressed(var9_11);
                            }
                        } else {
                            stream.close();
                        }
                    }
                }
            }
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public synchronized ByteBuffer read(SignalStatePos pos) {
        try (RandomAccessFile stream = new RandomAccessFile(this.pathCache.get(pos.file).toFile(), "r");){
            ByteBuffer buffer = ByteBuffer.allocate(256);
            stream.seek(pos.offset);
            stream.read(buffer.array());
            ByteBuffer byteBuffer = buffer;
            return byteBuffer;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public synchronized void write(SignalStatePos pos, ByteBuffer buffer) {
        try (RandomAccessFile stream = new RandomAccessFile(this.pathCache.get(pos.file).toFile(), "rw");){
            stream.seek(pos.offset);
            stream.write(buffer.array());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Nullable
    public synchronized SignalStatePos create(BlockPos pos) {
        return this.create(pos, new byte[256]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public synchronized SignalStatePos create(BlockPos pos, byte[] array) {
        try {
            int lastFile = this.pathCache.size() - 1;
            Path path = this.pathCache.get(lastFile);
            try (RandomAccessFile stream = new RandomAccessFile(path.toFile(), "rw");){
                byte[] header = new byte[4];
                stream.read(header);
                if (header[0] != 1) {
                    OpenSignalsMain.getLogger().error("Header version miss match! No write!");
                    SignalStatePos signalStatePos = null;
                    return signalStatePos;
                }
                int addedElements = stream.readInt();
                if (addedElements >= 16000) {
                    this.pathCache.add(this.createNextFile());
                    SignalStatePos signalStatePos = this.create(pos);
                    return signalStatePos;
                }
                long offsetHash = SignalStateFile.hash(pos);
                stream.seek(offsetHash);
                while ((stream.readLong() | stream.readLong()) != 0L) {
                    if (stream.getFilePointer() >= 256008L) {
                        stream.seek(8L);
                    }
                    if (stream.getFilePointer() != offsetHash) continue;
                    OpenSignalsMain.getLogger().error("No free space in %s this should not happen", (Object)path.toString());
                    SignalStatePos signalStatePos = null;
                    return signalStatePos;
                }
                long actualOffset = stream.getFilePointer() - 16L;
                stream.seek(actualOffset);
                stream.writeInt(pos.func_177958_n());
                stream.writeInt(pos.func_177956_o());
                stream.writeInt(pos.func_177952_p());
                int offset = addedElements * 256 + 256008;
                stream.writeInt(offset);
                stream.seek(offset);
                stream.write(array);
                stream.seek(4L);
                stream.writeInt(addedElements + 1);
                SignalStatePos signalStatePos = new SignalStatePos(lastFile, offset);
                return signalStatePos;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public int hashCode() {
        return Objects.hash(this.path);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SignalStateFile other = (SignalStateFile)obj;
        return Objects.equals(this.path, other.path);
    }

    @FunctionalInterface
    public static interface InternalFunction {
        public Object apply(RandomAccessFile var1, BlockPos var2, long var3, int var5);
    }
}

