/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.signals.guis;

import com.troblecodings.core.ReadBuffer;
import com.troblecodings.core.WriteBuffer;
import com.troblecodings.guilib.ecs.ContainerBase;
import com.troblecodings.guilib.ecs.GuiInfo;
import com.troblecodings.guilib.ecs.interfaces.UIClientSync;
import com.troblecodings.signals.OpenSignalsMain;
import com.troblecodings.signals.SEProperty;
import com.troblecodings.signals.blocks.Signal;
import com.troblecodings.signals.enums.ChangeableStage;
import com.troblecodings.signals.enums.EnumMode;
import com.troblecodings.signals.enums.EnumState;
import com.troblecodings.signals.enums.SignalControllerNetwork;
import com.troblecodings.signals.handler.SignalStateHandler;
import com.troblecodings.signals.handler.SignalStateInfo;
import com.troblecodings.signals.tileentitys.IChunkLoadable;
import com.troblecodings.signals.tileentitys.RedstoneIOTileEntity;
import com.troblecodings.signals.tileentitys.SignalControllerTileEntity;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class ContainerSignalController
extends ContainerBase
implements UIClientSync,
IChunkLoadable {
    protected final Map<Integer, Map<SEProperty, String>> allRSStates = new HashMap<Integer, Map<SEProperty, String>>();
    protected final Map<EnumFacing, Map<EnumState, Integer>> enabledRSStates = new HashMap<EnumFacing, Map<EnumState, Integer>>();
    protected int lastProfile;
    protected EnumMode currentMode = EnumMode.MANUELL;
    protected BlockPos linkedRSInput = null;
    protected int linkedRSInputProfile = -1;
    private final Map<SEProperty, String> properties = new HashMap<SEProperty, String>();
    private Signal currentSignal = null;
    private List<SEProperty> propertiesList;
    private BlockPos linkedPos;
    private SignalControllerTileEntity controllerEntity;
    private int currentRSProfile;

    public ContainerSignalController(GuiInfo info) {
        super(info);
    }

    @Override
    public void sendAllDataToRemote() {
        this.sendProperitesToClient();
    }

    private void sendProperitesToClient() {
        if (this.info.pos == null) {
            return;
        }
        this.controllerEntity = (SignalControllerTileEntity)this.info.world.func_175625_s(this.info.pos);
        this.linkedPos = this.controllerEntity.getLinkedPosition();
        if (this.linkedPos == null) {
            return;
        }
        this.currentSignal = this.controllerEntity.getLinkedSignal();
        SignalStateInfo stateInfo = new SignalStateInfo(this.info.world, this.linkedPos, this.getSignal());
        Map<SEProperty, String> properties = SignalStateHandler.getStates(stateInfo);
        if (properties == null || properties.isEmpty()) {
            return;
        }
        this.properties.clear();
        this.properties.putAll(properties);
        HashMap<SEProperty, String> propertiesToSend = new HashMap<SEProperty, String>();
        properties.forEach((property, value) -> {
            if ((property.isChangabelAtStage(ChangeableStage.APISTAGE) || property.isChangabelAtStage(ChangeableStage.APISTAGE_NONE_CONFIG)) && property.testMap(properties)) {
                propertiesToSend.put((SEProperty)property, (String)value);
            }
        });
        HashMap<Byte, Map<SEProperty, String>> allStates = new HashMap<Byte, Map<SEProperty, String>>(this.controllerEntity.getAllStates());
        HashMap<Byte, Map> allStatesToSend = new HashMap<Byte, Map>();
        allStates.forEach((profile, props) -> {
            HashMap propsForProfile = new HashMap();
            props.forEach((property, value) -> {
                if ((property.isChangabelAtStage(ChangeableStage.APISTAGE) || property.isChangabelAtStage(ChangeableStage.APISTAGE_NONE_CONFIG)) && property.testMap(properties)) {
                    propsForProfile.put(property, value);
                }
            });
            allStatesToSend.put((Byte)profile, propsForProfile);
        });
        Map<EnumFacing, Map<EnumState, Byte>> enabledStates = this.controllerEntity.getEnabledStates();
        this.currentMode = this.controllerEntity.getLastMode();
        WriteBuffer buffer = new WriteBuffer();
        buffer.putBlockPos(stateInfo.pos);
        byte[] signalName = this.getSignal().getSignalTypeName().getBytes();
        buffer.putByte((byte)signalName.length);
        for (byte b : signalName) {
            buffer.putByte(b);
        }
        buffer.putByte((byte)this.currentMode.ordinal());
        buffer.putByte((byte)propertiesToSend.size());
        propertiesToSend.forEach((property, value) -> this.packPropertyToBuffer(buffer, stateInfo, (SEProperty)property, (String)value));
        buffer.putByte((byte)this.controllerEntity.getProfile());
        buffer.putByte((byte)allStatesToSend.size());
        allStatesToSend.forEach((profile, props) -> {
            buffer.putByte((Byte)profile);
            buffer.putByte((byte)props.size());
            props.forEach((property, value) -> this.packPropertyToBuffer(buffer, stateInfo, (SEProperty)property, (String)value));
        });
        buffer.putByte((byte)enabledStates.size());
        enabledStates.forEach((direction, states) -> {
            buffer.putByte((byte)direction.ordinal());
            buffer.putByte((byte)states.size());
            states.forEach((mode, profile) -> {
                buffer.putByte((byte)mode.ordinal());
                buffer.putByte((Byte)profile);
            });
        });
        BlockPos linkedRSInput = this.controllerEntity.getLinkedRSInput();
        buffer.putBoolean(linkedRSInput != null);
        if (linkedRSInput != null) {
            buffer.putBlockPos(linkedRSInput);
        }
        buffer.putBoolean(this.controllerEntity.getProfileRSInput() != -1);
        if (this.controllerEntity.getProfileRSInput() != -1) {
            buffer.putByte(this.controllerEntity.getProfileRSInput());
        }
        OpenSignalsMain.network.sendTo(this.info.player, buffer);
    }

    private void packPropertyToBuffer(WriteBuffer buffer, SignalStateInfo stateInfo, SEProperty property, String value) {
        buffer.putByte((byte)stateInfo.signal.getIDFromProperty(property));
        buffer.putByte((byte)property.getParent().getIDFromValue(value));
    }

    @Override
    public void deserializeClient(ReadBuffer buffer) {
        boolean isProfileInputenabled;
        this.linkedPos = buffer.getBlockPos();
        int nameSize = buffer.getByteToUnsignedInt();
        byte[] signalName = new byte[nameSize];
        for (int i = 0; i < nameSize; ++i) {
            signalName[i] = buffer.getByte();
        }
        this.currentSignal = Signal.SIGNALS.get(new String(signalName));
        this.currentMode = EnumMode.values()[buffer.getByteToUnsignedInt()];
        int size = buffer.getByteToUnsignedInt();
        this.propertiesList = this.currentSignal.getProperties();
        for (int i = 0; i < size; ++i) {
            SEProperty property = this.propertiesList.get(buffer.getByteToUnsignedInt());
            this.properties.put(property, property.getObjFromID(buffer.getByteToUnsignedInt()));
        }
        this.lastProfile = buffer.getByteToUnsignedInt();
        this.allRSStates.clear();
        int allStatesSize = buffer.getByteToUnsignedInt();
        for (int i = 0; i < allStatesSize; ++i) {
            int profile = buffer.getByteToUnsignedInt();
            int propertySize = buffer.getByteToUnsignedInt();
            HashMap<SEProperty, String> profileProps = new HashMap<SEProperty, String>();
            for (int j = 0; j < propertySize; ++j) {
                SEProperty property = this.propertiesList.get(buffer.getByteToUnsignedInt());
                String value = property.getObjFromID(buffer.getByteToUnsignedInt());
                profileProps.put(property, value);
            }
            this.allRSStates.put(profile, profileProps);
        }
        this.enabledRSStates.clear();
        int enabledStatesSize = buffer.getByteToUnsignedInt();
        for (int i = 0; i < enabledStatesSize; ++i) {
            EnumFacing direction = EnumFacing.values()[buffer.getByteToUnsignedInt()];
            int propSize = buffer.getByteToUnsignedInt();
            HashMap<EnumState, Integer> states = new HashMap<EnumState, Integer>();
            for (int j = 0; j < propSize; ++j) {
                EnumState mode = EnumState.of(buffer);
                states.put(mode, buffer.getByteToUnsignedInt());
            }
            this.enabledRSStates.put(direction, states);
        }
        boolean isInputConnected = buffer.getBoolean();
        if (isInputConnected) {
            this.linkedRSInput = buffer.getBlockPos();
        }
        if (isProfileInputenabled = buffer.getBoolean()) {
            this.linkedRSInputProfile = buffer.getByteToUnsignedInt();
        }
        this.update();
    }

    @Override
    public void deserializeServer(ReadBuffer buffer) {
        if (this.propertiesList == null) {
            this.propertiesList = this.getSignal().getProperties();
        }
        SignalControllerNetwork mode = buffer.getEnumValue(SignalControllerNetwork.class);
        switch (mode) {
            case SEND_MODE: {
                this.currentMode = EnumMode.of(buffer);
                this.controllerEntity.setLastMode(this.currentMode);
                break;
            }
            case SEND_RS_PROFILE: {
                this.currentRSProfile = buffer.getByteToUnsignedInt();
                break;
            }
            case SEND_PROPERTY: {
                SEProperty property = this.propertiesList.get(buffer.getByteToUnsignedInt());
                String value = property.getObjFromID(buffer.getByteToUnsignedInt());
                if (this.currentMode.equals((Object)EnumMode.MANUELL)) {
                    SignalStateHandler.setState(new SignalStateInfo(this.info.world, this.linkedPos, this.getSignal()), property, value);
                    break;
                }
                if (!this.currentMode.equals((Object)EnumMode.SINGLE)) break;
                this.controllerEntity.updateRedstoneProfile((byte)this.currentRSProfile, property, value);
                break;
            }
            case REMOVE_PROPERTY: {
                if (!this.currentMode.equals((Object)EnumMode.SINGLE)) break;
                SEProperty property = this.propertiesList.get(buffer.getByteToUnsignedInt());
                this.controllerEntity.removePropertyFromProfile((byte)this.currentRSProfile, property);
                break;
            }
            case REMOVE_PROFILE: {
                EnumState state = EnumState.of(buffer);
                EnumFacing direction = ContainerSignalController.deserializeDirection(buffer);
                this.controllerEntity.removeProfileFromDirection(direction, state);
                break;
            }
            case SET_PROFILE: {
                EnumState state = EnumState.of(buffer);
                EnumFacing direction = ContainerSignalController.deserializeDirection(buffer);
                int profile = buffer.getByteToUnsignedInt();
                this.controllerEntity.updateEnabledStates(direction, state, profile);
                break;
            }
            case SET_RS_INPUT_PROFILE: {
                int profile = buffer.getByteToUnsignedInt();
                this.controllerEntity.setProfileRSInput((byte)profile);
                break;
            }
            case REMOVE_RS_INPUT_PROFILE: {
                this.controllerEntity.setProfileRSInput((byte)-1);
                break;
            }
            case UNLINK_INPUT_POS: {
                BlockPos linkedInput = this.controllerEntity.getLinkedRSInput();
                this.loadChunkAndGetTile(RedstoneIOTileEntity.class, this.info.world, linkedInput, (tile, _u) -> tile.unlinkController(this.info.pos));
                this.controllerEntity.setLinkedRSInput(null);
                break;
            }
        }
    }

    private static EnumFacing deserializeDirection(ReadBuffer buffer) {
        return EnumFacing.values()[buffer.getByteToUnsignedInt()];
    }

    public Map<SEProperty, String> getProperties() {
        return this.properties;
    }

    public Signal getSignal() {
        return this.currentSignal;
    }

    @Override
    public EntityPlayer getPlayer() {
        return this.info.player;
    }

    @Override
    public boolean func_75145_c(EntityPlayer playerIn) {
        if (playerIn instanceof EntityPlayerMP) {
            this.info.player = playerIn;
        }
        return true;
    }

    public BlockPos getPos() {
        return this.linkedPos;
    }
}

