/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.signals.guis;

import com.google.common.collect.Maps;
import com.troblecodings.core.I18Wrapper;
import com.troblecodings.core.ReadBuffer;
import com.troblecodings.core.WriteBuffer;
import com.troblecodings.guilib.ecs.ContainerBase;
import com.troblecodings.guilib.ecs.GuiInfo;
import com.troblecodings.guilib.ecs.interfaces.UIClientSync;
import com.troblecodings.signals.OpenSignalsMain;
import com.troblecodings.signals.core.ModeIdentifier;
import com.troblecodings.signals.core.StateInfo;
import com.troblecodings.signals.core.SubsidiaryEntry;
import com.troblecodings.signals.core.SubsidiaryState;
import com.troblecodings.signals.core.TrainNumber;
import com.troblecodings.signals.enums.EnumGuiMode;
import com.troblecodings.signals.enums.LinkType;
import com.troblecodings.signals.enums.SignalBoxNetwork;
import com.troblecodings.signals.handler.SignalBoxHandler;
import com.troblecodings.signals.signalbox.MainSignalIdentifier;
import com.troblecodings.signals.signalbox.ModeSet;
import com.troblecodings.signals.signalbox.Point;
import com.troblecodings.signals.signalbox.SignalBoxGrid;
import com.troblecodings.signals.signalbox.SignalBoxNode;
import com.troblecodings.signals.signalbox.SignalBoxPathway;
import com.troblecodings.signals.signalbox.SignalBoxTileEntity;
import com.troblecodings.signals.signalbox.entrys.PathEntryType;
import com.troblecodings.signals.signalbox.entrys.PathOptionEntry;
import com.troblecodings.signals.tileentitys.IChunkLoadable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;

public class ContainerSignalBox
extends ContainerBase
implements UIClientSync,
IChunkLoadable {
    protected final Map<Point, List<MainSignalIdentifier>> greenSignals = new HashMap<Point, List<MainSignalIdentifier>>();
    protected final Map<BlockPos, List<SubsidiaryState>> possibleSubsidiaries = new HashMap<BlockPos, List<SubsidiaryState>>();
    protected Map<Point, Map<ModeSet, SubsidiaryEntry>> enabledSubsidiaryTypes = new HashMap<Point, Map<ModeSet, SubsidiaryEntry>>();
    protected final List<Map.Entry<Point, Point>> nextPathways = new ArrayList<Map.Entry<Point, Point>>();
    protected final Map<BlockPos, List<Point>> validInConnections = new HashMap<BlockPos, List<Point>>();
    protected SignalBoxGrid grid;
    private final Map<BlockPos, LinkType> propertiesForType = new HashMap<BlockPos, LinkType>();
    private SignalBoxTileEntity tile;
    private EntityPlayer player;
    private Consumer<String> infoUpdates;
    private Consumer<List<SignalBoxNode>> colorUpdates;
    private Consumer<List<Point>> signalUpdates;
    private Runnable counterUpdater;
    private Consumer<List<Point>> trainNumberUpdater;

    public ContainerSignalBox(GuiInfo info) {
        super(info);
        this.tile = (SignalBoxTileEntity)info.getTile();
    }

    @Override
    public void sendAllDataToRemote() {
        this.grid = this.tile.getSignalBoxGrid();
        WriteBuffer buffer = new WriteBuffer();
        buffer.putEnumValue(SignalBoxNetwork.SEND_GRID);
        buffer.putBlockPos(this.info.pos);
        this.grid.writeNetwork(buffer);
        StateInfo identifier = new StateInfo(this.info.world, this.tile.func_174877_v());
        Map<BlockPos, List<SubsidiaryState>> possibleSubsidiaries = SignalBoxHandler.getPossibleSubsidiaries(identifier);
        Map<BlockPos, LinkType> positions = SignalBoxHandler.getAllLinkedPos(identifier);
        buffer.putInt(possibleSubsidiaries.size());
        possibleSubsidiaries.forEach((pos, list) -> {
            buffer.putBlockPos((BlockPos)pos);
            buffer.putByte((byte)list.size());
            list.forEach(state -> buffer.putByte((byte)state.getID()));
        });
        buffer.putInt(positions.size());
        positions.forEach((pos, type) -> {
            buffer.putBlockPos((BlockPos)pos);
            buffer.putByte((byte)type.ordinal());
        });
        List<Map.Entry<Point, Point>> nextPathways = this.grid.getNextPathways();
        buffer.putByte((byte)nextPathways.size());
        nextPathways.forEach(entry -> {
            ((Point)entry.getKey()).writeNetwork(buffer);
            ((Point)entry.getValue()).writeNetwork(buffer);
        });
        HashMap<BlockPos, List> validInConnections = new HashMap<BlockPos, List>();
        positions.entrySet().stream().filter(entry -> ((LinkType)entry.getValue()).equals(LinkType.SIGNALBOX)).forEach(entry -> {
            AtomicReference<SignalBoxGrid> grid = new AtomicReference<SignalBoxGrid>();
            grid.set(SignalBoxHandler.getGrid(new StateInfo(this.info.world, (BlockPos)entry.getKey())));
            if (grid.get() == null) {
                this.loadChunkAndGetTile(SignalBoxTileEntity.class, this.info.world, (BlockPos)entry.getKey(), (otherTile, _u) -> grid.set(otherTile.getSignalBoxGrid()));
            }
            if (grid.get() != null) {
                validInConnections.put((BlockPos)entry.getKey(), ((SignalBoxGrid)grid.get()).getAllInConnections());
            }
        });
        buffer.putByte((byte)validInConnections.size());
        validInConnections.forEach((pos, list) -> {
            buffer.putBlockPos((BlockPos)pos);
            buffer.putByte((byte)list.size());
            list.forEach(point -> point.writeNetwork(buffer));
        });
        List<MainSignalIdentifier> greenSignals = this.grid.getGreenSignals();
        buffer.putInt(greenSignals.size());
        greenSignals.forEach(signal -> signal.writeNetwork(buffer));
        OpenSignalsMain.network.sendTo(this.info.player, buffer);
    }

    @Override
    public void deserializeClient(ReadBuffer buffer) {
        SignalBoxNetwork mode = buffer.getEnumValue(SignalBoxNetwork.class);
        switch (mode) {
            case SEND_GRID: {
                BlockPos pos = buffer.getBlockPos();
                if (this.tile == null) {
                    this.tile = (SignalBoxTileEntity)this.info.world.func_175625_s(pos);
                }
                this.grid = this.tile.getSignalBoxGrid();
                this.grid.readNetwork(buffer);
                this.enabledSubsidiaryTypes = new HashMap<Point, Map<ModeSet, SubsidiaryEntry>>(this.grid.getAllSubsidiaries());
                this.propertiesForType.clear();
                this.possibleSubsidiaries.clear();
                this.nextPathways.clear();
                this.validInConnections.clear();
                this.greenSignals.clear();
                int signalSize = buffer.getInt();
                for (int i = 0; i < signalSize; ++i) {
                    BlockPos signalPos = buffer.getBlockPos();
                    this.propertiesForType.put(signalPos, LinkType.SIGNAL);
                    ArrayList<SubsidiaryState> validSubsidiaries = new ArrayList<SubsidiaryState>();
                    int listSize = buffer.getByteToUnsignedInt();
                    for (int j = 0; j < listSize; ++j) {
                        validSubsidiaries.add(SubsidiaryState.ALL_STATES.get(buffer.getByteToUnsignedInt()));
                    }
                    this.possibleSubsidiaries.put(signalPos, validSubsidiaries);
                }
                int size = buffer.getInt();
                for (int i = 0; i < size; ++i) {
                    BlockPos blockPos = buffer.getBlockPos();
                    LinkType type = LinkType.of(buffer);
                    this.propertiesForType.put(blockPos, type);
                }
                int nextPathwaySize = buffer.getByteToUnsignedInt();
                for (int i = 0; i < nextPathwaySize; ++i) {
                    Point start = Point.of(buffer);
                    Point end = Point.of(buffer);
                    this.nextPathways.add(Maps.immutableEntry((Object)start, (Object)end));
                }
                int validInConnectionsSize = buffer.getByteToUnsignedInt();
                for (int i = 0; i < validInConnectionsSize; ++i) {
                    BlockPos boxPos = buffer.getBlockPos();
                    ArrayList<Point> points = new ArrayList<Point>();
                    int listSize = buffer.getByteToUnsignedInt();
                    for (int j = 0; j < listSize; ++j) {
                        points.add(Point.of(buffer));
                    }
                    this.validInConnections.put(boxPos, points);
                }
                int greenSignalsSize = buffer.getInt();
                for (int i = 0; i < greenSignalsSize; ++i) {
                    MainSignalIdentifier identifier = MainSignalIdentifier.of(buffer);
                    Map subsidiary = this.enabledSubsidiaryTypes.getOrDefault(identifier.getPoint(), new HashMap());
                    SubsidiaryEntry entry = (SubsidiaryEntry)subsidiary.get(identifier.getModeSet());
                    if (entry != null) {
                        identifier.state = MainSignalIdentifier.SignalState.combine(entry.enumValue.getSubsidiaryShowType());
                    }
                    List greenSignals = this.greenSignals.computeIfAbsent(identifier.getPoint(), _u -> new ArrayList());
                    greenSignals.add(identifier);
                }
                this.enabledSubsidiaryTypes.forEach((point, map) -> map.forEach((modeSet, subsidiary) -> {
                    MainSignalIdentifier identifier = new MainSignalIdentifier(new ModeIdentifier((Point)point, (ModeSet)modeSet), this.grid.getNode((Point)point).getOption((ModeSet)modeSet).get().getEntry(PathEntryType.SIGNAL).get(), MainSignalIdentifier.SignalState.combine(subsidiary.enumValue.getSubsidiaryShowType()));
                    List greenSignals = this.greenSignals.computeIfAbsent(identifier.getPoint(), _u -> new ArrayList());
                    greenSignals.add(identifier);
                }));
                this.update();
                break;
            }
            case SEND_PW_UPDATE: {
                this.colorUpdates.accept(this.grid.readUpdateNetwork(buffer, false));
                break;
            }
            case NO_PW_FOUND: {
                this.infoUpdates.accept(I18Wrapper.format("error.nopathfound", new Object[0]));
                break;
            }
            case ADDED_TO_SAVER: {
                Point start = Point.of(buffer);
                Point end = Point.of(buffer);
                this.nextPathways.add(Maps.immutableEntry((Object)start, (Object)end));
                this.infoUpdates.accept(I18Wrapper.format("info.pathwaysaver", new Object[0]));
                break;
            }
            case OUTPUT_UPDATE: {
                Point point2 = Point.of(buffer);
                ModeSet modeSet = ModeSet.of(buffer);
                boolean state = buffer.getBoolean();
                SignalBoxNode node = this.grid.getNode(point2);
                if (state) {
                    node.addManuellOutput(modeSet);
                    break;
                }
                node.removeManuellOutput(modeSet);
                break;
            }
            case REMOVE_SAVEDPW: {
                Point start = Point.of(buffer);
                Point end = Point.of(buffer);
                this.nextPathways.remove(Maps.immutableEntry((Object)start, (Object)end));
                break;
            }
            case SET_SIGNALS: {
                ArrayList<Point> pointUpdates = new ArrayList<Point>();
                int redSignalSize = buffer.getByteToUnsignedInt();
                for (int i = 0; i < redSignalSize; ++i) {
                    MainSignalIdentifier identifier = MainSignalIdentifier.of(buffer);
                    this.greenSignals.remove(identifier.getPoint());
                    pointUpdates.add(identifier.getPoint());
                    this.removeFromEnabledSubsidiaries(identifier);
                }
                int greenSignalSize = buffer.getByteToUnsignedInt();
                for (int i = 0; i < greenSignalSize; ++i) {
                    MainSignalIdentifier modeIdentifier = MainSignalIdentifier.of(buffer);
                    List greenSignals = this.greenSignals.computeIfAbsent(modeIdentifier.getPoint(), _u -> new ArrayList());
                    Map subsidiary = this.enabledSubsidiaryTypes.getOrDefault(modeIdentifier.getPoint(), new HashMap());
                    SubsidiaryEntry entry = (SubsidiaryEntry)subsidiary.get(modeIdentifier.getModeSet());
                    if (entry != null) {
                        modeIdentifier.state = MainSignalIdentifier.SignalState.combine(entry.enumValue.getSubsidiaryShowType());
                    }
                    if (!greenSignals.contains(modeIdentifier)) {
                        greenSignals.add(modeIdentifier);
                    }
                    pointUpdates.add(modeIdentifier.getPoint());
                }
                this.signalUpdates.accept(pointUpdates);
                break;
            }
            case SEND_COUNTER: {
                this.grid.setCurrentCounter(buffer.getInt());
                this.counterUpdater.run();
                break;
            }
            case SEND_TRAIN_NUMBER: {
                ArrayList<Point> updates = new ArrayList<Point>();
                int size = buffer.getInt();
                for (int i = 0; i < size; ++i) {
                    Point point3 = Point.of(buffer);
                    TrainNumber number = TrainNumber.of(buffer);
                    this.grid.getNode(point3).setTrainNumber(number);
                    updates.add(point3);
                }
                this.trainNumberUpdater.accept(updates);
                break;
            }
        }
    }

    @Override
    public void deserializeServer(ReadBuffer buffer) {
        if (this.grid == null) {
            this.grid = this.tile.getSignalBoxGrid();
        }
        SignalBoxNetwork mode = buffer.getEnumValue(SignalBoxNetwork.class);
        switch (mode) {
            case SEND_INT_ENTRY: {
                this.deserializeEntry(buffer, buffer.getByteToUnsignedInt());
                break;
            }
            case REMOVE_ENTRY: {
                Point point = Point.of(buffer);
                EnumGuiMode guiMode = EnumGuiMode.of(buffer);
                Rotation rotation = ContainerSignalBox.deserializeRotation(buffer);
                PathEntryType<?> entryType = PathEntryType.ALL_ENTRIES.get(buffer.getByteToUnsignedInt());
                ModeSet modeSet = new ModeSet(guiMode, rotation);
                this.grid.getNode(point).getOption(modeSet).ifPresent(entry -> entry.removeEntry(entryType));
                break;
            }
            case SEND_POS_ENTRY: {
                this.deserializeEntry(buffer, buffer.getBlockPos());
                break;
            }
            case SEND_ZS2_ENTRY: {
                this.deserializeEntry(buffer, buffer.getByte());
                break;
            }
            case REMOVE_POS: {
                BlockPos pos = buffer.getBlockPos();
                SignalBoxHandler.unlinkPosFromSignalBox(new StateInfo(this.tile.func_145831_w(), this.tile.func_174877_v()), pos);
                break;
            }
            case RESET_PW: {
                boolean isShuntingPath;
                Point point = Point.of(buffer);
                SignalBoxPathway pw = this.grid.getPathwayByStartPoint(point);
                boolean bl = isShuntingPath = pw != null ? pw.isShuntingPath() : false;
                if (!this.grid.resetPathway(point) || isShuntingPath) break;
                this.grid.countOne();
                WriteBuffer sucess = new WriteBuffer();
                sucess.putEnumValue(SignalBoxNetwork.SEND_COUNTER);
                sucess.putInt(this.grid.getCurrentCounter());
                OpenSignalsMain.network.sendTo(this.info.player, sucess);
                break;
            }
            case REQUEST_PW: {
                Point start = Point.of(buffer);
                Point end = Point.of(buffer);
                if (this.grid.getNode(end).containsOutConnection()) {
                    if (SignalBoxHandler.requesetInterSignalBoxPathway(new StateInfo(this.info.world, this.info.pos), start, end)) break;
                    WriteBuffer error = new WriteBuffer();
                    error.putEnumValue(SignalBoxNetwork.NO_PW_FOUND);
                    OpenSignalsMain.network.sendTo(this.info.player, error);
                    break;
                }
                if (this.grid.requestWay(start, end)) break;
                if (this.grid.addNextPathway(start, end)) {
                    WriteBuffer sucess = new WriteBuffer();
                    sucess.putEnumValue(SignalBoxNetwork.ADDED_TO_SAVER);
                    start.writeNetwork(sucess);
                    end.writeNetwork(sucess);
                    OpenSignalsMain.network.sendTo(this.info.player, sucess);
                    break;
                }
                WriteBuffer error = new WriteBuffer();
                error.putEnumValue(SignalBoxNetwork.NO_PW_FOUND);
                OpenSignalsMain.network.sendTo(this.getInfo().player, error);
                break;
            }
            case RESET_ALL_PW: {
                this.grid.resetAllPathways();
                break;
            }
            case SEND_CHANGED_MODES: {
                this.grid.readUpdateNetwork(buffer, true);
                break;
            }
            case REQUEST_SUBSIDIARY: {
                SubsidiaryEntry entry2 = SubsidiaryEntry.of(buffer);
                Point point = Point.of(buffer);
                ModeSet modeSet = ModeSet.of(buffer);
                this.grid.updateSubsidiarySignal(point, modeSet, entry2);
                break;
            }
            case UPDATE_RS_OUTPUT: {
                Point point = Point.of(buffer);
                ModeSet modeSet = ModeSet.of(buffer);
                boolean state = buffer.getBoolean();
                BlockPos pos = this.grid.updateManuellRSOutput(point, modeSet, state);
                if (pos == null) break;
                SignalBoxHandler.updateRedstoneOutput(new StateInfo(this.info.world, pos), state);
                WriteBuffer sucess = new WriteBuffer();
                sucess.putEnumValue(SignalBoxNetwork.OUTPUT_UPDATE);
                point.writeNetwork(sucess);
                modeSet.writeNetwork(sucess);
                sucess.putBoolean(state);
                OpenSignalsMain.network.sendTo(this.info.player, sucess);
                break;
            }
            case SET_AUTO_POINT: {
                Point point = Point.of(buffer);
                boolean state = buffer.getBoolean();
                SignalBoxNode node = this.tile.getSignalBoxGrid().getNode(point);
                node.setAutoPoint(state);
                this.grid.updatePathwayToAutomatic(point);
                break;
            }
            case SEND_NAME: {
                Point point = Point.of(buffer);
                SignalBoxNode node = this.tile.getSignalBoxGrid().getNode(point);
                node.setCustomText(buffer.getString());
                break;
            }
            case SEND_SIGNAL_REPEATER: {
                Point point = Point.of(buffer);
                ModeSet modeSet = ModeSet.of(buffer);
                boolean state = buffer.getBoolean();
                SignalBoxNode node = this.tile.getSignalBoxGrid().getNode(point);
                Optional<PathOptionEntry> option = node.getOption(modeSet);
                if (option.isPresent()) {
                    option.get().setEntry(PathEntryType.SIGNAL_REPEATER, state);
                    break;
                }
                node.addAndSetEntry(modeSet, PathEntryType.SIGNAL_REPEATER, state);
                break;
            }
            case REMOVE_SAVEDPW: {
                Point start = Point.of(buffer);
                Point end = Point.of(buffer);
                this.grid.removeNextPathway(start, end);
                break;
            }
            case SEND_POINT_ENTRY: {
                this.deserializeEntry(buffer, Point.of(buffer));
                break;
            }
            case SEND_COUNTER: {
                this.grid.setCurrentCounter(buffer.getInt());
                break;
            }
            case SEND_TRAIN_NUMBER: {
                Point point = Point.of(buffer);
                TrainNumber number = TrainNumber.of(buffer);
                this.grid.updateTrainNumber(point, number);
                break;
            }
        }
    }

    private <T> void deserializeEntry(ReadBuffer buffer, T type) {
        ModeSet modeSet;
        Point point = Point.of(buffer);
        EnumGuiMode guiMode = EnumGuiMode.of(buffer);
        Rotation rotation = ContainerSignalBox.deserializeRotation(buffer);
        PathEntryType<?> entryType = PathEntryType.ALL_ENTRIES.get(buffer.getByteToUnsignedInt());
        SignalBoxNode node = this.tile.getSignalBoxGrid().getNode(point);
        Optional<PathOptionEntry> option = node.getOption(modeSet = new ModeSet(guiMode, rotation));
        if (option.isPresent()) {
            option.get().setEntry(entryType, type);
        } else {
            node.addAndSetEntry(modeSet, entryType, type);
        }
    }

    private static Rotation deserializeRotation(ReadBuffer buffer) {
        return Rotation.values()[buffer.getByteToUnsignedInt()];
    }

    private void removeFromEnabledSubsidiaries(MainSignalIdentifier identifier) {
        Map<ModeSet, SubsidiaryEntry> map = this.enabledSubsidiaryTypes.get(identifier.getPoint());
        if (map == null) {
            return;
        }
        map.remove(identifier.getModeSet());
        if (map.isEmpty()) {
            this.enabledSubsidiaryTypes.remove(identifier.getPoint());
        }
    }

    public void func_75134_a(EntityPlayer playerIn) {
        super.func_75134_a(playerIn);
        if (this.tile != null) {
            this.tile.remove(this);
        }
    }

    @Override
    public EntityPlayer getPlayer() {
        return this.player;
    }

    public Map<BlockPos, LinkType> getPositionForTypes() {
        return this.propertiesForType;
    }

    @Override
    public boolean func_75145_c(EntityPlayer playerIn) {
        if (this.tile.isBlocked() && !this.tile.isValid(playerIn)) {
            return false;
        }
        if (this.player == null) {
            this.player = playerIn;
            this.tile.add(this);
        }
        return true;
    }

    protected void setConsumer(Consumer<String> run) {
        this.infoUpdates = run;
    }

    protected void setColorUpdater(Consumer<List<SignalBoxNode>> updater) {
        this.colorUpdates = updater;
    }

    protected void setSignalUpdater(Consumer<List<Point>> updater) {
        this.signalUpdates = updater;
    }

    protected void setConuterUpdater(Runnable run) {
        this.counterUpdater = run;
    }

    protected void setTrainNumberUpdater(Consumer<List<Point>> updater) {
        this.trainNumberUpdater = updater;
    }
}

