/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.signals.core;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.troblecodings.guilib.ecs.interfaces.IIntegerable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraftforge.common.property.IUnlistedProperty;

public class JsonEnum
implements IIntegerable<String>,
IUnlistedProperty<String> {
    private final String name;
    private final List<String> values;
    private final Map<String, Integer> valueToInt;
    public static final JsonEnum BOOLEAN = new JsonEnum("boolean", (List<String>)ImmutableList.of((Object)"false", (Object)"true"));

    public JsonEnum(String name, List<String> values) {
        this.name = name;
        this.values = ImmutableList.copyOf(values);
        HashMap<String, Integer> copyValues = new HashMap<String, Integer>();
        for (int i = 0; i < values.size(); ++i) {
            copyValues.put(values.get(i).toLowerCase(), i);
        }
        this.valueToInt = ImmutableMap.copyOf(copyValues);
    }

    public int getIDFromValue(String value) {
        String name = value.toLowerCase();
        if (this.valueToInt.containsKey(name)) {
            return this.valueToInt.get(name);
        }
        return -1;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean isValid(String value) {
        return this.valueToInt.containsKey(value.toLowerCase());
    }

    public Class<String> getType() {
        return String.class;
    }

    public String valueToString(String value) {
        return value;
    }

    public Collection<String> getAllowedValues() {
        return this.values;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.valueToInt, this.values);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        JsonEnum other = (JsonEnum)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.valueToInt, other.valueToInt) && Objects.equals(this.values, other.values);
    }

    public Class<String> getValueClass() {
        return this.getType();
    }

    public Optional<String> parseValue(String value) {
        if (this.isValid(value)) {
            return Optional.of((Object)value);
        }
        return Optional.absent();
    }

    public String getName(String value) {
        return value;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String getObjFromID(int obj) {
        if (obj < 0 || obj >= this.values.size()) {
            return "";
        }
        return this.values.get(obj);
    }

    @Override
    public int count() {
        return this.values.size();
    }
}

