/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.api.material;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import zmaster587.libVulpes.api.material.AllowedProducts;
import zmaster587.libVulpes.api.material.MaterialRegistry;
import zmaster587.libVulpes.api.material.MixedMaterial;

public class Material {
    String unlocalizedName;
    String tool;
    String[] oreDictNames;
    int harvestLevel;
    int allowedProducts;
    int color;
    int index;
    public MaterialRegistry registry;

    public Material(String unlocalizedName, String tool, int level, int color, int allowedProducts, boolean hasOre) {
        this(unlocalizedName, tool, level, color, hasOre ? AllowedProducts.getProductByName("ORE").getFlagValue() | allowedProducts : allowedProducts, new String[]{unlocalizedName});
    }

    public Material(String unlocalizedName, String tool, int level, int color, int allowedProducts, MixedMaterial ... products) {
        this(unlocalizedName, tool, level, color, allowedProducts | AllowedProducts.getProductByName("ORE").getFlagValue(), new String[]{unlocalizedName});
    }

    public Material(String unlocalizedName, String tool, int level, int color, int allowedProducts) {
        this(unlocalizedName, tool, level, color, allowedProducts | AllowedProducts.getProductByName("ORE").getFlagValue(), new String[]{unlocalizedName});
    }

    public Material(String unlocalizedName, String tool, int level, int color, int allowedProducts, String[] oreDictNames) {
        this.unlocalizedName = unlocalizedName;
        this.tool = tool;
        this.harvestLevel = level;
        this.oreDictNames = oreDictNames;
        this.allowedProducts = allowedProducts;
        this.color = color;
    }

    public boolean isVanilla() {
        return this.unlocalizedName.equals("Iron") || this.unlocalizedName.equals("Gold");
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Nonnull
    public ItemStack getProduct(AllowedProducts product, int amount) {
        if (this.isVanilla()) {
            if (this.unlocalizedName.equals("Iron")) {
                switch (product.getName()) {
                    case "INGOT": {
                        return new ItemStack(Items.field_151042_j, amount);
                    }
                    case "ORE": {
                        return new ItemStack(Blocks.field_150366_p, amount);
                    }
                    case "BLOCK": {
                        return new ItemStack(Blocks.field_150339_S, amount);
                    }
                }
            }
            if (this.unlocalizedName.equals("Gold")) {
                switch (product.getName()) {
                    case "INGOT": {
                        return new ItemStack(Items.field_151043_k, amount);
                    }
                    case "ORE": {
                        return new ItemStack(Blocks.field_150352_o, amount);
                    }
                    case "BLOCK": {
                        return new ItemStack(Blocks.field_150340_R, amount);
                    }
                }
            }
        }
        if (product.isBlock()) {
            return new ItemStack(this.registry.getBlockForProduct(product, this, this.index), amount, this.getMeta());
        }
        return new ItemStack(this.registry.oreProducts[product.ordinal()], amount, this.getMeta());
    }

    @Nonnull
    public ItemStack getProduct(AllowedProducts product) {
        return this.getProduct(product, 1);
    }

    public int getAllowedProducts() {
        return this.allowedProducts;
    }

    public int getHarvestLevel() {
        return this.harvestLevel;
    }

    public String getTool() {
        return this.tool;
    }

    public String getUnlocalizedName() {
        return this.unlocalizedName;
    }

    public String[] getOreDictNames() {
        return this.oreDictNames;
    }

    public int getColor() {
        return this.color;
    }

    @Deprecated
    public Block getBlock() {
        return this.registry.getBlockListForProduct(AllowedProducts.getProductByName("ORE")).get(this.index / 16);
    }

    public int getMeta() {
        return this.index % 16;
    }

    public int getIndex() {
        return this.index;
    }

    public static Material valueOfSafe(String str) {
        try {
            return MaterialRegistry.getMaterialFromName(str);
        }
        catch (Exception e) {
            return null;
        }
    }
}

