/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.integration;

import com.direwolf20.buildinggadgets.common.BuildingGadgets;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.HashSet;
import java.util.Set;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class IntegrationHandler {
    private static final Set<IIntegratedMod> MODS = new HashSet<IIntegratedMod>();

    public static void preInit(FMLPreInitializationEvent event) {
        for (ASMDataTable.ASMData asmData : event.getAsmData().getAll(IntegratedMod.class.getName())) {
            String name = asmData.getClassName();
            try {
                if (!Loader.isModLoaded((String)((String)asmData.getAnnotationInfo().get("value")))) continue;
                IIntegratedMod mod = Class.forName(name).asSubclass(IIntegratedMod.class).newInstance();
                mod.initialize(Phase.PRE_INIT);
                MODS.add(mod);
            }
            catch (Exception e) {
                BuildingGadgets.logger.error(String.format("Integration with %s failed", name), (Throwable)e);
            }
        }
    }

    public static void init() {
        MODS.forEach(mod -> mod.initialize(Phase.INIT));
    }

    public static void postInit() {
        MODS.forEach(mod -> mod.initialize(Phase.POST_INIT));
    }

    public static interface IIntegratedMod {
        public void initialize(Phase var1);
    }

    public static enum Phase {
        PRE_INIT,
        INIT,
        POST_INIT;

    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface IntegratedMod {
        public String value();
    }
}

