/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.opf.gui;

import com.creativemd.creativecore.common.gui.container.SubGui;
import com.creativemd.creativecore.common.gui.controls.gui.GuiAnalogeSlider;
import com.creativemd.creativecore.common.gui.controls.gui.GuiButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiCheckBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiLabel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiStateButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiSteppedSlider;
import com.creativemd.creativecore.common.gui.controls.gui.GuiTextfield;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlClickEvent;
import com.creativemd.opf.OPFrame;
import com.creativemd.opf.block.TileEntityPicFrame;
import com.creativemd.opf.client.DownloadThread;
import com.creativemd.opf.gui.GuiUrlTextfield;
import com.n247s.api.eventapi.eventsystem.CustomEventSubscribe;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class SubGuiPic
extends SubGui {
    public TileEntityPicFrame frame;
    public boolean editFacing;
    public float scaleMultiplier;
    public GuiTextfield url;
    public GuiButton save;

    public SubGuiPic(TileEntityPicFrame frame) {
        this(frame, false, 16);
    }

    public SubGuiPic(TileEntityPicFrame frame, boolean editFacing, int scaleSize) {
        super(200, editFacing ? 220 : 200);
        this.frame = frame;
        this.editFacing = editFacing;
        this.scaleMultiplier = 1.0f / (float)scaleSize;
    }

    public void createControls() {
        this.url = new GuiUrlTextfield(this, "url", this.frame.url, 0, 0, 194, 16);
        this.url.maxLength = 512;
        this.controls.add(this.url);
        this.controls.add(new GuiLabel(SubGuiPic.translate((String)(this.frame.error != null ? this.frame.error : "")), 0, 20, -65536));
        this.controls.add(new GuiButton("in-size-x", "<", 49, 30, 5, 12){

            public void onClicked(int x, int y, int button) {
                GuiTextfield sizeX = (GuiTextfield)SubGuiPic.this.get("sizeX");
                float width = 1.0f;
                try {
                    width = Float.parseFloat(sizeX.text);
                }
                catch (Exception e) {
                    width = 1.0f;
                }
                int scaled = (int)(width / SubGuiPic.this.scaleMultiplier);
                sizeX.text = Float.toString((float)(++scaled) * SubGuiPic.this.scaleMultiplier);
            }
        }.setRotation(90.0f));
        this.controls.add(new GuiButton("de-size-x", ">", 49, 40, 5, 12){

            public void onClicked(int x, int y, int button) {
                GuiTextfield sizeX = (GuiTextfield)SubGuiPic.this.get("sizeX");
                float width = 1.0f;
                try {
                    width = Float.parseFloat(sizeX.text);
                }
                catch (Exception e) {
                    width = 1.0f;
                }
                int scaled = (int)(width / SubGuiPic.this.scaleMultiplier);
                sizeX.text = Float.toString((float)(--scaled) * SubGuiPic.this.scaleMultiplier);
            }
        }.setRotation(90.0f));
        this.controls.add(new GuiButton("in-size-y", "<", 145, 30, 5, 12){

            public void onClicked(int x, int y, int button) {
                GuiTextfield sizeY = (GuiTextfield)SubGuiPic.this.get("sizeY");
                float height = 1.0f;
                try {
                    height = Float.parseFloat(sizeY.text);
                }
                catch (Exception e) {
                    height = 1.0f;
                }
                int scaled = (int)(height / SubGuiPic.this.scaleMultiplier);
                sizeY.text = Float.toString((float)(++scaled) * SubGuiPic.this.scaleMultiplier);
            }
        }.setRotation(90.0f));
        this.controls.add(new GuiButton("de-size-y", ">", 145, 40, 5, 12){

            public void onClicked(int x, int y, int button) {
                GuiTextfield sizeY = (GuiTextfield)SubGuiPic.this.get("sizeY");
                float height = 1.0f;
                try {
                    height = Float.parseFloat(sizeY.text);
                }
                catch (Exception e) {
                    height = 1.0f;
                }
                int scaled = (int)(height / SubGuiPic.this.scaleMultiplier);
                sizeY.text = Float.toString((float)(--scaled) * SubGuiPic.this.scaleMultiplier);
            }
        }.setRotation(90.0f));
        this.controls.add(new GuiTextfield("sizeX", this.frame.sizeX + "", 0, 33, 40, 15).setFloatOnly());
        this.controls.add(new GuiTextfield("sizeY", this.frame.sizeY + "", 96, 33, 40, 15).setFloatOnly());
        this.controls.add(new GuiButton("reX", "x->y", 62, 33, 25, 15){

            public void onClicked(int x, int y, int button) {
            }
        });
        this.controls.add(new GuiButton("reY", "y->x", 158, 33, 25, 15){

            public void onClicked(int x, int y, int button) {
            }
        });
        this.controls.add(new GuiCheckBox("flipX", "flip (x-axis)", 0, 50, this.frame.flippedX));
        this.controls.add(new GuiCheckBox("flipY", "flip (y-axis)", 75, 50, this.frame.flippedY));
        this.controls.add(new GuiStateButton("posX", (int)this.frame.posX, 0, 70, 70, new String[]{"left (x)", "center (x)", "right (x)"}));
        this.controls.add(new GuiStateButton("posY", (int)this.frame.posY, 80, 70, 70, new String[]{"top (y)", "center (y)", "bottom (y)"}));
        this.controls.add(new GuiStateButton("rotation", (int)this.frame.rotation, 0, 93, 80, 10, new String[]{"rotation: 0", "rotation: 1", "rotation: 2", "rotation: 3"}));
        this.controls.add(new GuiCheckBox("visibleFrame", "visible Frame", 90, 91, this.frame.visibleFrame));
        this.controls.add(new GuiLabel("transparency:", 0, 110));
        this.controls.add(new GuiAnalogeSlider("transparency", 80, 112, 109, 5, (double)this.frame.transparency, 0.0, 1.0));
        this.controls.add(new GuiLabel("brightness:", 0, 122));
        this.controls.add(new GuiAnalogeSlider("brightness", 80, 124, 109, 5, (double)this.frame.brightness, 0.0, 1.0));
        this.controls.add(new GuiLabel("rotation (h):", 0, 134));
        this.controls.add(new GuiAnalogeSlider("rotX", 67, 136, 122, 5, (double)this.frame.rotationX, -90.0, 90.0));
        this.controls.add(new GuiLabel("rotation (v):", 0, 146));
        this.controls.add(new GuiAnalogeSlider("rotY", 67, 148, 122, 5, (double)this.frame.rotationY, -90.0, 90.0));
        this.controls.add(new GuiLabel("render distance (blocks):", 0, 160));
        this.controls.add(new GuiSteppedSlider("renderDistance", 0, 174, 80, 14, this.frame.renderDistance, 5, 1024));
        this.controls.add(new GuiButton("reload", 90, 174){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onClicked(int x, int y, int button) {
                Object object = DownloadThread.LOCK;
                synchronized (object) {
                    if (GuiScreen.func_146272_n()) {
                        DownloadThread.loadedImages.clear();
                    } else {
                        GuiTextfield url = (GuiTextfield)SubGuiPic.this.get("url");
                        DownloadThread.loadedImages.remove(url.text);
                    }
                    SubGuiPic.this.frame.failed = false;
                    SubGuiPic.this.frame.texture = null;
                    SubGuiPic.this.frame.error = null;
                }
            }
        }.setCustomTooltip(new String[]{"Hold shift to reload all"}));
        this.save = new GuiButton("Save", 140, 174, 50){

            public void onClicked(int x, int y, int button) {
                NBTTagCompound nbt = new NBTTagCompound();
                GuiTextfield url = (GuiTextfield)SubGuiPic.this.get("url");
                GuiTextfield sizeX = (GuiTextfield)SubGuiPic.this.get("sizeX");
                GuiTextfield sizeY = (GuiTextfield)SubGuiPic.this.get("sizeY");
                GuiStateButton buttonPosX = (GuiStateButton)SubGuiPic.this.get("posX");
                GuiStateButton buttonPosY = (GuiStateButton)SubGuiPic.this.get("posY");
                GuiStateButton rotation = (GuiStateButton)SubGuiPic.this.get("rotation");
                GuiCheckBox flipX = (GuiCheckBox)SubGuiPic.this.get("flipX");
                GuiCheckBox flipY = (GuiCheckBox)SubGuiPic.this.get("flipY");
                GuiCheckBox visibleFrame = (GuiCheckBox)SubGuiPic.this.get("visibleFrame");
                GuiSteppedSlider renderDistance = (GuiSteppedSlider)SubGuiPic.this.get("renderDistance");
                GuiAnalogeSlider rotX = (GuiAnalogeSlider)SubGuiPic.this.get("rotX");
                GuiAnalogeSlider rotY = (GuiAnalogeSlider)SubGuiPic.this.get("rotY");
                GuiAnalogeSlider transparency = (GuiAnalogeSlider)SubGuiPic.this.get("transparency");
                GuiAnalogeSlider brightness = (GuiAnalogeSlider)SubGuiPic.this.get("brightness");
                nbt.func_74774_a("posX", (byte)buttonPosX.getState());
                nbt.func_74774_a("posY", (byte)buttonPosY.getState());
                nbt.func_74774_a("rotation", (byte)rotation.getState());
                nbt.func_74757_a("flippedX", flipX.value);
                nbt.func_74757_a("flippedY", flipY.value);
                nbt.func_74757_a("visibleFrame", visibleFrame.value);
                nbt.func_74768_a("render", (int)renderDistance.value);
                nbt.func_74776_a("rotX", (float)rotX.value);
                nbt.func_74776_a("rotY", (float)rotY.value);
                nbt.func_74776_a("transparency", (float)transparency.value);
                nbt.func_74776_a("brightness", (float)brightness.value);
                nbt.func_74778_a("url", url.text);
                float posX = 1.0f;
                float posY = 1.0f;
                try {
                    posX = Float.parseFloat(sizeX.text);
                }
                catch (Exception e) {
                    posX = 1.0f;
                }
                try {
                    posY = Float.parseFloat(sizeY.text);
                }
                catch (Exception e) {
                    posY = 1.0f;
                }
                nbt.func_74776_a("x", posX);
                nbt.func_74776_a("y", posY);
                nbt.func_74768_a("type", 0);
                if (SubGuiPic.this.editFacing) {
                    GuiStateButton facing = (GuiStateButton)SubGuiPic.this.get("facing");
                    nbt.func_74768_a("facing", facing.getState());
                }
                SubGuiPic.this.sendPacketToServer(nbt);
            }
        };
        this.save.setEnabled(OPFrame.CONFIG.canUse((EntityPlayer)SubGuiPic.mc.field_71439_g, this.url.text));
        this.controls.add(this.save);
        if (this.editFacing) {
            String[] names = new String[EnumFacing.field_82609_l.length];
            for (int i = 0; i < names.length; ++i) {
                names[i] = EnumFacing.field_82609_l[i].func_176610_l();
            }
            this.controls.add(new GuiStateButton("facing", this.frame.func_145832_p(), 0, 196, 50, names));
        }
    }

    @CustomEventSubscribe
    public void onClicked(GuiControlClickEvent event) {
        if (event.source.is(new String[]{"reX"}) || event.source.is(new String[]{"reY"})) {
            GuiTextfield sizeXField = (GuiTextfield)this.get("sizeX");
            GuiTextfield sizeYField = (GuiTextfield)this.get("sizeY");
            float x = 1.0f;
            try {
                x = Float.parseFloat(sizeXField.text);
            }
            catch (Exception e) {
                x = 1.0f;
            }
            float y = 1.0f;
            try {
                y = Float.parseFloat(sizeYField.text);
            }
            catch (Exception e) {
                y = 1.0f;
            }
            if (this.frame.texture != null) {
                if (event.source.is(new String[]{"reX"})) {
                    sizeYField.text = "" + (float)this.frame.texture.height / ((float)this.frame.texture.width / x);
                } else {
                    sizeXField.text = "" + (float)this.frame.texture.width / ((float)this.frame.texture.height / y);
                }
            }
        }
    }
}

