/*
 * Decompiled with CFR 0.152.
 */
package bletch.tektopiatrader.core;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Config(modid="tektopiatrader", category="")
@ParametersAreNonnullByDefault
public class ModConfig {
    @Config.LangKey(value="config.debug")
    public static final Debug debug = new Debug();
    @Config.LangKey(value="config.trader")
    public static final Trader trader = new Trader();

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent event) {
        if (event.getModID().equals("tektopiatrader")) {
            ConfigManager.sync((String)"tektopiatrader", (Config.Type)Config.Type.INSTANCE);
        }
    }

    public static class Trader {
        @Config.Comment(value={"The list of trade items for the trader, each trade item is worth 1 emerald. Must be in the format <modid>:<item/block>*<quantity> (Eg. minecraft:iron_ingot*64)"})
        @Config.LangKey(value="config.trader.trades")
        public String[] trades = new String[]{"minecraft:iron_ingot*64", "minecraft:gold_ingot*32", "minecraft:diamond*8", "minecraft:redstone_block*8", "minecraft:lapis_block*8"};
        @Config.Comment(value={"The number of trades that can be made for each item per day. Default: 5"})
        @Config.LangKey(value="config.trader.tradesperday")
        @Config.RangeInt(min=1, max=99999)
        public int tradesPerDay = 5;
        @Config.Comment(value={"If enabled, when trying to spawn a trader it will check the size of the village. The more villagers the less often the trader will spawn. Default: True"})
        @Config.LangKey(value="config.trader.checksvillagesize")
        public Boolean checksVillageSize = true;
    }

    public static class Debug {
        @Config.Comment(value={"If true, debug information will be output to the console."})
        @Config.LangKey(value="config.debug.enableDebug")
        public boolean enableDebug = false;
    }
}

