/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.permission;

import de.maxhenkel.voicechat.permission.Permission;
import de.maxhenkel.voicechat.permission.PermissionType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;

public class ForgePermission
implements Permission {
    private final String node;
    private DefaultPermissionLevel level;
    private final PermissionType type;

    public ForgePermission(String node, PermissionType type) {
        this.node = node;
        this.type = type;
        switch (type) {
            case NOONE: {
                this.level = DefaultPermissionLevel.NONE;
                break;
            }
            case EVERYONE: {
                this.level = DefaultPermissionLevel.ALL;
                break;
            }
            case OPS: {
                this.level = DefaultPermissionLevel.OP;
            }
        }
    }

    @Override
    public boolean hasPermission(EntityPlayerMP player) {
        return PermissionAPI.hasPermission((EntityPlayer)player, (String)this.node);
    }

    @Override
    public PermissionType getPermissionType() {
        return this.type;
    }

    public String getNode() {
        return this.node;
    }

    public DefaultPermissionLevel getLevel() {
        return this.level;
    }
}

