/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.widgets;

import de.maxhenkel.voicechat.gui.widgets.Slider;
import net.minecraft.client.Minecraft;

public abstract class DebouncedSlider
extends Slider {
    private boolean dragged;
    private double lastValue;

    public DebouncedSlider(int buttonId, int x, int y, int width, int height, double value) {
        super(buttonId, x, y, width, height, value);
        this.lastValue = value;
    }

    @Override
    public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
        boolean b = super.func_146116_c(mc, mouseX, mouseY);
        this.applyDebouncedInternal();
        return b;
    }

    @Override
    public void func_146119_b(Minecraft mc, int mouseX, int mouseY) {
        super.func_146119_b(mc, mouseX, mouseY);
        this.dragged = true;
        if (this.value >= 1.0 || this.value <= 0.0) {
            this.applyDebouncedInternal();
            this.dragged = false;
        }
    }

    @Override
    public void func_146118_a(int mouseX, int mouseY) {
        super.func_146118_a(mouseX, mouseY);
        if (this.dragged) {
            this.applyDebouncedInternal();
            this.dragged = false;
        }
    }

    private void applyDebouncedInternal() {
        if (this.value == this.lastValue) {
            return;
        }
        this.lastValue = this.value;
        this.applyDebounced();
    }

    public abstract void applyDebounced();
}

