/*
 * Decompiled with CFR 0.152.
 */
package bletch.tektopiainformation.waila;

import bletch.common.utils.TektopiaUtils;
import bletch.common.utils.TextUtils;
import bletch.tektopiainformation.core.ModConfig;
import bletch.tektopiainformation.utils.LoggerUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

@ParametersAreNonnullByDefault
public class TektopiaBlockWaila
implements IWailaDataProvider {
    public static final String KEY_SUFFIX_DESCRIPTION = ".description";
    public static final String KEY_SUFFIX_TOOLTIP = ".tooltip";

    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return null;
    }

    public List<String> getWailaHead(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currentTip;
    }

    public List<String> getWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        List<String> value;
        if (ModConfig.waila.useSneaking && !accessor.getPlayer().func_70093_af()) {
            return currentTip;
        }
        if (ModConfig.waila.blocks.showBlockTooltip) {
            String translateKey_tooltip = itemStack.func_77977_a() + KEY_SUFFIX_TOOLTIP;
            if (ModConfig.debug.enableDebug && ModConfig.debug.showWailaBlockTranslationKey) {
                currentTip.add(TextUtils.translate("gui.translationkey", new Object[0]) + " " + translateKey_tooltip);
            }
            if ((value = TextUtils.translateMulti(translateKey_tooltip, new Object[0])) != null && value.size() > 0) {
                currentTip.addAll(value);
            }
        }
        if (ModConfig.waila.blocks.showBlockInformation) {
            String translateKey_description = itemStack.func_77977_a() + KEY_SUFFIX_DESCRIPTION;
            if (ModConfig.debug.enableDebug && ModConfig.debug.showWailaBlockTranslationKey) {
                currentTip.add(TextUtils.translate("gui.translationkey", new Object[0]) + " " + translateKey_description);
            }
            if ((value = TextUtils.translateMulti(translateKey_description, new Object[0])) != null && value.size() > 0) {
                currentTip.addAll(value);
            }
        }
        return currentTip;
    }

    public List<String> getWailaTail(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currentTip;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity tileEntity, NBTTagCompound tag, World world, BlockPos position) {
        tileEntity.func_189515_b(tag);
        return tag;
    }

    public static void callbackRegister(IWailaRegistrar registrar) {
        TektopiaBlockWaila dataProvider = new TektopiaBlockWaila();
        ArrayList<String> processed = new ArrayList<String>();
        ArrayList tektopiaClasses = new ArrayList();
        tektopiaClasses.addAll(TektopiaUtils.getTektopiaBlockClasses());
        for (int i = tektopiaClasses.size() - 1; i >= 0; --i) {
            if (!tektopiaClasses.contains(((Class)tektopiaClasses.get(i)).getSuperclass())) continue;
            tektopiaClasses.remove(i);
        }
        for (Class clazz : tektopiaClasses) {
            String key = clazz.getTypeName();
            if (processed.contains(key)) continue;
            processed.add(key);
            registrar.registerNBTProvider((IWailaDataProvider)dataProvider, clazz);
            registrar.registerBodyProvider((IWailaDataProvider)dataProvider, clazz);
            if (!ModConfig.debug.enableDebug || !ModConfig.debug.showWailaBlocksRegistered) continue;
            LoggerUtils.instance.writeLine("Registered WAILA information for block " + key, true);
        }
    }
}

