/*
 * Decompiled with CFR 0.152.
 */
package bletch.tektopiainformation.network.data;

import bletch.common.utils.StringUtils;
import bletch.common.utils.TektopiaUtils;
import bletch.tektopiainformation.network.data.EntityData;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.village.MerchantRecipeList;
import net.tangotek.tektopia.ProfessionType;
import net.tangotek.tektopia.VillagerRole;
import net.tangotek.tektopia.entities.EntityArchitect;
import net.tangotek.tektopia.entities.EntityGuard;
import net.tangotek.tektopia.entities.EntityTradesman;
import net.tangotek.tektopia.entities.EntityVillageNavigator;
import net.tangotek.tektopia.entities.EntityVillagerTek;
import net.tangotek.tektopia.storage.VillagerInventory;
import net.tangotek.tektopia.structures.VillageStructure;

public class ResidentData
extends EntityData {
    protected static final String NBTTAG_VILLAGE_RESIDENTPROFESSIONTYPE = "prof";
    protected static final String NBTTAG_VILLAGE_RESIDENTMALE = "male";
    protected static final String NBTTAG_VILLAGE_RESIDENTCHILD = "child";
    protected static final String NBTTAG_VILLAGE_RESIDENTCAPTAIN = "captain";
    protected static final String NBTTAG_VILLAGE_RESIDENTVENDOR = "vendor";
    protected static final String NBTTAG_VILLAGE_RESIDENTVISITOR = "visitor";
    protected static final String NBTTAG_VILLAGE_RESIDENTSLEEPING = "sleep";
    protected static final String NBTTAG_VILLAGE_RESIDENTBASELEVEL = "baselvl";
    protected static final String NBTTAG_VILLAGE_RESIDENTBLESSEDLEVEL = "blesslvl";
    protected static final String NBTTAG_VILLAGE_RESIDENTDAYSALIVE = "days";
    protected static final String NBTTAG_VILLAGE_RESIDENTHUNGER = "hunger";
    protected static final String NBTTAG_VILLAGE_RESIDENTMAXHUNGER = "maxhunger";
    protected static final String NBTTAG_VILLAGE_RESIDENTHAPPY = "happy";
    protected static final String NBTTAG_VILLAGE_RESIDENTMAXHAPPY = "maxhappy";
    protected static final String NBTTAG_VILLAGE_RESIDENTINTELLIGENCE = "intell";
    protected static final String NBTTAG_VILLAGE_RESIDENTMAXINTELLIGENCE = "maxintell";
    protected static final String NBTTAG_VILLAGE_RESIDENTWORKSTART = "work1";
    protected static final String NBTTAG_VILLAGE_RESIDENTWORKFINISH = "work2";
    protected static final String NBTTAG_VILLAGE_RESIDENTSLEEPSTART = "sleep1";
    protected static final String NBTTAG_VILLAGE_RESIDENTSLEEPFINISH = "sleep2";
    protected static final String NBTTAG_VILLAGE_RESIDENTCANHAVEBED = "havebed";
    protected static final String NBTTAG_VILLAGE_RESIDENTBEDPOSITION = "bedpos";
    protected static final String NBTTAG_VILLAGE_RESIDENTCURRENTSTRUCTURE = "struct";
    protected static final String NBTTAG_VILLAGE_RESIDENTCURRENTTASK = "task";
    protected static final String NBTTAG_VILLAGE_RESIDENTADDPROF = "addprof";
    protected static final String NBTTAG_VILLAGE_RESIDENTADDPROFNAME = "name";
    protected static final String NBTTAG_VILLAGE_RESIDENTADDPROFLEVEL = "level";
    protected static final String NBTTAG_VILLAGE_RESIDENTAIFILTER = "aifilter";
    protected static final String NBTTAG_VILLAGE_RESIDENTAIFILTERNAME = "name";
    protected static final String NBTTAG_VILLAGE_RESIDENTAIFILTERENABLED = "on";
    protected static final String NBTTAG_VILLAGE_RESIDENTRECIPES = "recipes";
    protected static final String NBTTAG_VILLAGE_RESIDENTINVENTORY = "inv";
    protected static final String NBTTAG_VILLAGE_RESIDENTRECENTEATS = "eaten";
    protected static final List<Class> toolItemClasses = Arrays.asList(ItemAxe.class, ItemHoe.class, ItemSword.class, ItemPickaxe.class, ItemShears.class);
    protected String professionType;
    protected boolean isMale;
    protected boolean isChild;
    protected boolean isCaptain;
    protected boolean isVendor;
    protected boolean isVisitor;
    protected boolean isSleeping;
    protected int baseLevel;
    protected int blessedLevel;
    protected int daysAlive;
    protected int hunger;
    protected int maxHunger;
    protected int happy;
    protected int maxHappy;
    protected int intelligence;
    protected int maxIntelligence;
    protected int workStartTime;
    protected int workFinishTime;
    protected int sleepStartTime;
    protected int sleepFinishTime;
    protected Boolean canHaveBed;
    protected BlockPos bedPosition;
    protected BlockPos currentStructure;
    protected String currentTask;
    protected Map<String, Integer> additionalProfessions;
    protected Map<String, Boolean> aiFilters;
    protected MerchantRecipeList recipes;
    protected List<ItemStack> inventory;
    protected List<Integer> recentEats;

    protected ResidentData() {
    }

    public ResidentData(EntityVillagerTek villager) {
        super((EntityVillageNavigator)villager, false);
        this.populateData(villager);
    }

    protected ResidentData(EntityVillagerTek villager, Boolean populateVillager) {
        super((EntityVillageNavigator)villager, false);
        if (populateVillager.booleanValue()) {
            this.populateData(villager);
        }
    }

    public ResidentData(NBTTagCompound nbtTag) {
        this.readNBT(nbtTag);
    }

    public String getProfessionType() {
        return this.professionType;
    }

    public boolean isMale() {
        return this.isMale;
    }

    public boolean isChild() {
        return this.isChild;
    }

    public boolean isCaptain() {
        return this.isCaptain;
    }

    public boolean isVendor() {
        return this.isVendor;
    }

    public boolean isVisitor() {
        return this.isVisitor;
    }

    public boolean isSleeping() {
        return this.isSleeping;
    }

    public int getBaseLevel() {
        return this.baseLevel;
    }

    public int getBlessedLevel() {
        return this.blessedLevel;
    }

    public int getDaysAlive() {
        return this.daysAlive;
    }

    public int getHunger() {
        return this.hunger;
    }

    public int getMaxHunger() {
        return this.maxHunger;
    }

    public int getHappy() {
        return this.happy;
    }

    public int getMaxHappy() {
        return this.maxHappy;
    }

    public int getIntelligence() {
        return this.intelligence;
    }

    public int getMaxIntelligence() {
        return this.maxIntelligence;
    }

    public int getWorkStartSeconds() {
        return (int)Math.max(0.0f, (float)this.workStartTime / 0.27777776f);
    }

    public int getWorkStartTicks() {
        return (int)Math.max(0.0f, (float)this.workStartTime);
    }

    public int getWorkFinishSeconds() {
        return (int)Math.max(0.0f, (float)this.workFinishTime / 0.27777776f);
    }

    public int getWorkFinishTicks() {
        return (int)Math.max(0.0f, (float)this.workFinishTime);
    }

    public int getSleepStartSeconds() {
        return (int)Math.max(0.0f, (float)this.sleepStartTime / 0.27777776f);
    }

    public int getSleepStartTicks() {
        return (int)Math.max(0.0f, (float)this.sleepStartTime);
    }

    public int getSleepFinishSeconds() {
        return (int)Math.max(0.0f, (float)this.sleepFinishTime / 0.27777776f);
    }

    public int getSleepFinishTicks() {
        return (int)Math.max(0.0f, (float)this.sleepFinishTime);
    }

    public boolean getCanHaveBed() {
        return this.canHaveBed;
    }

    public BlockPos getBedPosition() {
        return this.bedPosition;
    }

    public boolean hasBed() {
        return this.bedPosition != null;
    }

    public BlockPos getCurrentStructure() {
        return this.currentStructure;
    }

    public String getCurrentTask() {
        return this.currentTask;
    }

    public boolean isBlessed() {
        return this.blessedLevel > 0;
    }

    public Map<String, Integer> getAdditionalProfessions() {
        return this.additionalProfessions == null ? Collections.unmodifiableMap(new LinkedHashMap()) : Collections.unmodifiableMap(this.additionalProfessions.entrySet().stream().sorted((c1, c2) -> Integer.compare((Integer)c2.getValue(), (Integer)c1.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new)));
    }

    public int getAdditionalProfessionsCount() {
        return this.additionalProfessions == null ? 0 : this.additionalProfessions.size();
    }

    public Map<String, Boolean> getAiFilters() {
        return this.aiFilters == null ? Collections.unmodifiableMap(new LinkedHashMap()) : Collections.unmodifiableMap(this.aiFilters.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new)));
    }

    public int getAiFiltersCount() {
        return this.aiFilters == null ? 0 : this.aiFilters.size();
    }

    public MerchantRecipeList getRecipeList() {
        return this.recipes == null ? new MerchantRecipeList() : this.recipes;
    }

    public List<ItemStack> getInventory() {
        return this.inventory == null ? new ArrayList() : this.inventory;
    }

    public int getInventoryCount() {
        return this.inventory == null ? 0 : this.inventory.size();
    }

    public List<ItemStack> getRecentEats() {
        return this.recentEats.stream().map(itemId -> new ItemStack(Item.func_150899_d((int)itemId))).collect(Collectors.toList());
    }

    public EntityVillagerTek getVillagerEntity() {
        if (entityList != null && entityList.size() > 0) {
            return entityList.stream().filter(e -> e instanceof EntityVillagerTek && e.func_145782_y() == this.getId()).findFirst().orElse(null);
        }
        return null;
    }

    @Override
    protected void clearData() {
        super.clearData();
        this.id = 0;
        this.professionType = null;
        this.isMale = false;
        this.isChild = false;
        this.isCaptain = false;
        this.isVendor = false;
        this.isVisitor = false;
        this.isSleeping = false;
        this.baseLevel = 0;
        this.blessedLevel = 0;
        this.daysAlive = 0;
        this.hunger = 0;
        this.maxHunger = 100;
        this.happy = 0;
        this.maxHappy = 100;
        this.intelligence = 0;
        this.maxIntelligence = 100;
        this.workStartTime = 0;
        this.workFinishTime = 0;
        this.sleepStartTime = 0;
        this.sleepFinishTime = 0;
        this.canHaveBed = false;
        this.bedPosition = null;
        this.currentStructure = null;
        this.currentTask = null;
        this.additionalProfessions = new LinkedHashMap<String, Integer>();
        this.aiFilters = new LinkedHashMap<String, Boolean>();
        this.recipes = null;
        this.inventory = null;
        this.recentEats = new ArrayList<Integer>();
    }

    protected void populateData(EntityVillagerTek villager) {
        super.populateData((EntityVillageNavigator)villager);
        if (villager != null) {
            ProfessionType villagerProfessionType = villager.getProfessionType();
            if (villagerProfessionType != null) {
                this.professionType = villagerProfessionType.name();
            }
            this.isMale = villager.isMale();
            if (villagerProfessionType != null) {
                boolean bl = this.isChild = villagerProfessionType == ProfessionType.CHILD || villager.func_70631_g_();
            }
            if (villagerProfessionType != null) {
                this.isCaptain = villagerProfessionType == ProfessionType.CAPTAIN || villager instanceof EntityGuard && ((EntityGuard)villager).isCaptain();
            }
            this.isVendor = villager.isRole(VillagerRole.VENDOR);
            this.isVisitor = villager.isRole(VillagerRole.VISITOR);
            this.isSleeping = villager.isSleeping();
            if (villagerProfessionType != null) {
                this.level = villager.getSkill(villagerProfessionType);
            }
            if (villagerProfessionType != null) {
                this.baseLevel = villager.getBaseSkill(villagerProfessionType);
            }
            this.blessedLevel = villager.getBlessed();
            this.daysAlive = villager.getDaysAlive();
            this.hunger = villager.getHunger();
            this.maxHunger = villager.getMaxHunger();
            this.happy = villager.getHappy();
            this.maxHappy = villager.getMaxHappy();
            this.intelligence = villager.getIntelligence();
            this.maxIntelligence = villager.getMaxIntelligence();
            int sleepOffset = TektopiaUtils.getVillagerSleepOffset(villager);
            this.workStartTime = TektopiaUtils.fixTime(EntityVillagerTek.WORK_START_TIME + sleepOffset);
            this.workFinishTime = TektopiaUtils.fixTime(EntityVillagerTek.WORK_END_TIME + sleepOffset);
            this.sleepStartTime = TektopiaUtils.fixTime(EntityVillagerTek.SLEEP_START_TIME + sleepOffset);
            this.sleepFinishTime = TektopiaUtils.fixTime(EntityVillagerTek.SLEEP_END_TIME + sleepOffset);
            this.bedPosition = villager.getBedPos();
            VillageStructure structure = villager.getCurrentStructure();
            if (structure == null && villager.getVillage() != null) {
                structure = villager.getVillage().getStructure(this.getCurrentPosition());
            }
            this.currentStructure = structure == null ? null : structure.getFramePos();
            for (EntityAITasks.EntityAITaskEntry entityAITaskEntry : villager.field_70714_bg.field_75782_a) {
                if (entityAITaskEntry == null || entityAITaskEntry.field_75733_a == null || !entityAITaskEntry.field_188524_c) continue;
                this.currentTask = entityAITaskEntry.field_75733_a.getClass().getSimpleName();
            }
            for (String string : TektopiaUtils.getProfessionTypeNames(false)) {
                if (Objects.equals(string, this.professionType)) continue;
                try {
                    int level = villager.getSkill(ProfessionType.valueOf((String)string));
                    if (level <= 0) continue;
                    this.additionalProfessions.put(string, level);
                }
                catch (Exception level) {}
            }
            List aiFilters = villager.getAIFilters();
            if (aiFilters != null && aiFilters.size() > 0) {
                for (String aiFilter : aiFilters) {
                    this.aiFilters.put(aiFilter, villager.isAIFilterEnabled(aiFilter));
                }
            }
            this.canHaveBed = true;
            if (villager instanceof EntityArchitect) {
                this.name = villager.func_70005_c_();
                this.professionType = "ARCHITECT";
                this.homePosition = this.currentStructure;
                this.canHaveBed = false;
            }
            if (villager instanceof EntityTradesman) {
                this.name = villager.func_70005_c_();
                this.professionType = "TRADESMAN";
                this.homePosition = this.currentStructure;
                this.canHaveBed = false;
            }
            if (villager.isRole(VillagerRole.VISITOR)) {
                String string;
                if (villagerProfessionType == null && (string = villager.getClass().getSimpleName().toUpperCase()).startsWith("ENTITY")) {
                    this.professionType = string.substring("ENTITY".length());
                }
                this.homePosition = null;
                this.canHaveBed = false;
            }
            if (villager instanceof IMerchant) {
                this.recipes = ((IMerchant)villager).func_70934_b(null);
            }
            VillagerInventory villagerInventory = villager.getInventory();
            toolItemClasses.forEach(c -> {
                List tools = inventory.getItems(s -> s.func_77973_b().getClass() == c ? s.func_77952_i() : -1, 1);
                if (!tools.isEmpty()) {
                    this.equipment.addAll(tools);
                }
            });
            this.equipment.removeIf(i -> i == null || i.func_190926_b());
            int inventorySize = villagerInventory.func_70302_i_();
            if (inventorySize > 0) {
                this.inventory = new ArrayList<ItemStack>(inventorySize);
                for (int slot = 0; slot < inventorySize; ++slot) {
                    this.inventory.add(villagerInventory.func_70301_a(slot).func_77946_l());
                }
            }
            this.recentEats.addAll(TektopiaUtils.getVillagerRecentEats(villager));
        }
    }

    @Override
    public void readNBT(NBTTagCompound nbtTag) {
        EntityVillagerTek villager;
        int blessedLevel;
        Entity entity;
        int index;
        if (nbtTag == null) {
            nbtTag = new NBTTagCompound();
        }
        this.clearData();
        super.readNBT(nbtTag);
        this.professionType = nbtTag.func_74764_b(NBTTAG_VILLAGE_RESIDENTPROFESSIONTYPE) ? nbtTag.func_74779_i(NBTTAG_VILLAGE_RESIDENTPROFESSIONTYPE) : null;
        this.isMale = nbtTag.func_74764_b(NBTTAG_VILLAGE_RESIDENTMALE) && nbtTag.func_74767_n(NBTTAG_VILLAGE_RESIDENTMALE);
        this.isChild = nbtTag.func_74764_b(NBTTAG_VILLAGE_RESIDENTCHILD) && nbtTag.func_74767_n(NBTTAG_VILLAGE_RESIDENTCHILD);
        this.isCaptain = nbtTag.func_74764_b(NBTTAG_VILLAGE_RESIDENTCAPTAIN) && nbtTag.func_74767_n(NBTTAG_VILLAGE_RESIDENTCAPTAIN);
        this.isVendor = nbtTag.func_74764_b(NBTTAG_VILLAGE_RESIDENTVENDOR) && nbtTag.func_74767_n(NBTTAG_VILLAGE_RESIDENTVENDOR);
        this.isVisitor = nbtTag.func_74764_b(NBTTAG_VILLAGE_RESIDENTVISITOR) && nbtTag.func_74767_n(NBTTAG_VILLAGE_RESIDENTVISITOR);
        this.isSleeping = nbtTag.func_74764_b(NBTTAG_VILLAGE_RESIDENTSLEEPING) && nbtTag.func_74767_n(NBTTAG_VILLAGE_RESIDENTSLEEPING);
        this.baseLevel = nbtTag.func_74764_b(NBTTAG_VILLAGE_RESIDENTBASELEVEL) ? nbtTag.func_74762_e(NBTTAG_VILLAGE_RESIDENTBASELEVEL) : 0;
        this.blessedLevel = nbtTag.func_74764_b(NBTTAG_VILLAGE_RESIDENTBLESSEDLEVEL) ? nbtTag.func_74762_e(NBTTAG_VILLAGE_RESIDENTBLESSEDLEVEL) : 0;
        this.daysAlive = nbtTag.func_74764_b(NBTTAG_VILLAGE_RESIDENTDAYSALIVE) ? nbtTag.func_74762_e(NBTTAG_VILLAGE_RESIDENTDAYSALIVE) : 0;
        this.hunger = nbtTag.func_74764_b(NBTTAG_VILLAGE_RESIDENTHUNGER) ? nbtTag.func_74762_e(NBTTAG_VILLAGE_RESIDENTHUNGER) : 0;
        this.maxHunger = nbtTag.func_74764_b(NBTTAG_VILLAGE_RESIDENTMAXHUNGER) ? nbtTag.func_74762_e(NBTTAG_VILLAGE_RESIDENTMAXHUNGER) : 0;
        this.happy = nbtTag.func_74764_b(NBTTAG_VILLAGE_RESIDENTHAPPY) ? nbtTag.func_74762_e(NBTTAG_VILLAGE_RESIDENTHAPPY) : 0;
        this.maxHappy = nbtTag.func_74764_b(NBTTAG_VILLAGE_RESIDENTMAXHAPPY) ? nbtTag.func_74762_e(NBTTAG_VILLAGE_RESIDENTMAXHAPPY) : 0;
        this.intelligence = nbtTag.func_74764_b(NBTTAG_VILLAGE_RESIDENTINTELLIGENCE) ? nbtTag.func_74762_e(NBTTAG_VILLAGE_RESIDENTINTELLIGENCE) : 0;
        this.maxIntelligence = nbtTag.func_74764_b(NBTTAG_VILLAGE_RESIDENTMAXINTELLIGENCE) ? nbtTag.func_74762_e(NBTTAG_VILLAGE_RESIDENTMAXINTELLIGENCE) : 0;
        this.workStartTime = nbtTag.func_74764_b(NBTTAG_VILLAGE_RESIDENTWORKSTART) ? nbtTag.func_74762_e(NBTTAG_VILLAGE_RESIDENTWORKSTART) : 0;
        this.workFinishTime = nbtTag.func_74764_b(NBTTAG_VILLAGE_RESIDENTWORKFINISH) ? nbtTag.func_74762_e(NBTTAG_VILLAGE_RESIDENTWORKFINISH) : 0;
        this.sleepStartTime = nbtTag.func_74764_b(NBTTAG_VILLAGE_RESIDENTSLEEPSTART) ? nbtTag.func_74762_e(NBTTAG_VILLAGE_RESIDENTSLEEPSTART) : 0;
        this.sleepFinishTime = nbtTag.func_74764_b(NBTTAG_VILLAGE_RESIDENTSLEEPFINISH) ? nbtTag.func_74762_e(NBTTAG_VILLAGE_RESIDENTSLEEPFINISH) : 0;
        this.canHaveBed = nbtTag.func_74764_b(NBTTAG_VILLAGE_RESIDENTCANHAVEBED) && nbtTag.func_74767_n(NBTTAG_VILLAGE_RESIDENTCANHAVEBED);
        this.bedPosition = nbtTag.func_74764_b(NBTTAG_VILLAGE_RESIDENTBEDPOSITION) ? BlockPos.func_177969_a((long)nbtTag.func_74763_f(NBTTAG_VILLAGE_RESIDENTBEDPOSITION)) : null;
        this.currentStructure = nbtTag.func_74764_b(NBTTAG_VILLAGE_RESIDENTCURRENTSTRUCTURE) ? BlockPos.func_177969_a((long)nbtTag.func_74763_f(NBTTAG_VILLAGE_RESIDENTCURRENTSTRUCTURE)) : null;
        this.currentTask = nbtTag.func_74764_b(NBTTAG_VILLAGE_RESIDENTCURRENTTASK) ? nbtTag.func_74779_i(NBTTAG_VILLAGE_RESIDENTCURRENTTASK) : null;
        ProfessionType originalProfessionType = null;
        if (!StringUtils.isNullOrWhitespace(this.professionType).booleanValue()) {
            originalProfessionType = TektopiaUtils.getProfessionType(this.professionType);
        }
        if (this.isCaptain) {
            this.professionType = ProfessionType.CAPTAIN.name();
        } else if (this.isChild) {
            this.professionType = ProfessionType.CHILD.name();
        }
        if (nbtTag.func_74764_b(NBTTAG_VILLAGE_RESIDENTADDPROF)) {
            NBTTagList nbtTagListProfessions = nbtTag.func_150295_c(NBTTAG_VILLAGE_RESIDENTADDPROF, 10);
            for (index = 0; index < nbtTagListProfessions.func_74745_c(); ++index) {
                NBTTagCompound nbtTagProfession = nbtTagListProfessions.func_150305_b(index);
                this.additionalProfessions.put(nbtTagProfession.func_74779_i("name"), nbtTagProfession.func_74762_e(NBTTAG_VILLAGE_RESIDENTADDPROFLEVEL));
            }
        }
        if (nbtTag.func_74764_b(NBTTAG_VILLAGE_RESIDENTAIFILTER)) {
            NBTTagList nbtTagListAIFilters = nbtTag.func_150295_c(NBTTAG_VILLAGE_RESIDENTAIFILTER, 10);
            for (index = 0; index < nbtTagListAIFilters.func_74745_c(); ++index) {
                NBTTagCompound nbtTagAIFilter = nbtTagListAIFilters.func_150305_b(index);
                this.aiFilters.put(nbtTagAIFilter.func_74779_i("name"), nbtTagAIFilter.func_74767_n(NBTTAG_VILLAGE_RESIDENTAIFILTERENABLED));
            }
        }
        if (nbtTag.func_74764_b(NBTTAG_VILLAGE_RESIDENTRECIPES)) {
            if (this.recipes == null) {
                this.recipes = new MerchantRecipeList();
            }
            this.recipes.func_77201_a(nbtTag.func_74775_l(NBTTAG_VILLAGE_RESIDENTRECIPES));
        }
        if (nbtTag.func_74764_b(NBTTAG_VILLAGE_RESIDENTINVENTORY)) {
            NBTTagList nbtTagListInventory = nbtTag.func_150295_c(NBTTAG_VILLAGE_RESIDENTINVENTORY, 10);
            this.inventory = new ArrayList<ItemStack>(nbtTagListInventory.func_74745_c());
            for (index = 0; index < nbtTagListInventory.func_74745_c(); ++index) {
                this.inventory.add(new ItemStack(nbtTagListInventory.func_150305_b(index)));
            }
        }
        if (nbtTag.func_74764_b(NBTTAG_VILLAGE_RESIDENTRECENTEATS)) {
            NBTTagList nbtTagListRecentEats = nbtTag.func_150295_c(NBTTAG_VILLAGE_RESIDENTRECENTEATS, 3);
            for (index = 0; index < nbtTagListRecentEats.func_74745_c(); ++index) {
                int nbtTagId = nbtTagListRecentEats.func_186858_c(index);
                this.recentEats.add(nbtTagId);
            }
        }
        if (originalProfessionType != null && entityList != null && entityList.size() > 0 && (entity = (Entity)entityList.stream().filter(e -> e instanceof EntityVillagerTek && e.func_145782_y() == this.getId()).findFirst().orElse(null)) != null && (blessedLevel = (villager = (EntityVillagerTek)entity).getBlessed()) > 0) {
            this.blessedLevel = blessedLevel;
            this.level = villager.getSkill(originalProfessionType);
        }
    }

    @Override
    public NBTTagCompound writeNBT(NBTTagCompound nbtTag) {
        NBTTagCompound nbtTagRecipies;
        if (nbtTag == null) {
            nbtTag = new NBTTagCompound();
        }
        nbtTag = super.writeNBT(nbtTag);
        if (!StringUtils.isNullOrWhitespace(this.professionType).booleanValue()) {
            nbtTag.func_74778_a(NBTTAG_VILLAGE_RESIDENTPROFESSIONTYPE, this.professionType);
        }
        if (this.isMale) {
            nbtTag.func_74757_a(NBTTAG_VILLAGE_RESIDENTMALE, this.isMale);
        }
        if (this.isChild) {
            nbtTag.func_74757_a(NBTTAG_VILLAGE_RESIDENTCHILD, this.isChild);
        }
        if (this.isCaptain) {
            nbtTag.func_74757_a(NBTTAG_VILLAGE_RESIDENTCAPTAIN, this.isCaptain);
        }
        if (this.isVendor) {
            nbtTag.func_74757_a(NBTTAG_VILLAGE_RESIDENTVENDOR, this.isVendor);
        }
        if (this.isVisitor) {
            nbtTag.func_74757_a(NBTTAG_VILLAGE_RESIDENTVISITOR, this.isVisitor);
        }
        if (this.isSleeping) {
            nbtTag.func_74757_a(NBTTAG_VILLAGE_RESIDENTSLEEPING, this.isSleeping);
        }
        if (this.baseLevel > 0) {
            nbtTag.func_74768_a(NBTTAG_VILLAGE_RESIDENTBASELEVEL, this.baseLevel);
        }
        if (this.blessedLevel > 0) {
            nbtTag.func_74768_a(NBTTAG_VILLAGE_RESIDENTBLESSEDLEVEL, this.blessedLevel);
        }
        if (this.daysAlive > 0) {
            nbtTag.func_74768_a(NBTTAG_VILLAGE_RESIDENTDAYSALIVE, this.daysAlive);
        }
        if (this.hunger > 0) {
            nbtTag.func_74768_a(NBTTAG_VILLAGE_RESIDENTHUNGER, this.hunger);
        }
        if (this.maxHunger > 0) {
            nbtTag.func_74768_a(NBTTAG_VILLAGE_RESIDENTMAXHUNGER, this.maxHunger);
        }
        if (this.happy > 0) {
            nbtTag.func_74768_a(NBTTAG_VILLAGE_RESIDENTHAPPY, this.happy);
        }
        if (this.maxHappy > 0) {
            nbtTag.func_74768_a(NBTTAG_VILLAGE_RESIDENTMAXHAPPY, this.maxHappy);
        }
        if (this.intelligence > 0) {
            nbtTag.func_74768_a(NBTTAG_VILLAGE_RESIDENTINTELLIGENCE, this.intelligence);
        }
        if (this.maxIntelligence > 0) {
            nbtTag.func_74768_a(NBTTAG_VILLAGE_RESIDENTMAXINTELLIGENCE, this.maxIntelligence);
        }
        if (this.workStartTime > 0) {
            nbtTag.func_74768_a(NBTTAG_VILLAGE_RESIDENTWORKSTART, this.workStartTime);
        }
        if (this.workFinishTime > 0) {
            nbtTag.func_74768_a(NBTTAG_VILLAGE_RESIDENTWORKFINISH, this.workFinishTime);
        }
        if (this.sleepStartTime > 0) {
            nbtTag.func_74768_a(NBTTAG_VILLAGE_RESIDENTSLEEPSTART, this.sleepStartTime);
        }
        if (this.sleepFinishTime > 0) {
            nbtTag.func_74768_a(NBTTAG_VILLAGE_RESIDENTSLEEPFINISH, this.sleepFinishTime);
        }
        if (this.canHaveBed.booleanValue()) {
            nbtTag.func_74757_a(NBTTAG_VILLAGE_RESIDENTCANHAVEBED, this.canHaveBed.booleanValue());
        }
        if (this.bedPosition != null) {
            nbtTag.func_74772_a(NBTTAG_VILLAGE_RESIDENTBEDPOSITION, this.bedPosition.func_177986_g());
        }
        if (this.currentStructure != null) {
            nbtTag.func_74772_a(NBTTAG_VILLAGE_RESIDENTCURRENTSTRUCTURE, this.currentStructure.func_177986_g());
        }
        if (this.currentTask != null) {
            nbtTag.func_74778_a(NBTTAG_VILLAGE_RESIDENTCURRENTTASK, this.currentTask);
        }
        if (this.additionalProfessions != null && this.additionalProfessions.size() > 0) {
            NBTTagList nbtTagListProfessions = new NBTTagList();
            for (Map.Entry<String, Constable> entry : this.additionalProfessions.entrySet()) {
                if (entry == null) continue;
                NBTTagCompound nbtTagProfession = new NBTTagCompound();
                nbtTagProfession.func_74778_a("name", entry.getKey());
                nbtTagProfession.func_74768_a(NBTTAG_VILLAGE_RESIDENTADDPROFLEVEL, ((Integer)entry.getValue()).intValue());
                nbtTagListProfessions.func_74742_a((NBTBase)nbtTagProfession);
            }
            if (!nbtTagListProfessions.func_82582_d()) {
                nbtTag.func_74782_a(NBTTAG_VILLAGE_RESIDENTADDPROF, (NBTBase)nbtTagListProfessions);
            }
        }
        if (this.aiFilters != null && this.aiFilters.size() > 0) {
            NBTTagList nbtTagListAIFilters = new NBTTagList();
            for (Map.Entry<String, Constable> entry : this.aiFilters.entrySet()) {
                if (entry == null) continue;
                NBTTagCompound nbtTagAIFilter = new NBTTagCompound();
                nbtTagAIFilter.func_74778_a("name", entry.getKey());
                nbtTagAIFilter.func_74757_a(NBTTAG_VILLAGE_RESIDENTAIFILTERENABLED, ((Boolean)entry.getValue()).booleanValue());
                nbtTagListAIFilters.func_74742_a((NBTBase)nbtTagAIFilter);
            }
            if (!nbtTagListAIFilters.func_82582_d()) {
                nbtTag.func_74782_a(NBTTAG_VILLAGE_RESIDENTAIFILTER, (NBTBase)nbtTagListAIFilters);
            }
        }
        if (this.recipes != null && !this.recipes.isEmpty() && !(nbtTagRecipies = this.recipes.func_77202_a()).func_82582_d()) {
            nbtTag.func_74782_a(NBTTAG_VILLAGE_RESIDENTRECIPES, (NBTBase)nbtTagRecipies);
        }
        if (this.inventory != null && !this.inventory.isEmpty()) {
            NBTTagList nbtTagListInventory = new NBTTagList();
            for (ItemStack itemStack : this.inventory) {
                NBTTagCompound nbtTagInventoryItem;
                if (itemStack == null || itemStack.func_190926_b() || (nbtTagInventoryItem = itemStack.func_77955_b(new NBTTagCompound())).func_82582_d()) continue;
                nbtTagListInventory.func_74742_a((NBTBase)nbtTagInventoryItem);
            }
            if (!nbtTagListInventory.func_82582_d()) {
                nbtTag.func_74782_a(NBTTAG_VILLAGE_RESIDENTINVENTORY, (NBTBase)nbtTagListInventory);
            }
        }
        if (this.recentEats != null && !this.recentEats.isEmpty()) {
            NBTTagList nbtTagListRecentEats = new NBTTagList();
            for (Integer n : this.recentEats) {
                nbtTagListRecentEats.func_74742_a((NBTBase)new NBTTagInt(n.intValue()));
            }
            if (!nbtTagListRecentEats.func_82582_d()) {
                nbtTag.func_74782_a(NBTTAG_VILLAGE_RESIDENTRECENTEATS, (NBTBase)nbtTagListRecentEats);
            }
        }
        return nbtTag;
    }
}

