/*
 * Decompiled with CFR 0.152.
 */
package bletch.tektopiainformation.network.data;

import bletch.tektopiainformation.network.data.EnemyData;
import bletch.tektopiainformation.network.data.EntityData;
import bletch.tektopiainformation.network.data.VillageData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.AxisAlignedBB;
import net.tangotek.tektopia.Village;
import net.tangotek.tektopia.VillagerRole;
import net.tangotek.tektopia.entities.EntityVillageNavigator;

public class EnemiesData {
    protected static final String NBTTAG_VILLAGE_ENEMIES = "enemies";
    protected static final String NBTTAG_VILLAGE_ENEMIESLIST = "list";
    protected VillageData villageData;
    protected List<EnemyData> enemies;

    public EnemiesData() {
        this.populateData(null, null);
    }

    protected VillageData getVillageData() {
        return this.villageData;
    }

    public int getEnemiesCount() {
        return this.enemies.size();
    }

    public List<EnemyData> getEnemies() {
        return this.enemies == null ? Collections.unmodifiableList(new ArrayList()) : Collections.unmodifiableList(this.enemies.stream().sorted(Comparator.comparing(EntityData::getName)).collect(Collectors.toList()));
    }

    public EnemyData getEnemy(int index) {
        return this.enemies == null ? null : this.enemies.get(index);
    }

    public EnemyData getEnemyById(int id) {
        return this.enemies == null ? null : (EnemyData)this.enemies.stream().filter(m -> m.getId() == id).findFirst().orElse(null);
    }

    protected void clearData() {
        this.enemies = new ArrayList<EnemyData>();
    }

    public void populateData(VillageData villageData, Village village) {
        this.clearData();
        this.villageData = villageData;
        if (village != null) {
            AxisAlignedBB villageAABB = village.getAABB().func_186662_g(120.0);
            List villageEntities = village.getWorld().func_72872_a(EntityVillageNavigator.class, villageAABB);
            for (EntityVillageNavigator entity : villageEntities) {
                if (entity.field_70128_L || !entity.isRole(VillagerRole.ENEMY)) continue;
                this.enemies.add(new EnemyData(entity));
            }
        }
    }

    public void readNBT(VillageData villageData, NBTTagCompound nbtTag) {
        NBTTagCompound nbtEnemiesData;
        if (nbtTag == null) {
            nbtTag = new NBTTagCompound();
        }
        this.clearData();
        this.villageData = villageData;
        if (nbtTag.func_74764_b(NBTTAG_VILLAGE_ENEMIES) && (nbtEnemiesData = nbtTag.func_74775_l(NBTTAG_VILLAGE_ENEMIES)).func_74764_b(NBTTAG_VILLAGE_ENEMIESLIST)) {
            NBTTagList nbtTagListEnemies = nbtEnemiesData.func_150295_c(NBTTAG_VILLAGE_ENEMIESLIST, 10);
            for (int index = 0; index < nbtTagListEnemies.func_74745_c(); ++index) {
                this.enemies.add(new EnemyData(nbtTagListEnemies.func_150305_b(index)));
            }
        }
    }

    public NBTTagCompound writeNBT(NBTTagCompound nbtTag) {
        if (nbtTag == null) {
            nbtTag = new NBTTagCompound();
        }
        NBTTagCompound nbtEnemiesData = new NBTTagCompound();
        if (this.enemies != null && this.enemies.size() > 0) {
            NBTTagList nbtTagListEnemies = new NBTTagList();
            for (EnemyData enemy : this.enemies) {
                NBTTagCompound nbtTagEnemy = enemy.writeNBT(new NBTTagCompound());
                if (nbtTagEnemy.func_82582_d()) continue;
                nbtTagListEnemies.func_74742_a((NBTBase)nbtTagEnemy);
            }
            if (!nbtTagListEnemies.func_82582_d()) {
                nbtEnemiesData.func_74782_a(NBTTAG_VILLAGE_ENEMIESLIST, (NBTBase)nbtTagListEnemies);
            }
        }
        if (!nbtEnemiesData.func_82582_d()) {
            nbtTag.func_74782_a(NBTTAG_VILLAGE_ENEMIES, (NBTBase)nbtEnemiesData);
        }
        return nbtTag;
    }
}

