/*
 * Decompiled with CFR 0.152.
 */
package bletch.tektopiainformation.gui;

import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;

public class GuiTexture {
    private final ResourceLocation texture;
    private float zLevel;
    private int left;
    private int top;
    private int width;
    private int height;
    private int textureLeft;
    private int textureTop;
    private int textureWidth;
    private int textureHeight;

    public GuiTexture(ResourceLocation texture, float zLevel, int left, int top, int width, int height, int textureLeft, int textureTop, int textureWidth, int textureHeight) {
        this.texture = texture;
        this.zLevel = zLevel;
        this.left = left;
        this.top = top;
        this.width = width;
        this.height = height;
        this.textureLeft = textureLeft;
        this.textureTop = textureTop;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
    }

    public GuiTexture addPosition(BlockPos position) {
        this.left += position.func_177958_n();
        this.top += position.func_177952_p();
        return this;
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public float getZLevel() {
        return this.zLevel;
    }

    public int getLeft() {
        return this.left;
    }

    public int getTop() {
        return this.top;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getRight() {
        return this.left + this.width;
    }

    public int getBottom() {
        return this.top + this.height;
    }

    public int getTextureLeft() {
        return this.textureLeft;
    }

    public int getTextureTop() {
        return this.textureTop;
    }

    public int getTextureWidth() {
        return this.textureWidth;
    }

    public int getTextureHeight() {
        return this.textureHeight;
    }

    public int getTextureRight() {
        return this.textureLeft + this.textureWidth;
    }

    public int getTextureBottom() {
        return this.textureTop + this.textureHeight;
    }

    public GuiTexture multiplyPosition(int factor) {
        this.left *= factor;
        this.top *= factor;
        return this;
    }

    public GuiTexture multiplySize(int factor) {
        this.width *= factor;
        this.height *= factor;
        this.textureWidth *= factor;
        this.textureHeight *= factor;
        return this;
    }

    public GuiTexture setPosition(int left, int top) {
        this.left = left;
        this.top = top;
        return this;
    }

    public GuiTexture setPosition(BlockPos position) {
        this.left = position.func_177958_n();
        this.top = position.func_177952_p();
        return this;
    }

    public boolean withinBounds(int x, int y, float scale) {
        int scaledX = (int)((float)x / scale);
        int scaledY = (int)((float)y / scale);
        return this.getLeft() <= scaledX && this.getTop() <= scaledY && this.getRight() >= scaledX && this.getBottom() >= scaledY;
    }
}

