/*
 * Decompiled with CFR 0.152.
 */
package bletch.common.schedulers;

import bletch.common.schedulers.IScheduler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.tangotek.tektopia.Village;
import net.tangotek.tektopia.tickjob.TickJob;
import net.tangotek.tektopia.tickjob.TickJobQueue;

public class ScheduleManager {
    protected final World world;
    protected List<IScheduler> schedulers;
    protected TickJobQueue jobs;

    public ScheduleManager(World worldIn) {
        this.world = worldIn;
        this.schedulers = new ArrayList<IScheduler>();
        this.jobs = new TickJobQueue();
        this.setupServerJobs();
    }

    public void addScheduler(IScheduler scheduler) {
        if (scheduler == null) {
            return;
        }
        this.schedulers.add(scheduler);
    }

    public void addJob(TickJob job) {
        if (job == null) {
            return;
        }
        this.jobs.addJob(job);
    }

    public void onWorldTick(TickEvent.WorldTickEvent e) {
        this.jobs.tick();
        if (Village.isNightTime((World)this.world)) {
            this.schedulers.forEach(s -> s.resetNight());
        } else {
            this.schedulers.forEach(s -> s.resetDay());
        }
    }

    public void processSchedulers() {
        this.schedulers.forEach(s -> s.update(this.world));
    }

    protected void setupServerJobs() {
        this.addJob(new TickJob(100, 100, true, () -> this.processSchedulers()));
    }
}

