/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.config;

import java.io.File;
import toughasnails.api.config.GameplayOption;
import toughasnails.config.ConfigHandler;
import toughasnails.core.ToughAsNails;

public class GameplayConfig
extends ConfigHandler {
    public boolean iceCubeDrops;
    public boolean magmaShardDrops;
    public boolean lootTableTweaks;

    public GameplayConfig(File configFile) {
        super(configFile, "Gameplay Settings");
    }

    @Override
    protected void loadConfiguration() {
        try {
            this.addSyncedValue(GameplayOption.ENABLE_TEMPERATURE, true, "Main Settings", "Players are affected by temperature", new Boolean[0]);
            this.addSyncedValue(GameplayOption.ENABLE_THIRST, true, "Main Settings", "Players are affected by thirst.", new Boolean[0]);
            this.addSyncedValue(GameplayOption.ENABLE_PEACEFUL, false, "Main Settings", "The effects of the mod will work on Peaceful difficulty.", new Boolean[0]);
            this.addSyncedValue(GameplayOption.ENABLE_THIRST_WORLD, true, "Main Settings", "Allows drinking directly from water-source blocks with sneak-rightclick and empty main hand", new Boolean[0]);
            this.addSyncedValue(GameplayOption.ENABLE_THIRST_RAIN, false, "Main Settings", "Allows drinking from rain by sneak-rightclick and empty main hand if looking up at raining sky.", new Boolean[0]);
            this.iceCubeDrops = this.config.getBoolean("Ice Cube Drops", "Tweak Settings", true, "Ice Blocks drop Ice Cubes.");
            this.magmaShardDrops = this.config.getBoolean("Magma Shard Drops", "Tweak Settings", true, "Magma Blocks drop Magma Shards.");
            this.lootTableTweaks = this.config.getBoolean("Loot Table Tweaks", "Tweak Settings", true, "Loot tables are tweaked for balance.");
        }
        catch (Exception e) {
            ToughAsNails.logger.error("Tough As Nails has encountered a problem loading gameplay.cfg", (Throwable)e);
        }
        finally {
            if (this.config.hasChanged()) {
                this.config.save();
            }
        }
    }
}

