/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.world.grid.chunk;

import CoroUtil.difficulty.DamageSourceEntry;
import CoroUtil.world.grid.chunk.ChunkDataGrid;
import CoroUtil.world.grid.chunk.PlayerDataGrid;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.chunk.Chunk;

public class ChunkDataPoint {
    public ChunkDataGrid grid;
    public int xCoord;
    public int yCoord;
    public int zCoord;
    public final int hash;
    public int spawnableType = -1;
    public long lastTickTime;
    public int countEntitiesEnemy = -1;
    private HashMap<UUID, PlayerDataGrid> lookupPlayersToActivity = new HashMap();
    public PlayerDataGrid playerDataForAll = new PlayerDataGrid();
    public Class enemyClass = EntityMob.class;
    public List<Float> listDPSAveragesShortTerm = new ArrayList<Float>();
    public List<Float> listDPSAveragesLongTerm = new ArrayList<Float>();
    public long lastDPSRecalc = 0L;
    public float averageDPS;
    boolean useSpawnableType = false;
    public DamageSourceEntry highestDamage;

    public ChunkDataPoint(ChunkDataGrid parGrid, int i, int k) {
        this.grid = parGrid;
        this.xCoord = i;
        this.yCoord = 0;
        this.zCoord = k;
        this.highestDamage = new DamageSourceEntry();
        this.hash = ChunkDataPoint.makeHash(i, k);
        this.updateCache();
    }

    public void initFirstTime() {
        try {
            this.updateCache();
            if (this.useSpawnableType && this.grid.world.func_175668_a(new BlockPos(this.xCoord * 16, 0, this.zCoord * 16), true)) {
                Chunk chunk = this.grid.world.func_72964_e(this.xCoord, this.zCoord);
                int countWater = 0;
                int countLand = 0;
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        int heightVal = Math.max(0, chunk.func_76611_b(x, z) - 1);
                        if (heightVal < 0) continue;
                        IBlockState state = chunk.func_177435_g(new BlockPos(x, heightVal, z));
                        Block id = state.func_177230_c();
                        if (id.func_149688_o(state).func_76224_d()) {
                            ++countWater;
                            continue;
                        }
                        ++countLand;
                    }
                }
                this.spawnableType = countLand > countWater ? 0 : 1;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void updateCache() {
        if (this.grid.world.func_175668_a(new BlockPos(this.xCoord * 16, 0, this.zCoord * 16), true)) {
            Chunk chunk = this.grid.world.func_72964_e(this.xCoord, this.zCoord);
            List<Entity> listEntities = this.getEntitiesFromLoadedChunk(this.enemyClass, chunk);
            this.countEntitiesEnemy = listEntities.size();
        }
    }

    public boolean isRemovable() {
        return false;
    }

    public static int makeHash(int i, int k) {
        int j = 0;
        return j & 0xFF | (i & Short.MAX_VALUE) << 8 | (k & Short.MAX_VALUE) << 24 | (i >= 0 ? 0 : Integer.MIN_VALUE) | (k >= 0 ? 0 : 32768);
    }

    public float distanceTo(ChunkDataPoint pathpoint) {
        float f = pathpoint.xCoord - this.xCoord;
        float f1 = pathpoint.yCoord - this.yCoord;
        float f2 = pathpoint.zCoord - this.zCoord;
        return MathHelper.func_76129_c((float)(f * f + f1 * f1 + f2 * f2));
    }

    public boolean equals(Object obj) {
        if (obj instanceof ChunkDataPoint) {
            ChunkDataPoint pathpoint = (ChunkDataPoint)obj;
            return this.hash == pathpoint.hash && this.xCoord == pathpoint.xCoord && this.yCoord == pathpoint.yCoord && this.zCoord == pathpoint.zCoord;
        }
        return false;
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        return this.xCoord + ", " + this.yCoord + ", " + this.zCoord;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.lastTickTime = nbt.func_74763_f("lastTickTime");
        this.spawnableType = nbt.func_74762_e("spawnableType");
        this.countEntitiesEnemy = nbt.func_74762_e("countEntitiesEnemy");
        NBTTagCompound nbtListPlayers = nbt.func_74775_l("listPlayers");
        for (String entryName : nbtListPlayers.func_150296_c()) {
            NBTTagCompound entry = nbtListPlayers.func_74775_l(entryName);
            UUID uuid = UUID.fromString(entry.func_74779_i("UUID"));
            PlayerDataGrid playerData = new PlayerDataGrid();
            playerData.nbtRead(entry.func_74775_l("playerData"));
            this.lookupPlayersToActivity.put(uuid, playerData);
        }
        this.playerDataForAll.nbtRead(nbt.func_74775_l("playerDataForAll"));
        this.lastDPSRecalc = nbt.func_74763_f("lastDPSRecalc");
        this.averageDPS = nbt.func_74760_g("averageDPS");
        NBTTagCompound nbtDPSs = nbt.func_74775_l("listDPSAveragesLongTerm");
        for (String entryName : nbtDPSs.func_150296_c()) {
            this.listDPSAveragesLongTerm.add(Float.valueOf(nbtDPSs.func_74760_g(entryName)));
        }
        if (nbt.func_74764_b("highestDamage")) {
            NBTTagCompound highestDamageNBT = nbt.func_74775_l("highestDamage");
            this.highestDamage = new DamageSourceEntry();
            this.highestDamage.source_entity_true = highestDamageNBT.func_74779_i("source_entity_true");
            this.highestDamage.source_entity_immediate = highestDamageNBT.func_74779_i("source_entity_immediate");
            this.highestDamage.target_entity = highestDamageNBT.func_74779_i("target_entity");
            this.highestDamage.source_type = highestDamageNBT.func_74779_i("source_type");
            this.highestDamage.highestDamage = highestDamageNBT.func_74760_g("highestDamage");
            this.highestDamage.damageTimeAveraged = highestDamageNBT.func_74760_g("damageTimeAveraged");
            this.highestDamage.lastLogTime = highestDamageNBT.func_74763_f("lastLogTime");
            this.highestDamage.timeDiffSeconds = highestDamageNBT.func_74760_g("timeDiffSeconds");
            this.highestDamage.source_pos = new BlockPos(highestDamageNBT.func_74762_e("x"), highestDamageNBT.func_74762_e("y"), highestDamageNBT.func_74762_e("z"));
        }
        boolean test = false;
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74772_a("lastTickTime", this.lastTickTime);
        nbt.func_74768_a("spawnableType", this.spawnableType);
        nbt.func_74768_a("countEntitiesEnemy", this.countEntitiesEnemy);
        NBTTagCompound nbtListPlayers = new NBTTagCompound();
        int count = 0;
        for (Map.Entry<UUID, PlayerDataGrid> entry : this.lookupPlayersToActivity.entrySet()) {
            NBTTagCompound nbtEntry = new NBTTagCompound();
            nbtEntry.func_74778_a("UUID", entry.getKey().toString());
            nbtEntry.func_74782_a("playerData", (NBTBase)entry.getValue().nbtWrite());
            nbtListPlayers.func_74782_a("entry_" + count++, (NBTBase)nbtEntry);
        }
        nbt.func_74782_a("listPlayers", (NBTBase)nbtListPlayers);
        nbt.func_74782_a("playerDataForAll", (NBTBase)this.playerDataForAll.nbtWrite());
        nbt.func_74768_a("xCoord", this.xCoord);
        nbt.func_74768_a("yCoord", this.yCoord);
        nbt.func_74768_a("zCoord", this.zCoord);
        nbt.func_74772_a("lastDPSRecalc", this.lastDPSRecalc);
        nbt.func_74776_a("averageDPS", this.averageDPS);
        NBTTagCompound nbtDPSs = new NBTTagCompound();
        for (int i = 0; i < this.listDPSAveragesLongTerm.size(); ++i) {
            nbtDPSs.func_74776_a("entry_" + i, this.listDPSAveragesLongTerm.get(i).floatValue());
        }
        nbt.func_74782_a("listDPSAveragesLongTerm", (NBTBase)nbtDPSs);
        NBTTagCompound highestDamageNBT = new NBTTagCompound();
        highestDamageNBT.func_74778_a("source_entity_true", this.highestDamage.source_entity_true);
        highestDamageNBT.func_74778_a("source_entity_immediate", this.highestDamage.source_entity_immediate);
        highestDamageNBT.func_74778_a("target_entity", this.highestDamage.target_entity);
        highestDamageNBT.func_74778_a("source_type", this.highestDamage.source_type);
        highestDamageNBT.func_74776_a("highestDamage", this.highestDamage.highestDamage);
        highestDamageNBT.func_74776_a("damageTimeAveraged", this.highestDamage.damageTimeAveraged);
        highestDamageNBT.func_74776_a("timeDiffSeconds", this.highestDamage.timeDiffSeconds);
        highestDamageNBT.func_74772_a("lastLogTime", this.highestDamage.lastLogTime);
        highestDamageNBT.func_74768_a("x", this.highestDamage.source_pos.func_177958_n());
        highestDamageNBT.func_74768_a("y", this.highestDamage.source_pos.func_177956_o());
        highestDamageNBT.func_74768_a("z", this.highestDamage.source_pos.func_177952_p());
        nbt.func_74782_a("highestDamage", (NBTBase)highestDamageNBT);
        return nbt;
    }

    public void tickUpdate() {
        long curTickTime;
        this.lastTickTime = curTickTime = this.grid.world.func_82737_E();
    }

    public void cleanup() {
        this.grid = null;
    }

    public List<Entity> getEntitiesFromLoadedChunk(Class filterClass, Chunk chunk) {
        ArrayList<Entity> list = new ArrayList<Entity>();
        return list;
    }

    public PlayerDataGrid getPlayerData(UUID uuid) {
        PlayerDataGrid playerData = this.lookupPlayersToActivity.get(uuid);
        if (playerData == null) {
            playerData = new PlayerDataGrid();
            this.lookupPlayersToActivity.put(uuid, playerData);
        }
        return playerData;
    }

    public void addToPlayerActivityTime(UUID uuid, long parVal) {
        this.playerDataForAll.playerActivityTimeSpent += parVal;
        this.playerDataForAll.playerActivityLastUpdated = this.grid.world.func_82737_E();
        if (uuid != null) {
            this.getPlayerData((UUID)uuid).playerActivityTimeSpent += parVal;
            this.getPlayerData((UUID)uuid).playerActivityLastUpdated = this.grid.world.func_82737_E();
        }
    }

    public void addToPlayerActivityInteract(UUID uuid, long parVal) {
        this.playerDataForAll.playerActivityInteraction += parVal;
        this.playerDataForAll.playerActivityLastUpdated = this.grid.world.func_82737_E();
        if (uuid != null) {
            this.getPlayerData((UUID)uuid).playerActivityInteraction += parVal;
            this.getPlayerData((UUID)uuid).playerActivityLastUpdated = this.grid.world.func_82737_E();
        }
    }
}

