/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.blocks;

import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.ForgeLocating;
import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.forge.blocks.ForgeBlock;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.regs.INeedRender;
import com.endertech.minecraft.forge.units.IForgeUnit;
import com.endertech.minecraft.forge.units.UnitEnabled;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.units.UnitVariant;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FluidBlock
extends BlockFluidClassic
implements IForgeUnit,
INeedRender {
    private final UnitEnabled unitEnabled;
    private final ForgeConfig config;
    private final ForgeMod mod;
    private final UnitId id;
    private Map<Object, UnitVariant> variants = new HashMap<Object, UnitVariant>();
    private final UnitVariant defaultVariant;

    public FluidBlock(ForgeMod mod, UnitConfig config, Fluid fluid, Material material) {
        super(fluid, material);
        this.mod = mod;
        this.id = this.createId(mod.getId(), "");
        this.config = config;
        this.unitEnabled = new UnitEnabled(config, this.getUnitCategory(), true);
        this.defaultVariant = UnitVariant.from(this.id, IForgeUnit.Variants.NORMAL);
        this.setRegistryName(this.getId().toResLoc());
        this.func_149663_c(this.getId().getRegName());
        this.register();
    }

    public static Fluid createFluidFor(ForgeMod mod, Class<? extends BlockFluidBase> blockClass) {
        String fluidName = IForgeUnit.getClassRegName(blockClass);
        ResourceLocation still = ForgeLocating.fluidTexture(mod.getId(), fluidName, false, new String[0]);
        ResourceLocation flowing = ForgeLocating.fluidTexture(mod.getId(), fluidName, true, new String[0]);
        Fluid fluid = new Fluid(fluidName, still, flowing);
        FluidRegistry.addBucketForFluid((Fluid)fluid);
        return fluid;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerRender() {
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{LEVEL}).func_178441_a());
    }

    @Override
    public boolean isReadyToRegister() {
        return true;
    }

    @Override
    public ForgeConfig getConfig() {
        return this.config;
    }

    @Override
    public UnitId getId() {
        return this.id;
    }

    @Override
    public ForgeMod getMod() {
        return this.mod;
    }

    @Override
    public boolean isEnabled() {
        return this.unitEnabled.isEnabled();
    }

    @Override
    public boolean isRegistered() {
        return ForgeBlock.isRegistered((Block)this);
    }

    public static int getDensityFrom(ForgeConfig config, String category, int defaultValue) {
        return ForgeConfig.getInt(config, category, "density", defaultValue, IntBounds.INTEGER, "Defines the density of this liquid.");
    }

    public static int getViscosityFrom(ForgeConfig config, String category, int defaultValue) {
        return ForgeConfig.getInt(config, category, "viscosity", defaultValue, IntBounds.INTEGER, "Defines the viscosity of this liquid.");
    }

    @Override
    public void onInit() {
        this.field_149782_v = ForgeBlock.getHardnessFrom(this.getConfig(), this.getUnitCategory(), this.field_149782_v);
        this.field_149781_w = ForgeBlock.getResistanceFrom(this.getConfig(), this.getUnitCategory(), this.field_149781_w);
        this.setDensity(FluidBlock.getDensityFrom(this.getConfig(), this.getUnitCategory(), this.density));
        this.getFluid().setDensity(this.density);
        this.getFluid().setViscosity(FluidBlock.getViscosityFrom(this.getConfig(), this.getUnitCategory(), this.getFluid().getViscosity()));
        this.saveConfig();
    }

    @Override
    public void onInitClient() {
    }

    @Override
    public Map<Object, UnitVariant> getUnitVariants() {
        return this.variants;
    }

    @Override
    public UnitVariant getDefaultVariant() {
        return this.defaultVariant;
    }

    @Override
    public <E extends Enum<E>> void setUnitVariants(Class<E> clazz) {
        this.variants = this.createUnitVariants(clazz);
    }
}

