/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.network;

import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.common.ServerActions;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class UnequipBackpackPacket
implements IMessage {
    private boolean valid;

    public UnequipBackpackPacket() {
    }

    public UnequipBackpackPacket(boolean valid) {
        this.valid = valid;
    }

    public void fromBytes(ByteBuf buf) {
        this.valid = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.valid);
    }

    public static class Handler
    implements IMessageHandler<UnequipBackpackPacket, IMessage> {
        public IMessage onMessage(UnequipBackpackPacket message, MessageContext ctx) {
            EntityPlayerMP sendingPlayer = ctx.getServerHandler().field_147369_b;
            if (ctx.side.isServer() && sendingPlayer != null && message.valid) {
                if (CapabilityUtils.isWearingBackpack((EntityPlayer)sendingPlayer)) {
                    WorldServer playerWorldServer = sendingPlayer.func_71121_q();
                    playerWorldServer.func_152344_a(() -> ServerActions.unequipBackpack((EntityPlayer)sendingPlayer));
                } else {
                    sendingPlayer.func_71053_j();
                    sendingPlayer.func_145747_a((ITextComponent)new TextComponentTranslation("actions.unequip_backpack.nobackpack", new Object[0]));
                }
            }
            return null;
        }
    }
}

