/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.transformers;

import com.endertech.minecraft.forge.coremod.ForgeClassTransformer;
import com.endertech.minecraft.forge.coremod.InstructList;
import com.endertech.minecraft.forge.coremod.descriptors.ClassDescriptor;
import com.endertech.minecraft.forge.coremod.descriptors.Classes;
import com.endertech.minecraft.forge.coremod.descriptors.Descriptor;
import com.endertech.minecraft.forge.coremod.descriptors.MethodDescriptor;
import com.endertech.minecraft.forge.coremod.descriptors.Types;
import com.endertech.minecraft.forge.coremod.names.ClassName;
import com.endertech.minecraft.forge.coremod.signatures.MethodSignature;
import com.endertech.minecraft.mods.adpother.transformers.Handlers;
import org.objectweb.asm.tree.MethodInsnNode;

public class EnderIO {

    public static class CombustionGenerator
    extends ForgeClassTransformer {
        private final String className = "crazypants.enderio.machines.machine.generator.combustion.TileCombustionGenerator";
        private final MethodSignature target = MethodSignature.of((String)"crazypants.enderio.machines.machine.generator.combustion.TileCombustionGenerator", (String)"generateEnergy", (MethodDescriptor)MethodDescriptor.of((Types)Types.BOOLEAN));
        private final MethodSignature targetNode = MethodSignature.of((String)"crazypants.enderio.machines.machine.generator.combustion.CombustionMath", (String)"getTicksPerFuel", (MethodDescriptor)MethodDescriptor.of((Types)Types.INT).withParameters(new Types[]{Types.INT}));
        private final ClassDescriptor smartTank = ClassDescriptor.from((String)"com/enderio/core/common/fluid/SmartTank");
        private final MethodSignature getFuelTank = MethodSignature.of((String)"crazypants.enderio.machines.machine.generator.combustion.TileCombustionGenerator", (String)"getFuelTank", (MethodDescriptor)MethodDescriptor.of((Descriptor)this.smartTank));
        private final MethodSignature getFluid;

        public CombustionGenerator() {
            this.getFluid = MethodSignature.of((ClassName)this.smartTank.name, (String)"getFluid", (MethodDescriptor)MethodDescriptor.of((Classes)Classes.FLUID_STACK));
        }

        protected MethodSignature getTargetMethod() {
            return this.target;
        }

        public boolean isCompatibilityMode() {
            return true;
        }

        protected boolean isProperInstruction(MethodInsnNode node) {
            return this.targetNode.complyWith(node);
        }

        protected boolean shouldSearchNextInstruction(MethodInsnNode lastProperNode) {
            return false;
        }

        protected void injectInstructions(InstructList instructions) {
            instructions.loadThis().invokeVirtual(this.getFuelTank).invokeVirtual(this.getFluid).loadThis().swap().dupValue3().invokeStatic(this.getHandler()).insertBefore();
        }

        protected MethodSignature getHandler() {
            return Handlers.ON_FLUID_FUEL_STACK_BURNED_BY_TILE_AMOUNT;
        }
    }

    public static class StirlingGenerator
    extends ForgeClassTransformer {
        private final String className = "crazypants.enderio.machines.machine.generator.stirling.TileStirlingGenerator";
        private final MethodSignature targetMethod = MethodSignature.of((String)"crazypants.enderio.machines.machine.generator.stirling.TileStirlingGenerator", (String)"processTasks", (MethodDescriptor)MethodDescriptor.of((Types)Types.VOID).withParameters(new Types[]{Types.BOOLEAN}));

        protected MethodSignature getTargetMethod() {
            return this.targetMethod;
        }

        public boolean isCompatibilityMode() {
            return true;
        }

        protected boolean isProperInstruction(MethodInsnNode node) {
            return MethodSignature.ITEM_STACK_SPLIT_STACK.complyWith(node);
        }

        protected boolean shouldSearchNextInstruction(MethodInsnNode lastProperNode) {
            return false;
        }

        protected void injectInstructions(InstructList instructions) {
            instructions.dup().loadThis().swap().invokeStatic(this.getHandler()).insertAfter();
        }

        protected MethodSignature getHandler() {
            return Handlers.ON_FUEL_BURNED_BY_TILE;
        }
    }
}

