/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.init;

import com.endertech.common.KeyValuePair;
import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.forge.blocks.BlockState;
import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.units.EmittersInit;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adpother.compat.Gregtech;
import com.endertech.minecraft.mods.adpother.compat.HeatAndClimate;
import com.endertech.minecraft.mods.adpother.compat.ImmersiveVehicles;
import com.endertech.minecraft.mods.adpother.compat.Minecraft;
import com.endertech.minecraft.mods.adpother.compat.TConstruct;
import com.endertech.minecraft.mods.adpother.emissions.Emissions;
import com.endertech.minecraft.mods.adpother.sources.CharcoalPit;
import com.endertech.minecraft.mods.adpother.sources.Emitter;
import java.util.Collections;
import java.util.Map;

public class Emitters
extends EmittersInit<Emitter, BuiltInEmitters> {
    private static final String HARDCODED_FUEL = "#hardcoded_fuel_consumption_hook";
    private static final String HARDCODED = "#hardcoded";

    public Emitters(ForgeMod mod) {
        super(mod, BuiltInEmitters.class);
    }

    public Emitter createCustomUnitFrom(UnitConfig config, String name) {
        return new Emitter(config, UnitId.EMPTY, KeyValuePair.EMPTY, false, "", false, new String[0], Emissions.of(), 1.0f);
    }

    public Emitter createDefaultUnitFrom(UnitConfig config, BuiltInEmitters e) {
        UnitId id = e.id.isEmpty() ? UnitId.from((Enum)e, (boolean)true) : UnitId.from((String)e.id);
        return e.createEmitter(config, id);
    }

    public Map<BlockState, Emitter> getBlockStates() {
        return Collections.unmodifiableMap(this.blockStates);
    }

    static enum BuiltInEmitters implements IForgeEnum
    {
        actuallyadditions$block_grinder$1(0.0f, 0.0f, 0.8f, ""),
        actuallyadditions$block_grinder_double$1(0.0f, 0.0f, 1.2f, ""),
        atum$limestone_furnace_lit(0.8f, 0.08f),
        atum$kiln("atum:kiln:[is_burning=true]", 0.8f, 0.08f, 0.0f, "", "", new String[]{"atum:kiln_fake:*"}),
        betterboilers$controller$1(0.8f, 0.08f),
        buildcraft$engine_stirling("buildcraftcore:engine:1", 0.8f, 0.08f, 0.0f, "burnTime", "isRedstonePowered=1b"),
        buildcraft$engine_combustion("buildcraftcore:engine:2", 0.4f, 0.04f, 0.0f, "burnTime", "isRedstonePowered=1b"),
        campfire$campfire("", new String[0], 10.0f),
        cfm$grill(0.8f, 0.08f, "fire"),
        cfm$oven(0.8f, 0.08f, "cookingTime"),
        cfm$fire_pit_on(0.8f, 0.08f),
        charcoal_pit$custom_furnace("charcoal_pit:custom_furnace:[active=true]", 0.8f, 0.08f, 0.0f, ""),
        charcoal_pit$bloomery("charcoal_pit:bloomery_hatch:[active=true]", 0.8f, 0.08f, 0.0f, ""),
        cookingforblockheads$toaster(0.4f, 0.0f, "Active"),
        deepresonance$smelter("deepresonance:smelter:[working=true]", 0.8f, 0.08f, 0.0f, ""),
        dumpsterdiving$reingotor("dumpsterdiving:trash_furn:*", 0.8f, 0.08f, 0.0f, "BurnTime"),
        dumpsterdiving$reprocessor("dumpsterdiving:trash_furn_n:*", 0.8f, 0.08f, 0.0f, "BurnTime"),
        dumpsterdiving$regrinder("dumpsterdiving:trash_furn_g:*", 0.8f, 0.08f, 0.0f, "BurnTime"),
        embers$ember_bore("", 0.0f, 0.0f, 1.2f, "isRunning", "", new String[]{"embers:mech_edge:*", "embers:mech_core"}),
        embers$melter("embers:block_furnace", 0.8f, 0.16f, 0.0f, "progress", "", new String[]{"embers:block_furnace:*"}),
        enderio$combustion_generator("enderio:block_combustion_generator:*", new String[0], 1.0f),
        enderio$enhanced_combustion_generator("enderio:block_enhanced_combustion_generator:*", new String[]{"enderio:block_enhanced_combustion_generator_top:*"}, 1.0f),
        enderio$stirling_generator("enderio:block_stirling_generator:*", new String[0], 1.0f),
        f0_resources$burner_drill("f0-resources:burner_drill_part:*", 0.0f, 0.0f, 0.8f, "rotating"),
        f0_resources$drill("f0-resources:drill_part:*", 0.0f, 0.0f, 0.8f, "rotating"),
        forestry$wood_pile("forestry:wood_pile:[active=true]", 0.8f, 0.08f, 0.0f, ""){

            @Override
            Emitter createEmitter(UnitConfig config, UnitId id) {
                return new CharcoalPit(config, id, this.emissions);
            }
        }
        ,
        funores$metalfurnace(0.8f, 0.08f, "BurnTime"),
        funores$alloysmelter(0.8f, 0.8f, "BurnTime"),
        futuremc$blast_furnace("", new String[0], 1.0f),
        futuremc$smoker("", new String[0], 1.0f),
        gadgetrycore$alloy_furnace(0.8f, 0.8f, "ticks"),
        gadgetrymachines$furnace_gen(0.8f, 0.08f, "ticks"),
        gadgetrymachines$grinder(0.0f, 0.0f, 0.8f, "progress"),
        galacticraft$coal_generator("galacticraftcore:machine:[type=coal_generator]", 0.8f, 0.08f, 0.0f, "itemCookTime"),
        galacticraft$ingot_comressor("galacticraftcore:machine:[type=ingot_compressor]", 0.8f, 0.16f, 0.0f, "smeltingTicks"),
        giacomosfoundry$foundry_lit(0.8f, 0.4f),
        gregtech_ce$machines("gregtech:machine:*", new String[]{"gregtech:boiler_casing:*", "gregtech:boiler_firebox_casing:*", "gregtech:turbine_casing:*", "gregtech:machine_casing:*", "gregtech:multiblock_casing:*", "gregtech:metal_casing:*", "gregtech:metal_casing_aluminium:*", "gregtech:metal_casing_americium:*", "gregtech:metal_casing_babbitt_alloy:*", "gregtech:metal_casing_black_steel:*", "gregtech:metal_casing_berkelium:*", "gregtech:metal_casing_bronze:*", "gregtech:metal_casing_californium:*", "gregtech:metal_casing_curium:*", "gregtech:metal_casing_eglin_steel:*", "gregtech:metal_casing_einsteinium:*", "gregtech:metal_casing_enriched_naquadah_alloy:*", "gregtech:metal_casing_fermium:*", "gregtech:metal_casing_grisium:*", "gregtech:metal_casing_gold:*", "gregtech:metal_casing_hastelloy_k243:*", "gregtech:metal_casing_hastelloy_n:*", "gregtech:metal_casing_hastelloy_x78:*", "gregtech:metal_casing_hg_alloy:*", "gregtech:metal_casing_hsss:*", "gregtech:metal_casing_hssg:*", "gregtech:metal_casing_incoloy_ma:*", "gregtech:metal_casing_incoloy813:*", "gregtech:metal_casing_inconel_a:*", "gregtech:metal_casing_invar:*", "gregtech:metal_casing_iron:*", "gregtech:metal_casing_lead:*", "gregtech:metal_casing_maragin_steel_a:*", "gregtech:metal_casing_mendelevium:*", "gregtech:metal_casing_naquadria:*", "gregtech:metal_casing_neptunium:*", "gregtech:metal_casing_nitinol_a:*", "gregtech:metal_casing_potin:*", "gregtech:metal_casing_protactinium:*", "gregtech:metal_casing_plutonium_radioactive:*", "gregtech:metal_casing_quantum:*", "gregtech:metal_casing_red_steel:*", "gregtech:metal_casing_stab_alloy:*", "gregtech:metal_casing_stainless_steel:*", "gregtech:metal_casing_stellite:*", "gregtech:metal_casing_steel:*", "gregtech:metal_casing_talonite:*", "gregtech:metal_casing_thorium:*", "gregtech:metal_casing_titanium:*", "gregtech:metal_casing_tritanium:*", "gregtech:metal_casing_tungsten_steel:*", "gregtech:metal_casing_tumbaga:*", "gregtech:metal_casing_uranium_radioactive:*", "gregtech:metal_casing_zirconium_carbide:*", "gregtech:wire_coil:*", "gtadditions:ga_multiblock_casing:*", "gtadditions:ga_multiblock_casing2:*", "gtadditions:ga_reactor_casing:*", "gtadditions:ga_quantum_casing:*", "gtadditions:ga_machine_casing:*", "gtadditions:ga_fusion_casing:*", "gtadditions:ga_vacuum_casing:*", "gtadditions:ga_heating_coil:*", "gtadditions:ga_divertor_casing:*", "gtadditions:ga_cryostat_casing:*", "gtadditions:ga_transparent_casing:*", "gtadditions:ga_cell_casing:*", "gtadditions:ga_conveyor_casing:*", "gtadditions:ga_field_gen_casing:*", "gtadditions:ga_motor_casing:*", "gtadditions:ga_piston_casing:*", "gtadditions:ga_pump_casing:*", "gtadditions:ga_robot_arm_casing:*", "gtadditions:ga_sensor_casing:*", "gtadditions:ga_emitter_casing:*"}, 1.0f){

            @Override
            Emitter createEmitter(UnitConfig config, UnitId id) {
                return new Gregtech.Machine(config, id, this.activeStateTag, this.relatedBlocks, this.emissions, this.fuelConsumptionRate);
            }
        }
        ,
        hbm$boiler("hbm:machine_boiler_on:*", new String[0], 1.0f),
        hbm$burner_press("hbm:machine_press:*", new String[0], 1.0f),
        hbm$diesel_generator("hbm:machine_diesel:*", new String[0], 1.0f),
        hbm$blast_furnace("hbm:machine_difurnace_on:*", 0.8f, 0.08f, 0.0f, "", "", new String[]{"hbm:machine_difurnace_ext:*"}),
        hbm$combustion_generator("hbm:machine_coal_on:*", new String[0], 1.0f),
        hbm$combustion_generator_start("hbm:machine_coal_off:*", new String[0], 1.0f),
        hbm$firebox("hbm:heater_firebox:*", new String[]{"hbm:heater_firebox:*", "hbm:furnace_steel:*"}, 1.0f),
        hbm$fluid_burner("hbm:heater_oilburner:*", new String[]{"hbm:heater_oilburner:*"}, 1.0f),
        hbm$heating_oven("hbm:heater_oven:*", new String[]{"hbm:heater_oven:*", "hbm:furnace_steel:*"}, 1.0f),
        hbm$gas_flare("hbm:machine_flare:*", new String[]{"hbm:dummy_port_flare:*", "hbm:dummy_block_flare:*"}, 0.4f),
        hbm$industrial_generator("hbm:machine_industrial_generator:*", new String[]{"hbm:machine_industrial_generator:*"}, 1.0f),
        hbm$iron_furnace("hbm:furnace_iron:*", new String[]{"hbm:furnace_iron:*"}, 1.0f),
        hbm$radial_engine("hbm:machine_selenium:*", new String[0], 0.5f),
        hbm$steel_furnace("hbm:furnace_steel:*", new String[]{"hbm:furnace_steel:*"}, 1.0f),
        hbm$turbofan("hbm:machine_turbofan:*", new String[]{"hbm:dummy_port_turbofan:*", "hbm:dummy_block_turbofan:*"}, 1.0f),
        heatandclimate$gas_burner("dcs_climate:dcs_device_gas_burner:*", 0.8f, 0.08f, 0.0f, "BurnTime"),
        heatandclimate$fuel_stove("dcs_climate:dcs_device_fuelstove:*", 0.8f, 0.08f, 0.0f, "BurnTime"),
        heatandclimate$diesel_engine("dcs_climate:dcs_device_diesel_engine:*", 1.2f, 0.12f, 0.0f, "BurnTime"),
        heatandclimate$motor_cart("dcs_climate:dcs.machine.motor_cart", 8.0f, 0.8f){

            @Override
            Emitter createEmitter(UnitConfig config, UnitId id) {
                return new HeatAndClimate.MotorEntity(config, id, Emitters.HARDCODED, this.emissions);
            }
        }
        ,
        heatandclimate$motor_scooter("dcs_climate:dcs.machine.motor_scooter", 8.0f, 0.8f){

            @Override
            Emitter createEmitter(UnitConfig config, UnitId id) {
                return new HeatAndClimate.MotorEntity(config, id, Emitters.HARDCODED, this.emissions);
            }
        }
        ,
        ic2classic$iron_furnace("ic2:blockmachinelv:1", 0.8f, 0.08f, 0.0f, "fuel"),
        ic2classic$stone_macerator("ic2:blockmachinelv:15", 0.8f, 0.08f, 0.0f, "Fuel"),
        ic2classic$wood_gasificator("ic2:blockmachinelv2:0", 0.8f, 0.08f, 0.0f, "Fuel"),
        ic2classic$generator("ic2:blockgenerator:0", 0.8f, 0.08f, 0.0f, "Fuel"),
        ic2classic$liquid_fuel("ic2:blockgenerator:10", 0.8f, 0.08f, 0.0f, "Fuel"),
        ic2classic$slag("ic2:blockgenerator:11", 0.8f, 0.08f, 0.0f, "Fuel"),
        ic2classic$fuel_boiler("ic2:blockgenerator:14", 0.8f, 0.08f, 0.0f, "Fuel"),
        ic2$_common_0("ic2:te:0"),
        ic2$_common_1("ic2:te:1"),
        ic2$generator("ic2:te:3", 0.8f, 0.08f, 0.0f, "active"),
        ic2$geothermal_generator("ic2:te:4", 0.8f, 0.8f, 0.0f, "active"),
        ic2$semifluid_generator("ic2:te:7", 0.8f, 0.08f, 0.0f, "active"),
        ic2$solid_heat_generator("ic2:te:15", 0.8f, 0.08f, 0.0f, "active"),
        ic2$iron_furnace("ic2:te:46", 0.8f, 0.08f, 0.0f, "active"),
        ic2$macerator("ic2:te:47", 0.0f, 0.0f, 0.8f, "active"),
        ic2$centrifuge("ic2:te:52", 0.0f, 0.0f, 0.8f, "active"),
        immersiveengineering$alloy_kiln("immersiveengineering:stone_device:7", new String[0], 1.0f),
        immersiveengineering$coke_oven("immersiveengineering:stone_device:0", new String[0], 1.0f),
        immersiveengineering$blast_furnace("immersiveengineering:stone_device:1", new String[0], 1.0f),
        immersiveengineering$improved_blast_furnace("immersiveengineering:stone_device:2", new String[0], 1.0f),
        immersiveengineering$diesel_generator("immersiveengineering:metal_multiblock:10", new String[0], 1.0f),
        immersiveengineering$sample_drill("immersiveengineering:metal_device1:7", 0.0f, 0.0f, 0.8f, "active"),
        immersivetech$boiler("immersivetech:metal_multiblock:4", new String[]{"immersivetech:metal_multiblock:9"}, 1.0f),
        immersivetech$coke_oven_advanced("immersivetech:stone_multiblock:0", 0.8f, 0.08f, 0.0f, "active", "", new String[]{"immersivetech:stone_multiblock:1"}),
        industrialforegoing$biofuel_generator("", new String[0], 1.0f),
        industrialforegoing$pitiful_fuel_generator("", new String[0], 1.0f),
        industrialforegoing$petrified_fuel_generator("", new String[0], 1.0f),
        industrialforegoing$protein_generator("", new String[0], 1.0f),
        industrialrenewal$steam_boiler("", new String[]{"industrialrenewal:steam_boiler:*"}, 1.0f),
        industrialrenewal$portable_generator("", new String[0], 1.0f),
        industrialrenewal$mining("", 0.0f, 0.0f, 0.8f, "running", "", new String[]{"industrialrenewal:mining:*"}),
        libvulpes$coal_generator("libvulpes:coalgenerator:[state=true]", 0.8f, 0.08f, 0.0f, ""),
        lucraftcore$furnace_generator("", 0.8f, 0.08f, 0.0f, "Fuel"),
        magneticraft$big_combustion_chamber("", 0.0f, 0.0f, 0.0f, "", "", new String[]{"magneticraft:multiblock_gap:*"}),
        mekanism$crusher("mekanism:machineblock:3", 0.0f, 0.0f, 0.8f, "isActive"),
        mekanism$basic_crushing_factory("mekanism:machineblock:5", 0.0f, 0.0f, 0.8f, "isActive", "recipeType=2"),
        mekanism$advanced_crushing_factory("mekanism:machineblock:6", 0.0f, 0.0f, 1.2f, "isActive", "recipeType=2"),
        mekanism$elite_crushing_factory("mekanism:machineblock:7", 0.0f, 0.0f, 1.8f, "isActive", "recipeType=2"),
        mekanism$fuelwood_heater("mekanism:machineblock3:6", new String[0], 1.0f),
        mekanismgenerators$heat_generator("mekanismgenerators:generator:0", new String[0], 1.0f),
        mekanismgenerators$gas_generator("mekanismgenerators:generator:3", new String[0], 1.0f),
        mekanismgenerators$bio_generator("mekanismgenerators:generator:4", new String[0], 1.0f),
        metallurgy$crusher(0.0f, 0.0f, 0.8f, "crush_time"),
        minecraft$furnace("minecraft:furnace:*", new String[0], 1.0f),
        minecraft$lit_furnace("minecraft:lit_furnace:*", new String[0], 1.0f),
        minecraft$furnace_minecart("", 0.8f, 0.08f, 0.0f, "Fuel", "", true),
        minecraft$fire(0.0f, 0.0f){

            @Override
            Emitter createEmitter(UnitConfig config, UnitId id) {
                return new Minecraft.Fire(config, id, Emitters.HARDCODED, this.relatedBlocks, this.emissions);
            }
        }
        ,
        minecraft$lava(0.0f, 0.0f),
        mts$mts_entity(8.0f, 0.8f){

            @Override
            Emitter createEmitter(UnitConfig config, UnitId id) {
                return new ImmersiveVehicles.Vehicle(config, id, Emitters.HARDCODED, this.emissions);
            }
        }
        ,
        omegacraft$combustion_generator("omegacraft:gen_coalb:*", 0.8f, 0.08f, 0.0f, "fuel"),
        omegacraft$hungry_generator("omegacraft:gen_foodb:*", 0.8f, 0.0f, 0.0f, "fuel"),
        omegacraft$lava_generator("omegacraft:gen_lavab:*", 0.08f, 0.8f, 0.0f, "fuel"),
        omegacraft$crusher("omegacraft:electric_crusherb:*", 0.0f, 0.0f, 0.8f, "running"),
        omegacraft$advanced_crusher("omegacraft:electric_crusher_advb:*", 0.0f, 0.0f, 0.8f, "running"),
        omegacraft$dark_crusher("omegacraft:electric_crusher_darkb:*", 0.0f, 0.0f, 0.8f, "running"),
        pneumaticcraft$air_compressor("pneumaticcraft:air_compressor:[on=true]", 0.8f, 0.08f, 0.0f, ""),
        pneumaticcraft$advanced_air_compressor("pneumaticcraft:advanced_air_compressor:[on=true]", 0.8f, 0.08f, 0.0f, ""),
        primal$hibachi("primal:hibachi:[lit=true]", 0.6f, 0.06f, 0.0f, ""),
        primal$kiln_adobe("primal:kiln_adobe:[lit=true]", 0.8f, 0.08f, 0.0f, ""),
        primal$smelter("primal:smelter:[lit=true]", 0.8f, 0.08f, 0.0f, ""),
        projecte$dm_furnace_lit(0.8f, 0.08f),
        projecte$rm_furnace_lit(0.8f, 0.12f),
        pyrotech$bloomery("pyrotech:bloomery:[type=bottom_lit]", 0.8f, 0.08f, 0.0f, ""),
        pyrotech$wither_forge("pyrotech:wither_forge:[type=bottom_lit]", 0.8f, 0.4f, 0.0f, ""),
        railcraft$boiler_firebox_fluid("", 0.8f, 0.08f, 0.0f, "burnTime", "master=1b"),
        railcraft$boiler_firebox_solid("", 0.8f, 0.08f, 0.0f, "burnTime", "master=1b"),
        railcraft$cart_furnace("", 0.8f, 0.08f, 0.0f, "Fuel", "", true),
        railcraft$coke_oven("", 0.8f, 0.08f, 0.0f, "cooking", "master=1b"),
        railcraft$coke_oven_red("", 0.8f, 0.08f, 0.0f, "cooking", "master=1b"),
        railcraft$blast_furnace("", 0.8f, 0.08f, 0.0f, "burnTime", "master=1b"),
        railcraft$locomotive_steam_solid("", 0.8f, 0.08f, 0.0f, "burnTime", "", true),
        railcraft$smoker("railcraft:equipment:[variant=smoker]", 0.4f, 0.0f, 0.0f, ""),
        rockhounding_oretiers$bloomery(0.8f, 0.8f, "CastTime"),
        tcomplement$melter("", 0.8f, 0.8f, 0.0f, "", "", new String[]{"tcomplement:melter:*", "tconstruct:seared_tank:*"}){

            @Override
            Emitter createEmitter(UnitConfig config, UnitId id) {
                return new TConstruct.HeatingStructure(config, id, Emitters.HARDCODED, this.relatedBlocks, this.emissions);
            }
        }
        ,
        tcomplement$high_oven_controller("", 0.8f, 0.8f, 0.0f, "", "", new String[]{"tcomplement:scorched_block:*", "tcomplement:high_oven_io:*"}){

            @Override
            Emitter createEmitter(UnitConfig config, UnitId id) {
                return new TConstruct.HeatingStructure(config, id, Emitters.HARDCODED, this.relatedBlocks, this.emissions);
            }
        }
        ,
        tcomplement$porcelain_melter("", 0.8f, 0.8f, 0.0f, "", "", new String[]{"tcomplement:melter:*", "tconstruct:seared_tank:*"}){

            @Override
            Emitter createEmitter(UnitConfig config, UnitId id) {
                return new TConstruct.HeatingStructure(config, id, Emitters.HARDCODED, this.relatedBlocks, this.emissions);
            }
        }
        ,
        tconstruct$smeltery_controller("", 0.8f, 0.8f, 0.0f, "", "", new String[]{"tconstruct:seared:*", "tconstruct:seared_tank:*", "tconstruct:seared_glass:*", "tconstruct:smeltery_io:*"}){

            @Override
            Emitter createEmitter(UnitConfig config, UnitId id) {
                return new TConstruct.HeatingStructure(config, id, Emitters.HARDCODED, this.relatedBlocks, this.emissions);
            }
        }
        ,
        tconstruct$seared_furnace_controller("", 0.8f, 0.8f, 0.0f, "", "", new String[]{"tconstruct:seared:*", "tconstruct:seared_tank:*", "tconstruct:seared_glass:*"}){

            @Override
            Emitter createEmitter(UnitConfig config, UnitId id) {
                return new TConstruct.HeatingStructure(config, id, Emitters.HARDCODED, this.relatedBlocks, this.emissions);
            }
        }
        ,
        techguns$grinder("techguns:simplemachine2:*", 0.0f, 0.0f, 0.8f, "progress"),
        techreborn$grinder("techreborn:grinder:[active=true]", 0.0f, 0.0f, 0.8f, ""),
        techreborn$industrial_sawmill("techreborn:industrial_sawmill:[active=true]", 0.05f, 0.0f, 0.8f, ""),
        techreborn$industrial_grinder("techreborn:industrial_grinder:[active=true]", 0.0f, 0.0f, 3.2f, ""),
        tfc$charcoal_forge("tfc:charcoal_forge:[lit=true]", 0.8f, 0.08f, 0.0f, "", "", new String[]{"tfc:bellows:*", "tfc:crucible:*"}),
        tfc$charcoal_pit("tfc:log_pile:[lit=true]", 0.2f, 0.02f, 0.0f, ""){

            @Override
            Emitter createEmitter(UnitConfig config, UnitId id) {
                return new CharcoalPit(config, id, this.emissions);
            }
        }
        ,
        tfc$firepit("tfc:firepit:[lit=true]", 1.2f, 0.12f, 0.0f, ""),
        tfc$molten("tfc:molten:[lit=true]", 0.8f, 0.08f, 0.0f, "", "", new String[]{"tfc:molten:*"}),
        tfc$pit_kiln("tfc:pit_kiln:[lit=true]", 1.6f, 0.16f, 0.0f, ""),
        thaumcraft$infernal_furnace("", 1.6f, 0.4f, 0.0f, "CookTime", "", new String[]{"thaumcraft:placeholder_obsidian", "thaumcraft:placeholder_brick"}),
        thaumcraft$smelter_basic(0.8f, 0.08f, "BurnTime"),
        thaumcraft$smelter_thaumium(0.9f, 0.09f, "BurnTime"),
        thaumcraft$smelter_void(1.0f, 0.1f, "BurnTime"),
        thermalexpansion$pulverizer("thermalexpansion:machine:1", 0.0f, 0.0f, 0.8f, "Active"),
        thermalexpansion$centrifuge("thermalexpansion:machine:10", 0.0f, 0.0f, 0.4f, "Active"),
        thermalexpansion$dynamo_steam("thermalexpansion:dynamo:0", 0.8f, 0.08f, 0.0f, "Active"),
        thermalexpansion$dynamo_magmatic("thermalexpansion:dynamo:1", 0.2f, 0.32f, 0.0f, "Active"),
        thermalexpansion$dynamo_compression("thermalexpansion:dynamo:2", 0.8f, 0.08f, 0.0f, "Active"),
        thermalexpansion$dynamo_reactant("thermalexpansion:dynamo:3", 0.4f, 0.16f, 0.0f, "Active"),
        thermalexpansion$sawmill("thermalexpansion:machine:2", 0.0f, 0.0f, 0.8f, "Active"),
        toughasnails$campfire("toughasnails:campfire:[burning=true]", 0.4f, 0.08f, 0.0f, "");

        final String id;
        final Emissions emissions;
        final String activeStateTag;
        final String identityTag;
        final boolean isEntity;
        final boolean useDroppedItemMeta;
        final String[] relatedBlocks;
        final float fuelConsumptionRate;

        private BuiltInEmitters(String id) {
            this(id, "", false, "", true, new String[0], Emissions.of(), 1.0f);
        }

        private BuiltInEmitters(String id, String[] relatedBlocks, float fuelConsumptionRate) {
            this(id, Emitters.HARDCODED_FUEL, false, "", false, relatedBlocks, Emissions.of().carbon(1.0f).sulfur(1.0f), fuelConsumptionRate);
        }

        private BuiltInEmitters(float carbon, float sulfur) {
            this(carbon, sulfur, "");
        }

        private BuiltInEmitters(float carbon, float sulfur, String activeStateTag) {
            this(carbon, sulfur, 0.0f, activeStateTag);
        }

        private BuiltInEmitters(float carbon, float sulfur, float dust) {
            this(carbon, sulfur, dust, "");
        }

        private BuiltInEmitters(float carbon, float sulfur, float dust, String activeStateTag) {
            this("", carbon, sulfur, dust, activeStateTag, "", false);
        }

        private BuiltInEmitters(String id, float carbon, float sulfur) {
            this(id, carbon, sulfur, 0.0f, "");
        }

        private BuiltInEmitters(String id, float carbon, float sulfur, float dust, String activeStateTag) {
            this(id, carbon, sulfur, dust, activeStateTag, "");
        }

        private BuiltInEmitters(String id, float carbon, float sulfur, float dust, String activeStateTag, String identityTag) {
            this(id, carbon, sulfur, dust, activeStateTag, identityTag, false);
        }

        private BuiltInEmitters(String id, float carbon, float sulfur, float dust, String activeStateTag, String identityTag, String[] relatedBlocks) {
            this(id, activeStateTag, false, identityTag, false, relatedBlocks, Emissions.of().carbon(carbon).sulfur(sulfur).dust(dust), 1.0f);
        }

        private BuiltInEmitters(String id, float carbon, float sulfur, float dust, String activeStateTag, String identityTag, boolean isEntity) {
            this(id, activeStateTag, isEntity, identityTag, false, new String[0], Emissions.of().carbon(carbon).sulfur(sulfur).dust(dust), 1.0f);
        }

        private BuiltInEmitters(String id, String activeStateTag, boolean isEntity, String identityTag, boolean useDroppedItemMeta, String[] relatedBlocks, Emissions emissions, float fuelConsumptionRate) {
            this.id = id;
            this.emissions = emissions;
            this.activeStateTag = activeStateTag;
            this.identityTag = identityTag;
            this.isEntity = isEntity;
            this.useDroppedItemMeta = useDroppedItemMeta;
            this.relatedBlocks = relatedBlocks;
            this.fuelConsumptionRate = fuelConsumptionRate;
        }

        public String func_176610_l() {
            return this.getLowerCase(this.name());
        }

        Emitter createEmitter(UnitConfig config, UnitId id) {
            return new Emitter(config, id, KeyValuePair.from((String)this.identityTag), this.isEntity, this.activeStateTag, this.useDroppedItemMeta, this.relatedBlocks, this.emissions, this.fuelConsumptionRate);
        }
    }
}

