/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.events;

import com.endertech.minecraft.forge.materials.RepairMatcher;
import com.endertech.minecraft.mods.adpother.Main;
import com.endertech.minecraft.mods.adpother.blocks.Filter;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.init.Pollutants;
import com.endertech.minecraft.mods.adpother.init.Respirators;
import com.endertech.minecraft.mods.adpother.items.VacuumBag;
import com.endertech.minecraft.mods.adpother.pollution.IStorageItem;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHopper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class AnvilEvents {
    public static int filterReplacingExpGain = 0;

    @SubscribeEvent
    public static void onVacuumBagPlaced(AnvilUpdateEvent event) {
        Item item = event.getLeft().func_77973_b();
        if (item instanceof VacuumBag) {
            AnvilEvents.cleanAndPrepare((VacuumBag)item, 2, event);
        }
    }

    @SubscribeEvent
    public static void onRespiratorPlaced(AnvilUpdateEvent event) {
        ItemStack stack = event.getLeft();
        Respirators.Respirator respirator = (Respirators.Respirator)Main.getRespirators().findBy(stack);
        if (respirator == null) {
            return;
        }
        if (AnvilEvents.tryInstallHopper(event)) {
            return;
        }
        AnvilEvents.cleanAndPrepare(respirator, 1, event);
    }

    @SubscribeEvent
    public static void onRepair(AnvilRepairEvent event) {
        ItemStack stack = event.getItemInput();
        Item item = stack.func_77973_b();
        if (item instanceof VacuumBag || Block.func_149634_a((Item)item) instanceof Filter || Main.getRespirators().findBy(stack) != null) {
            event.setBreakChance(0.0f);
            event.getEntityPlayer().func_82242_a(filterReplacingExpGain + 1);
        }
    }

    private static boolean tryInstallHopper(AnvilUpdateEvent event) {
        Block block = Block.func_149634_a((Item)event.getRight().func_77973_b());
        if (block instanceof BlockHopper) {
            ItemStack output = event.getLeft().func_77946_l();
            Respirators.Respirator.setAllowsEatingTag(output, true);
            event.setCost(1);
            event.setMaterialCost(1);
            event.setOutput(output);
            return true;
        }
        return false;
    }

    private static boolean cleanAndPrepare(IStorageItem storage, int materialAmount, AnvilUpdateEvent event) {
        RepairMatcher matcher = RepairMatcher.from((AnvilUpdateEvent)event);
        Pollutants pollutants = Main.getPollutants();
        if (matcher.materialCount < materialAmount) {
            return false;
        }
        ItemStack output = event.getLeft().func_77946_l();
        boolean result = false;
        for (Pollutant pollutant : pollutants.getAll()) {
            if (!pollutant.getFilterMaterials().contains(matcher.materialState)) continue;
            storage.installFiltersFor(output, pollutant);
            event.setCost(1);
            event.setMaterialCost(materialAmount);
            event.setOutput(output);
            result = true;
        }
        return result;
    }
}

