/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import minecrafttransportsimulator.entities.instances.PartSeat;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.packets.components.APacketEntity;

public class PacketPartSeat
extends APacketEntity<PartSeat> {
    private final SeatAction packetType;

    public PacketPartSeat(PartSeat seat, SeatAction packetType) {
        super(seat);
        this.packetType = packetType;
    }

    public PacketPartSeat(ByteBuf buf) {
        super(buf);
        this.packetType = SeatAction.values()[buf.readByte()];
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        buf.writeByte(this.packetType.ordinal());
    }

    @Override
    public boolean handle(AWrapperWorld world, PartSeat seat) {
        switch (this.packetType) {
            case CHANGE_GUN: {
                seat.setNextActiveGun();
                return true;
            }
            case ZOOM_IN: {
                if (seat.zoomLevel > 0) {
                    --seat.zoomLevel;
                    return true;
                }
                return false;
            }
            case ZOOM_OUT: {
                ++seat.zoomLevel;
                return true;
            }
        }
        return false;
    }

    public static enum SeatAction {
        CHANGE_GUN,
        ZOOM_IN,
        ZOOM_OUT;

    }
}

