/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.items.instances;

import java.util.List;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.entities.components.AEntityE_Interactable;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.entities.instances.EntityFluidTank;
import minecrafttransportsimulator.entities.instances.EntityFurnace;
import minecrafttransportsimulator.entities.instances.EntityInventoryContainer;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.entities.instances.PartInteractable;
import minecrafttransportsimulator.items.components.AItemPart;
import minecrafttransportsimulator.items.components.IItemEntityInteractable;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONPartDefinition;
import minecrafttransportsimulator.jsondefs.JSONSubDefinition;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperItemStack;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.instances.PacketFurnaceFuelAdd;
import minecrafttransportsimulator.packets.instances.PacketItemInteractable;
import minecrafttransportsimulator.packets.instances.PacketPlayerChatMessage;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.systems.LanguageSystem;

public class ItemPartInteractable
extends AItemPart
implements IItemEntityInteractable {
    public static final AItemPart.AItemPartCreator CREATOR = new AItemPart.AItemPartCreator(){

        @Override
        public boolean isCreatorValid(JSONPart definition) {
            return definition.generic.type.startsWith("interactable");
        }

        @Override
        public ItemPartInteractable createItem(JSONPart definition, JSONSubDefinition subDefinition, String sourcePackID) {
            return new ItemPartInteractable(definition, subDefinition, sourcePackID);
        }
    };

    public ItemPartInteractable(JSONPart definition, JSONSubDefinition subDefinition, String sourcePackID) {
        super(definition, subDefinition, sourcePackID);
    }

    @Override
    public boolean isPartValidForPackDef(JSONPartDefinition placementDefinition, JSONSubDefinition subDefinition, boolean checkMinMax) {
        return super.isPartValidForPackDef(placementDefinition, subDefinition, checkMinMax) && (!checkMinMax || placementDefinition.minValue <= ((JSONPart)this.definition).interactable.inventoryUnits && placementDefinition.maxValue >= ((JSONPart)this.definition).interactable.inventoryUnits);
    }

    @Override
    public PartInteractable createPart(AEntityF_Multipart<?> entity, IWrapperPlayer placingPlayer, JSONPartDefinition packVehicleDef, IWrapperNBT partData) {
        return new PartInteractable(entity, placingPlayer, packVehicleDef, this, partData);
    }

    @Override
    public void addTooltipLines(List<String> tooltipLines, IWrapperNBT data) {
        super.addTooltipLines(tooltipLines, data);
        switch (((JSONPart)this.definition).interactable.interactionType) {
            case CRATE: {
                tooltipLines.add(LanguageSystem.ITEMINFO_INTERACTABLE_CAPACITY.getCurrentValue() + ((JSONPart)this.definition).interactable.inventoryUnits * 9.0f);
                break;
            }
            case BARREL: {
                tooltipLines.add(LanguageSystem.ITEMINFO_INTERACTABLE_CAPACITY.getCurrentValue() + ((JSONPart)this.definition).interactable.inventoryUnits * 10000.0f + "mb");
                break;
            }
            case JERRYCAN: {
                tooltipLines.add(LanguageSystem.ITEMINFO_JERRYCAN_FILL.getCurrentValue());
                tooltipLines.add(LanguageSystem.ITEMINFO_JERRYCAN_DRAIN.getCurrentValue());
                String jerrycanFluid = data.getString("jerrycanFluid");
                if (jerrycanFluid.isEmpty()) {
                    tooltipLines.add(LanguageSystem.ITEMINFO_JERRYCAN_EMPTY.getCurrentValue());
                    break;
                }
                tooltipLines.add(LanguageSystem.ITEMINFO_JERRYCAN_CONTAINS.getCurrentValue() + InterfaceManager.clientInterface.getFluidName(jerrycanFluid));
                break;
            }
        }
    }

    @Override
    public IItemEntityInteractable.CallbackType doEntityInteraction(AEntityE_Interactable<?> entity, BoundingBox hitBox, IWrapperPlayer player, AEntityE_Interactable.PlayerOwnerState ownerState, boolean rightClick) {
        if (((JSONPart)this.definition).interactable.interactionType.equals((Object)JSONPart.InteractableComponentType.JERRYCAN)) {
            if (!entity.world.isClient() && rightClick) {
                String jerrrycanFluid;
                IWrapperItemStack stack = player.getHeldStack();
                IWrapperNBT data = stack.getData();
                String string = jerrrycanFluid = data != null ? data.getString("jerrycanFluid") : "";
                if (entity instanceof PartInteractable) {
                    EntityFurnace furnace;
                    EntityFluidTank tank = ((PartInteractable)entity).tank;
                    if (tank != null && jerrrycanFluid.isEmpty() && tank.getFluidLevel() >= 1000.0) {
                        if (data == null) {
                            data = InterfaceManager.coreInterface.getNewNBTWrapper();
                        }
                        data.setString("jerrycanFluid", tank.getFluid());
                        stack.setData(data);
                        tank.drain(tank.getFluid(), 1000.0, true);
                    }
                    if ((furnace = ((PartInteractable)entity).furnace) != null && !jerrrycanFluid.isEmpty()) {
                        if (ConfigSystem.settings.fuel.fuels.get("furnace").containsKey(jerrrycanFluid)) {
                            int addedFuel = (int)(ConfigSystem.settings.fuel.fuels.get("furnace").get(jerrrycanFluid) * 1000.0 * 20.0 * (double)furnace.definition.furnaceEfficiency);
                            int priorFuel = furnace.ticksLeftOfFuel;
                            furnace.ticksLeftOfFuel = addedFuel;
                            InterfaceManager.packetInterface.sendToAllClients(new PacketFurnaceFuelAdd(furnace));
                            furnace.ticksLeftOfFuel += priorFuel;
                            furnace.ticksAddedOfFuel = furnace.ticksLeftOfFuel;
                            data.setString("jerrycanFluid", "");
                            stack.setData(data);
                            player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_JERRYCAN_SUCCESS, new Object[0]));
                        } else {
                            player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_JERRYCAN_WRONGTYPE, new Object[0]));
                        }
                    }
                } else if (!jerrrycanFluid.isEmpty()) {
                    if (entity instanceof EntityVehicleF_Physics) {
                        EntityVehicleF_Physics vehicle = (EntityVehicleF_Physics)entity;
                        switch (vehicle.checkFuelTankCompatibility(jerrrycanFluid)) {
                            case VALID: {
                                if (vehicle.fuelTank.getFluidLevel() + 1000.0 > (double)vehicle.fuelTank.getMaxLevel()) {
                                    player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_JERRYCAN_TOOFULL, new Object[0]));
                                    break;
                                }
                                vehicle.fuelTank.fill(jerrrycanFluid, 1000.0, true);
                                data.setString("jerrycanFluid", "");
                                stack.setData(data);
                                player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_JERRYCAN_SUCCESS, new Object[0]));
                                break;
                            }
                            case INVALID: {
                                player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_JERRYCAN_WRONGENGINES, new Object[0]));
                                break;
                            }
                            case MISMATCH: {
                                player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_JERRYCAN_WRONGTYPE, new Object[0]));
                                break;
                            }
                            case NOENGINE: {
                                player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_JERRYCAN_NOENGINE, new Object[0]));
                            }
                        }
                    }
                } else {
                    player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_JERRYCAN_EMPTY, new Object[0]));
                }
            }
            return IItemEntityInteractable.CallbackType.NONE;
        }
        return IItemEntityInteractable.CallbackType.SKIP;
    }

    @Override
    public boolean onUsed(AWrapperWorld world, IWrapperPlayer player) {
        if (((JSONPart)this.definition).interactable.canBeOpenedInHand && ((JSONPart)this.definition).interactable.interactionType.equals((Object)JSONPart.InteractableComponentType.CRATE) && player.isSneaking()) {
            if (!world.isClient()) {
                IWrapperNBT data = player.getHeldStack().getData();
                EntityInventoryContainer inventory = new EntityInventoryContainer(world, data != null ? data.getData("inventory") : null, (int)(((JSONPart)this.definition).interactable.inventoryUnits * 9.0f), ((JSONPart)this.definition).interactable.inventoryStackSize > 0 ? ((JSONPart)this.definition).interactable.inventoryStackSize : 64);
                world.addEntity(inventory);
                player.sendPacket(new PacketItemInteractable(player, inventory, ((JSONPart)this.definition).interactable.inventoryTexture));
            }
            return true;
        }
        return false;
    }
}

