/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.entities.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import minecrafttransportsimulator.baseclasses.AnimationSwitchbox;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.BoundingBoxHitResult;
import minecrafttransportsimulator.baseclasses.ColorRGB;
import minecrafttransportsimulator.baseclasses.Damage;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.baseclasses.TransformationMatrix;
import minecrafttransportsimulator.entities.components.AEntityB_Existing;
import minecrafttransportsimulator.entities.components.AEntityE_Interactable;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.EntityBullet;
import minecrafttransportsimulator.entities.instances.EntityPlacedPart;
import minecrafttransportsimulator.entities.instances.PartSeat;
import minecrafttransportsimulator.items.components.AItemBase;
import minecrafttransportsimulator.items.components.AItemPart;
import minecrafttransportsimulator.items.components.AItemSubTyped;
import minecrafttransportsimulator.items.instances.ItemItem;
import minecrafttransportsimulator.jsondefs.AJSONPartProvider;
import minecrafttransportsimulator.jsondefs.JSONAnimationDefinition;
import minecrafttransportsimulator.jsondefs.JSONBullet;
import minecrafttransportsimulator.jsondefs.JSONDummyPartProvider;
import minecrafttransportsimulator.jsondefs.JSONItem;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONPartDefinition;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperEntity;
import minecrafttransportsimulator.mcinterface.IWrapperItemStack;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.instances.PacketEntityBulletHitCollision;
import minecrafttransportsimulator.packets.instances.PacketEntityBulletHitEntity;
import minecrafttransportsimulator.packets.instances.PacketEntityBulletHitGeneric;
import minecrafttransportsimulator.packets.instances.PacketEntityVariableToggle;
import minecrafttransportsimulator.packets.instances.PacketPartChange_Add;
import minecrafttransportsimulator.packets.instances.PacketPartChange_Remove;
import minecrafttransportsimulator.packets.instances.PacketPartChange_Transfer;
import minecrafttransportsimulator.packets.instances.PacketPlayerChatMessage;
import minecrafttransportsimulator.packloading.PackParser;
import minecrafttransportsimulator.systems.LanguageSystem;

public abstract class AEntityF_Multipart<JSONDefinition extends AJSONPartProvider>
extends AEntityE_Interactable<JSONDefinition> {
    public final List<APart> parts = new ArrayList<APart>();
    public final List<APart> allParts = new ArrayList<APart>();
    public final List<APart> partsInSlots = new ArrayList<APart>();
    public final List<BoundingBox> allBlockCollisionBoxes = new ArrayList<BoundingBox>();
    public final List<BoundingBox> allEntityCollisionBoxes = new ArrayList<BoundingBox>();
    public final List<BoundingBox> allInteractionBoxes = new ArrayList<BoundingBox>();
    public final List<BoundingBox> allBulletCollisionBoxes = new ArrayList<BoundingBox>();
    public final List<BoundingBox> allDamageCollisionBoxes = new ArrayList<BoundingBox>();
    public final Map<BoundingBox, JSONPartDefinition> partSlotBoxes = new HashMap<BoundingBox, JSONPartDefinition>();
    private final Map<JSONPartDefinition, AnimationSwitchbox> partSlotSwitchboxes = new HashMap<JSONPartDefinition, AnimationSwitchbox>();
    public final Map<BoundingBox, JSONPartDefinition> activePartSlotBoxes = new HashMap<BoundingBox, JSONPartDefinition>();
    public final Map<BoundingBox, JSONPartDefinition> allPartSlotBoxes = new HashMap<BoundingBox, JSONPartDefinition>();
    private static final float PART_SLOT_HITBOX_WIDTH = 0.75f;
    private static final float PART_SLOT_HITBOX_HEIGHT = 2.25f;
    private static final Point3D PART_TRANSFER_GROWTH = new Point3D(16.0, 16.0, 16.0);
    private APart partToPlace;
    private EntityPlacedPart placedPart;
    private int placeTimer;

    public AEntityF_Multipart(AWrapperWorld world, IWrapperPlayer placingPlayer, AItemSubTyped<JSONDefinition> item, IWrapperNBT data) {
        super(world, placingPlayer, item, data);
        if (data == null && ((AJSONPartProvider)this.definition).constantValues != null) {
            this.variables.putAll(((AJSONPartProvider)this.definition).constantValues);
        }
        if (((AJSONPartProvider)this.definition).parts != null) {
            while (this.partsInSlots.size() < ((AJSONPartProvider)this.definition).parts.size()) {
                this.partsInSlots.add(null);
            }
        }
    }

    @Override
    protected void initializeAnimations() {
        super.initializeAnimations();
        if (((AJSONPartProvider)this.definition).parts != null) {
            if (this.partsInSlots.size() > ((AJSONPartProvider)this.definition).parts.size()) {
                ArrayList<APart> removedParts = new ArrayList<APart>();
                while (this.partsInSlots.size() > ((AJSONPartProvider)this.definition).parts.size()) {
                    APart partRemoved = this.partsInSlots.remove(this.partsInSlots.size() - 1);
                    if (partRemoved == null) continue;
                    removedParts.add(partRemoved);
                }
                removedParts.forEach(part -> {
                    this.parts.remove(part);
                    part.remove();
                });
            }
            while (this.partsInSlots.size() < ((AJSONPartProvider)this.definition).parts.size()) {
                this.partsInSlots.add(null);
            }
            this.parts.forEach(part -> {
                if (!part.isFake()) {
                    part.placementDefinition = ((AJSONPartProvider)this.definition).parts.get(part.placementSlot);
                    part.animationsInitialized = false;
                }
            });
            if (((AJSONPartProvider)this.definition).parts != null) {
                this.partSlotSwitchboxes.clear();
                for (JSONPartDefinition partDef : ((AJSONPartProvider)this.definition).parts) {
                    if (partDef.animations == null && partDef.applyAfter == null) continue;
                    ArrayList<JSONAnimationDefinition> animations = new ArrayList<JSONAnimationDefinition>();
                    if (partDef.animations != null) {
                        animations.addAll(partDef.animations);
                    }
                    this.partSlotSwitchboxes.put(partDef, new AnimationSwitchbox(this, animations, partDef.applyAfter));
                }
            }
            this.recalculatePartSlots();
        }
        this.updatePartList();
    }

    @Override
    public void update() {
        this.updateVariableModifiers();
        for (APart part : this.parts) {
            part.updateVariableModifiers();
        }
        super.update();
        this.world.beginProfiling("EntityF_Level", true);
        if (this.partToPlace != null && --this.placeTimer == 0) {
            JSONPartDefinition otherPartDef = (JSONPartDefinition)((JSONDummyPartProvider)this.placedPart.definition).parts.get(0);
            this.partToPlace.linkToEntity(this.placedPart, otherPartDef);
            this.placedPart.addPart(this.partToPlace, false);
            InterfaceManager.packetInterface.sendToAllClients(new PacketPartChange_Transfer(this.partToPlace, this.placedPart, otherPartDef));
            this.partToPlace = null;
            this.placedPart = null;
        }
        if (this.world.isClient() && !this.partSlotBoxes.isEmpty()) {
            this.world.beginProfiling("PartSlotActives", false);
            this.activePartSlotBoxes.clear();
            if (this.canBeClicked()) {
                IWrapperPlayer player = InterfaceManager.clientInterface.getClientPlayer();
                AItemBase heldItem = player.getHeldItem();
                if (heldItem instanceof AItemPart) {
                    Iterator<Map.Entry<BoundingBox, JSONPartDefinition>> iterator = this.partSlotBoxes.entrySet().iterator();
                    while (iterator.hasNext()) {
                        AItemPart heldPart = (AItemPart)heldItem;
                        Map.Entry<BoundingBox, JSONPartDefinition> partSlotBoxEntry = iterator.next();
                        if (!heldPart.isPartValidForPackDef(partSlotBoxEntry.getValue(), this.subDefinition, false) || !this.isVariableListTrue(partSlotBoxEntry.getValue().interactableVariables)) continue;
                        BoundingBox box2 = partSlotBoxEntry.getKey();
                        box2.widthRadius = (((JSONPart)heldPart.definition).generic.width != 0.0f ? (double)((JSONPart)heldPart.definition).generic.width / 2.0 : 0.375) * this.scale.x;
                        box2.heightRadius = (((JSONPart)heldPart.definition).generic.height != 0.0f ? (double)((JSONPart)heldPart.definition).generic.height / 2.0 : 1.125) * this.scale.y;
                        box2.depthRadius = (((JSONPart)heldPart.definition).generic.width != 0.0f ? (double)((JSONPart)heldPart.definition).generic.width / 2.0 : 0.375) * this.scale.z;
                        this.activePartSlotBoxes.put(partSlotBoxEntry.getKey(), partSlotBoxEntry.getValue());
                        this.forceCollisionUpdateThisTick = true;
                        if (!(this instanceof APart)) continue;
                        ((APart)this).masterEntity.forceCollisionUpdateThisTick = true;
                    }
                } else if (heldItem instanceof ItemItem && ((JSONItem)((ItemItem)heldItem).definition).item.type == JSONItem.ItemComponentType.SCANNER) {
                    for (Map.Entry<BoundingBox, JSONPartDefinition> partSlotBoxEntry : this.partSlotBoxes.entrySet()) {
                        if (!this.isVariableListTrue(partSlotBoxEntry.getValue().interactableVariables)) continue;
                        this.activePartSlotBoxes.put(partSlotBoxEntry.getKey(), partSlotBoxEntry.getValue());
                        this.forceCollisionUpdateThisTick = true;
                    }
                }
            }
            if (this.requiresDeltaUpdates()) {
                this.world.beginProfiling("PartSlotPositions", false);
                this.activePartSlotBoxes.forEach((box, partDef) -> {
                    AnimationSwitchbox switchBox = this.partSlotSwitchboxes.get(partDef);
                    if (switchBox != null) {
                        if (switchBox.runSwitchbox(0.0f, false)) {
                            box.globalCenter.set(box.localCenter).transform(switchBox.netMatrix);
                            box.updateToEntity(this, box.globalCenter);
                        }
                    } else {
                        box.updateToEntity(this, null);
                    }
                });
            }
        }
        if (!this.world.isClient() && ((AJSONPartProvider)this.definition).parts != null) {
            for (int i = 0; i < ((AJSONPartProvider)this.definition).parts.size(); ++i) {
                JSONPartDefinition partDef2 = ((AJSONPartProvider)this.definition).parts.get(i);
                if (partDef2.transferVariable == null || !this.isVariableActive(partDef2.transferVariable)) continue;
                this.transferPart(partDef2);
                this.toggleVariable(partDef2.transferVariable);
                InterfaceManager.packetInterface.sendToAllClients(new PacketEntityVariableToggle(this, partDef2.transferVariable));
            }
        }
        this.world.endProfiling();
    }

    private void transferPart(JSONPartDefinition partDef) {
        AEntityF_Multipart<?> masterEntity;
        int ourSlotIndex = ((AJSONPartProvider)this.definition).parts.indexOf(partDef);
        APart currentPart = this.partsInSlots.get(ourSlotIndex);
        AEntityF_Multipart<?> aEntityF_Multipart = masterEntity = this instanceof APart ? ((APart)this).masterEntity : this;
        if (currentPart == null) {
            Point3D partAnchor = partDef.pos.copy().rotate(this.orientation).add(this.position);
            for (APart partToTransfer : this.world.getEntitiesExtendingType(APart.class)) {
                if (!((JSONPart)partToTransfer.definition).generic.canBePlacedOnGround || partToTransfer.masterEntity == masterEntity || !partToTransfer.position.isDistanceToCloserThan(partAnchor, 2.0) || !((AItemPart)partToTransfer.cachedItem).isPartValidForPackDef(partDef, this.subDefinition, true)) continue;
                partToTransfer.entityOn.removePart(partToTransfer, false, null);
                partToTransfer.linkToEntity(this, partDef);
                this.addPart(partToTransfer, false);
                InterfaceManager.packetInterface.sendToAllClients(new PacketPartChange_Transfer(partToTransfer, this, partDef));
                return;
            }
        } else if (((JSONPart)currentPart.definition).generic.canBePlacedOnGround) {
            Point3D partAnchor = new Point3D();
            AItemPart currentPartItem = (AItemPart)currentPart.cachedItem;
            for (AEntityF_Multipart<?> aEntityF_Multipart2 : this.world.getEntitiesExtendingType(AEntityF_Multipart.class)) {
                AEntityF_Multipart<?> otherMasterEntity;
                if (!aEntityF_Multipart2.encompassingBox.isPointInside(currentPart.position, PART_TRANSFER_GROWTH) || (otherMasterEntity = aEntityF_Multipart2 instanceof APart ? ((APart)aEntityF_Multipart2).masterEntity : aEntityF_Multipart2) == masterEntity || ((AJSONPartProvider)aEntityF_Multipart2.definition).parts == null) continue;
                for (JSONPartDefinition otherPartDef : ((AJSONPartProvider)aEntityF_Multipart2.definition).parts) {
                    partAnchor.set(otherPartDef.pos).rotate(aEntityF_Multipart2.orientation).add(aEntityF_Multipart2.position);
                    if (!partAnchor.isDistanceToCloserThan(currentPart.position, 2.0) || !currentPartItem.isPartValidForPackDef(otherPartDef, aEntityF_Multipart2.subDefinition, true)) continue;
                    this.removePart(currentPart, false, null);
                    currentPart.linkToEntity(aEntityF_Multipart2, otherPartDef);
                    aEntityF_Multipart2.addPart(currentPart, false);
                    InterfaceManager.packetInterface.sendToAllClients(new PacketPartChange_Transfer(currentPart, aEntityF_Multipart2, otherPartDef));
                    return;
                }
            }
            this.removePart(currentPart, false, null);
            currentPart.position.x = Math.floor(currentPart.position.x) + 0.5;
            currentPart.position.y = Math.floor(currentPart.position.y);
            currentPart.position.z = Math.floor(currentPart.position.z) + 0.5;
            currentPart.orientation.setToAngles(new Point3D(0.0, Math.round((currentPart.orientation.convertToAngles().y + 360.0) / 90.0) * 90L % 360L, 0.0));
            IWrapperNBT placerData = InterfaceManager.coreInterface.getNewNBTWrapper();
            EntityPlacedPart entityPlacedPart = new EntityPlacedPart(this.world, null, placerData);
            entityPlacedPart.addPartsPostAddition(null, placerData);
            entityPlacedPart.position.set(currentPart.position);
            entityPlacedPart.prevPosition.set(entityPlacedPart.position);
            entityPlacedPart.orientation.set(currentPart.orientation);
            entityPlacedPart.prevOrientation.set(entityPlacedPart.orientation);
            entityPlacedPart.world.spawnEntity(entityPlacedPart);
            this.partToPlace = currentPart;
            this.placedPart = entityPlacedPart;
            this.placeTimer = 20;
        }
    }

    @Override
    public double getMass() {
        double currentMass = super.getMass();
        for (APart part : this.parts) {
            currentMass += part.getMass();
        }
        return currentMass;
    }

    @Override
    public void attack(Damage damage) {
        APart hitPart;
        if (damage.box != null && (hitPart = this.getPartWithBox(damage.box)) != null && hitPart.isValid) {
            hitPart.attack(damage);
            return;
        }
        super.attack(damage);
    }

    public Collection<BoundingBoxHitResult> getHitBoxes(Point3D pathStart, Point3D pathEnd, BoundingBox movementBounds, boolean isBullet) {
        if (this.encompassingBox.intersects(movementBounds)) {
            TreeMap<Double, BoundingBoxHitResult> hitBoxes = new TreeMap<Double, BoundingBoxHitResult>();
            this.populateHitBoxesInSet(pathStart, pathEnd, hitBoxes, this.allDamageCollisionBoxes);
            if (isBullet) {
                this.populateHitBoxesInSet(pathStart, pathEnd, hitBoxes, this.allBulletCollisionBoxes);
            }
            if (!hitBoxes.isEmpty()) {
                return hitBoxes.values();
            }
        }
        return null;
    }

    private void populateHitBoxesInSet(Point3D pathStart, Point3D pathEnd, TreeMap<Double, BoundingBoxHitResult> hitBoxes, List<BoundingBox> boxesToCheck) {
        for (BoundingBox box : boxesToCheck) {
            BoundingBoxHitResult hitResult;
            if (this.allPartSlotBoxes.containsKey(box) || (hitResult = box.getIntersection(pathStart, pathEnd)) == null) continue;
            double boxDistance = hitResult.position.distanceTo(pathStart);
            boolean addBox = true;
            if (box.groupDef != null) {
                Iterator<Map.Entry<Double, BoundingBoxHitResult>> iterator = hitBoxes.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<Double, BoundingBoxHitResult> entry = iterator.next();
                    BoundingBoxHitResult otherHitEntry = entry.getValue();
                    if (otherHitEntry.box.groupDef != box.groupDef) continue;
                    if (box.definition.armorThickness != 0.0f) {
                        if (box.definition.armorThickness > otherHitEntry.box.definition.armorThickness) {
                            iterator.remove();
                            break;
                        }
                        addBox = false;
                        break;
                    }
                    if (entry.getKey() > boxDistance) {
                        iterator.remove();
                        break;
                    }
                    addBox = false;
                    break;
                }
            }
            if (!addBox) continue;
            hitBoxes.put(boxDistance, hitResult);
        }
    }

    public EntityBullet.HitType attackProjectile(Damage damage, EntityBullet bullet, Collection<BoundingBoxHitResult> hitBoxes) {
        for (BoundingBoxHitResult hitEntry : hitBoxes) {
            APart hitPart = this.getPartWithBox(hitEntry.box);
            AEntityF_Multipart hitEntity = hitPart != null ? hitPart : this;
            boolean hitOperationalHitbox = false;
            if (hitEntry.box.groupDef != null && hitEntry.box.groupDef.health != 0 && !damage.isWater) {
                String variableName = "collision_" + (((AJSONPartProvider)hitEntity.definition).collisionGroups.indexOf(hitEntry.box.groupDef) + 1) + "_damage";
                double currentDamage = hitEntity.getVariable(variableName);
                if (bullet != null) {
                    bullet.displayDebugMessage("HIT HEALTH BOX.  BOX CURRENT DAMAGE: " + currentDamage + " OF " + hitEntry.box.groupDef.health + "  ATTACKED FOR: " + damage.amount);
                }
                if (this.world.isClient()) {
                    InterfaceManager.packetInterface.sendToServer(new PacketEntityBulletHitCollision(hitEntity, hitEntry.box, damage.amount));
                } else {
                    hitEntity.damageCollisionBox(hitEntry.box, damage.amount);
                }
                hitOperationalHitbox = true;
            }
            if (hitEntry.box.definition != null && (hitEntry.box.definition.armorThickness != 0.0f || hitEntry.box.definition.heatArmorThickness != 0.0f)) {
                hitOperationalHitbox = true;
                if (bullet != null) {
                    double armorThickness = hitEntry.box.definition != null ? (double)(((JSONBullet)bullet.definition).bullet.isHeat && hitEntry.box.definition.heatArmorThickness != 0.0f ? hitEntry.box.definition.heatArmorThickness : hitEntry.box.definition.armorThickness) : 0.0;
                    double penetrationPotential = ((JSONBullet)bullet.definition).bullet.isHeat ? (double)((JSONBullet)bullet.definition).bullet.armorPenetration : (double)((JSONBullet)bullet.definition).bullet.armorPenetration * bullet.velocity / bullet.initialVelocity;
                    bullet.armorPenetrated += armorThickness;
                    bullet.displayDebugMessage("HIT ARMOR OF: " + (int)armorThickness);
                    if (bullet.armorPenetrated > penetrationPotential) {
                        if (this.world.isClient()) {
                            InterfaceManager.packetInterface.sendToServer(new PacketEntityBulletHitGeneric(bullet.gun, bullet.bulletNumber, hitEntry.position, hitEntry.side, EntityBullet.HitType.ARMOR));
                            bullet.waitingOnActionPacket = true;
                        } else {
                            EntityBullet.performGenericHitLogic(bullet.gun, bullet.bulletNumber, hitEntry.position, hitEntry.side, EntityBullet.HitType.ARMOR);
                        }
                        bullet.displayDebugMessage("HIT TOO MUCH ARMOR.  MAX PEN: " + (int)penetrationPotential);
                        return EntityBullet.HitType.ARMOR;
                    }
                } else {
                    return EntityBullet.HitType.ARMOR;
                }
            }
            if (hitOperationalHitbox) continue;
            if (bullet != null) {
                damage = new Damage(bullet.gun, hitEntry.box, damage.amount);
                boolean applyDamage = hitEntry.box.groupDef != null && (hitEntry.box.groupDef.health == 0 || damage.isWater) || hitPart != null;
                boolean removeAfterDamage = applyDamage && (hitPart == null || ((JSONPart)hitPart.definition).generic.forwardsDamageMultiplier > 0.0);
                bullet.displayDebugMessage("HIT ENTITY BOX FOR DAMAGE: " + (int)damage.amount + " DAMAGE WAS AT " + (int)hitEntity.damageAmount);
                if (this.world.isClient()) {
                    InterfaceManager.packetInterface.sendToServer(new PacketEntityBulletHitEntity(bullet.gun, hitEntity, damage));
                    if (!removeAfterDamage) continue;
                    InterfaceManager.packetInterface.sendToServer(new PacketEntityBulletHitGeneric(bullet.gun, bullet.bulletNumber, hitEntry.position, hitEntry.side, EntityBullet.HitType.VEHICLE));
                    bullet.waitingOnActionPacket = true;
                    return EntityBullet.HitType.VEHICLE;
                }
                EntityBullet.performEntityHitLogic(hitEntity, damage);
                if (!removeAfterDamage) continue;
                EntityBullet.performGenericHitLogic(bullet.gun, bullet.bulletNumber, hitEntry.position, hitEntry.side, EntityBullet.HitType.VEHICLE);
                return EntityBullet.HitType.VEHICLE;
            }
            damage = new Damage(damage.amount, damage.box, damage.damgeSource, damage.entityResponsible, damage.language);
            hitEntity.attack(damage);
            return EntityBullet.HitType.VEHICLE;
        }
        return null;
    }

    @Override
    public void remove() {
        super.remove();
        for (APart part : this.parts) {
            part.remove();
        }
    }

    @Override
    public IWrapperItemStack getStack() {
        IWrapperItemStack stack = super.getStack();
        IWrapperNBT stackData = this.save(InterfaceManager.coreInterface.getNewNBTWrapper());
        stackData.deleteAllUUIDTags();
        IWrapperNBT freshData = InterfaceManager.coreInterface.getNewNBTWrapper();
        freshData.setPackItem(this.definition, this.subDefinition.subName);
        freshData.getAllNames().forEach(name -> stackData.deleteEntry((String)name));
        if (!stackData.getAllNames().isEmpty()) {
            stack.setData(stackData);
        }
        return stack;
    }

    @Override
    public void updateText(LinkedHashMap<String, String> textLines) {
        super.updateText(textLines);
        this.parts.forEach(part -> part.updateText(textLines));
    }

    @Override
    public Collection<BoundingBox> getCollisionBoxes() {
        return this.allEntityCollisionBoxes;
    }

    @Override
    public Collection<BoundingBox> getDamageBoxes() {
        return this.allDamageCollisionBoxes;
    }

    @Override
    public boolean canCollideWith(AEntityB_Existing entityToCollide) {
        return !(entityToCollide instanceof APart);
    }

    @Override
    public void doPostUpdateLogic() {
        this.world.beginProfiling("PartUpdates_" + this.parts.size(), true);
        Iterator<APart> iterator = this.parts.iterator();
        while (iterator.hasNext()) {
            APart part = iterator.next();
            part.update();
            if (!part.isValid) {
                this.removePart(part, true, iterator);
                continue;
            }
            if (part.forceCollisionUpdateThisTick) {
                this.forceCollisionUpdateThisTick = true;
            }
            part.doPostUpdateLogic();
        }
        this.world.endProfiling();
        super.doPostUpdateLogic();
    }

    @Override
    public void damageCollisionBox(BoundingBox box, double damageAmount) {
        APart part = this.getPartWithBox(box);
        if (part != null) {
            part.damageCollisionBox(box, damageAmount);
        } else {
            super.damageCollisionBox(box, damageAmount);
        }
    }

    @Override
    protected void updateCollisionBoxes() {
        super.updateCollisionBoxes();
        if (this.world.isClient()) {
            this.interactionBoxes.addAll(this.activePartSlotBoxes.keySet());
            this.damageCollisionBoxes.addAll(this.activePartSlotBoxes.keySet());
        }
    }

    @Override
    public double getRawVariableValue(String variable, float partialTicks) {
        int partNumber = AEntityF_Multipart.getVariableNumber(variable);
        if (partNumber != -1) {
            return this.getSpecificPartAnimation(variable, partNumber, partialTicks);
        }
        return super.getRawVariableValue(variable, partialTicks);
    }

    @Override
    public void toggleVariable(String variable) {
        int partNumber = AEntityF_Multipart.getVariableNumber(variable);
        if (partNumber != -1) {
            APart foundPart = this.getSpecificPart(variable, partNumber);
            if (foundPart != null) {
                variable = variable.substring(0, variable.lastIndexOf("_"));
                foundPart.toggleVariable(variable);
            }
        } else {
            super.toggleVariable(variable);
        }
    }

    @Override
    public void setVariable(String variable, double value) {
        int partNumber = AEntityF_Multipart.getVariableNumber(variable);
        if (partNumber != -1) {
            APart foundPart = this.getSpecificPart(variable, partNumber);
            if (foundPart != null) {
                foundPart.setVariable(variable.substring(0, variable.lastIndexOf("_")), value);
            }
        } else {
            super.setVariable(variable, value);
        }
    }

    public static int getVariableNumber(String variable) {
        if (variable.matches("^.*_\\d+$")) {
            return Integer.parseInt(variable.substring(variable.lastIndexOf(95) + 1)) - 1;
        }
        return -1;
    }

    public boolean canBeClicked() {
        return true;
    }

    public void addPartsPostAddition(IWrapperPlayer placingPlayer, IWrapperNBT data) {
        if (((AJSONPartProvider)this.definition).parts != null) {
            for (int i = 0; i < ((AJSONPartProvider)this.definition).parts.size(); ++i) {
                if (data != null) {
                    try {
                        IWrapperNBT partData = data.getData("part_" + i);
                        if (partData == null) continue;
                        this.addPartFromStack(((AItemBase)PackParser.getItem(partData.getString("packID"), partData.getString("systemName"), partData.getString("subName"))).getNewStack(partData), placingPlayer, i, true, false);
                    }
                    catch (Exception e) {
                        InterfaceManager.coreInterface.logError("Could not load part from NBT.  Did you un-install a pack?");
                        e.printStackTrace();
                    }
                    continue;
                }
                JSONPartDefinition partDef = ((AJSONPartProvider)this.definition).parts.get(i);
                if (partDef.conditionalDefaultParts != null) {
                    for (Map.Entry<String, String> conditionalDef : partDef.conditionalDefaultParts.entrySet()) {
                        if (!(this.getCleanRawVariableValue(conditionalDef.getKey(), 0.0f) > 0.0)) continue;
                        this.addDefaultPart(conditionalDef.getValue(), i, placingPlayer, (AJSONPartProvider)this.definition);
                        break;
                    }
                }
                if (partDef.defaultPart == null) continue;
                this.addDefaultPart(partDef.defaultPart, i, placingPlayer, (AJSONPartProvider)this.definition);
            }
        }
        this.recalculatePartSlots();
    }

    public APart addPartFromStack(IWrapperItemStack stack, IWrapperPlayer playerAdding, int slotIndex, boolean bypassSlotChecks, boolean alignTone) {
        JSONPartDefinition newPartDef = ((AJSONPartProvider)this.definition).parts.get(slotIndex);
        AItemPart partItem = (AItemPart)stack.getItem();
        if (this.partsInSlots.get(slotIndex) == null && (bypassSlotChecks || partItem.isPartValidForPackDef(newPartDef, this.subDefinition, !newPartDef.bypassSlotMinMax))) {
            IWrapperNBT partData = stack.getData();
            APart partToAdd = partItem.createPart(this, playerAdding, newPartDef, partData);
            if (alignTone) {
                partToAdd.updateTone(false);
            }
            this.addPart(partToAdd, true);
            partToAdd.addPartsPostAddition(playerAdding, partData);
            return partToAdd;
        }
        return null;
    }

    public void addPart(APart part, boolean sendPacket) {
        if (part instanceof PartSeat) {
            this.parts.add(part);
        } else {
            this.parts.add(0, part);
        }
        if (!part.isFake()) {
            this.partsInSlots.set(part.placementSlot, part);
            this.recalculatePartSlots();
            if (sendPacket && !this.world.isClient()) {
                InterfaceManager.packetInterface.sendToAllClients(new PacketPartChange_Add(this, part));
            }
        }
        if (part.ticksExisted == 0L) {
            this.world.addEntity(part);
        }
        part.masterEntity.updateAllpartList();
        part.masterEntity.updatePartList();
    }

    public void removePart(APart part, boolean removeFromWorld, Iterator<APart> iterator) {
        if (this.parts.contains(part)) {
            if (removeFromWorld) {
                part.remove();
            }
            if (iterator != null) {
                iterator.remove();
            } else {
                this.parts.remove(part);
            }
            if (!part.isFake()) {
                this.partsInSlots.set(((AJSONPartProvider)this.definition).parts.indexOf(part.placementDefinition), null);
                this.recalculatePartSlots();
            }
            if (!this.world.isClient()) {
                InterfaceManager.packetInterface.sendToAllClients(new PacketPartChange_Remove(part, removeFromWorld));
            }
        }
        part.masterEntity.updateAllpartList();
        part.masterEntity.updatePartList();
    }

    protected void updateAllpartList() {
        this.allParts.clear();
        this.parts.forEach(part -> {
            part.updateAllpartList();
            this.allParts.add((APart)part);
            this.allParts.addAll(part.allParts);
        });
    }

    public void updatePartList() {
        this.cameras.clear();
        this.cameraEntities.clear();
        this.parts.forEach(APart::updatePartList);
    }

    public APart getPartWithBox(BoundingBox box) {
        for (APart part : this.parts) {
            if (part.allDamageCollisionBoxes.contains(box)) {
                if (part.damageCollisionBoxes.contains(box)) {
                    return part;
                }
                return part.getPartWithBox(box);
            }
            if (!part.allBulletCollisionBoxes.contains(box)) continue;
            if (part.bulletCollisionBoxes.contains(box)) {
                return part;
            }
            return part.getPartWithBox(box);
        }
        return null;
    }

    public void addDefaultPart(String partName, int partSlot, IWrapperPlayer playerAdding, AJSONPartProvider providingDef) {
        if (!partName.isEmpty()) {
            try {
                String partPackID = partName.substring(0, partName.indexOf(58));
                String partSystemName = partName.substring(partName.indexOf(58) + 1);
                try {
                    this.addPartFromStack(((AItemBase)PackParser.getItem(partPackID, partSystemName)).getNewStack(null), playerAdding, partSlot, false, true);
                }
                catch (NullPointerException e) {
                    playerAdding.sendPacket(new PacketPlayerChatMessage(playerAdding, LanguageSystem.SYSTEM_DEBUG, "Attempted to add defaultPart: " + partPackID + ":" + partSystemName + " to: " + providingDef.packID + ":" + providingDef.systemName + " but that part doesn't exist in the pack item registry."));
                }
            }
            catch (IndexOutOfBoundsException e) {
                playerAdding.sendPacket(new PacketPlayerChatMessage(playerAdding, LanguageSystem.SYSTEM_DEBUG, "Could not parse defaultPart definition: " + partName + ".  Format should be \"packId:partName\""));
            }
        }
    }

    private void recalculatePartSlots() {
        this.partSlotBoxes.clear();
        this.activePartSlotBoxes.clear();
        for (int i = 0; i < this.partsInSlots.size(); ++i) {
            if (this.partsInSlots.get(i) != null) continue;
            JSONPartDefinition partDef = ((AJSONPartProvider)this.definition).parts.get(i);
            BoundingBox newSlotBox = new BoundingBox(partDef.pos, partDef.pos.copy().rotate(this.orientation).add(this.position), 0.375, 1.125, 0.375, false);
            this.partSlotBoxes.put(newSlotBox, partDef);
        }
        this.forceCollisionUpdateThisTick = true;
        if (this instanceof APart) {
            ((APart)this).masterEntity.forceCollisionUpdateThisTick = true;
        }
    }

    @Override
    protected void updateEncompassingBox() {
        super.updateEncompassingBox();
        this.allEntityCollisionBoxes.clear();
        this.allEntityCollisionBoxes.addAll(this.entityCollisionBoxes);
        this.allBlockCollisionBoxes.clear();
        this.allBlockCollisionBoxes.addAll(this.blockCollisionBoxes);
        this.allInteractionBoxes.clear();
        this.allInteractionBoxes.addAll(this.interactionBoxes);
        this.allBulletCollisionBoxes.clear();
        this.allBulletCollisionBoxes.addAll(this.bulletCollisionBoxes);
        this.allDamageCollisionBoxes.clear();
        this.allDamageCollisionBoxes.addAll(this.damageCollisionBoxes);
        this.allPartSlotBoxes.clear();
        this.allPartSlotBoxes.putAll(this.partSlotBoxes);
        for (APart part : this.parts) {
            this.allEntityCollisionBoxes.addAll(part.allEntityCollisionBoxes);
            this.allBlockCollisionBoxes.addAll(part.allBlockCollisionBoxes);
            this.allBulletCollisionBoxes.addAll(part.allBulletCollisionBoxes);
            this.allInteractionBoxes.addAll(part.allInteractionBoxes);
            this.allDamageCollisionBoxes.addAll(part.allDamageCollisionBoxes);
            this.allPartSlotBoxes.putAll(part.allPartSlotBoxes);
        }
        if (!this.parts.isEmpty()) {
            for (APart part : this.parts) {
                if (part.isFake()) continue;
                this.encompassingBox.widthRadius = (float)Math.max(this.encompassingBox.widthRadius, Math.abs(part.encompassingBox.globalCenter.x - this.position.x) + part.encompassingBox.widthRadius);
                this.encompassingBox.heightRadius = (float)Math.max(this.encompassingBox.heightRadius, Math.abs(part.encompassingBox.globalCenter.y - this.position.y) + part.encompassingBox.heightRadius);
                this.encompassingBox.depthRadius = (float)Math.max(this.encompassingBox.depthRadius, Math.abs(part.encompassingBox.globalCenter.z - this.position.z) + part.encompassingBox.depthRadius);
            }
        }
        if (this.world.isClient() && !this.activePartSlotBoxes.isEmpty()) {
            for (BoundingBox box : this.activePartSlotBoxes.keySet()) {
                this.encompassingBox.widthRadius = (float)Math.max(this.encompassingBox.widthRadius, Math.abs(box.globalCenter.x - this.position.x) + box.widthRadius);
                this.encompassingBox.heightRadius = (float)Math.max(this.encompassingBox.heightRadius, Math.abs(box.globalCenter.y - this.position.y) + box.heightRadius);
                this.encompassingBox.depthRadius = (float)Math.max(this.encompassingBox.depthRadius, Math.abs(box.globalCenter.z - this.position.z) + box.depthRadius);
            }
        }
        this.encompassingBox.updateToEntity(this, null);
    }

    public APart getSpecificPart(String variable, int partNumber) {
        String partType = variable.substring(0, variable.indexOf("_"));
        if (partType.equals("part")) {
            return partNumber < this.partsInSlots.size() ? this.partsInSlots.get(partNumber) : null;
        }
        if (((AJSONPartProvider)this.definition).parts != null) {
            block0: for (int i = 0; i < ((AJSONPartProvider)this.definition).parts.size(); ++i) {
                JSONPartDefinition partDef = ((AJSONPartProvider)this.definition).parts.get(i);
                for (String defPartType : partDef.types) {
                    if (!defPartType.startsWith(partType)) continue;
                    if (partNumber == 0) {
                        return this.partsInSlots.get(i);
                    }
                    --partNumber;
                    continue block0;
                }
            }
        }
        return null;
    }

    public double getSpecificPartAnimation(String variable, int partNumber, float partialTicks) {
        APart foundPart = this.getSpecificPart(variable, partNumber);
        if (foundPart != null) {
            return foundPart.getRawVariableValue(variable.substring(0, variable.lastIndexOf("_")), partialTicks);
        }
        return 0.0;
    }

    @Override
    public void renderBoundingBoxes(TransformationMatrix transform) {
        for (BoundingBox box : this.interactionBoxes) {
            if (!this.allInteractionBoxes.contains(box)) continue;
            if (this.boundingBox == box) {
                box.renderWireframe(this, transform, null, ColorRGB.GRAY);
                continue;
            }
            box.renderWireframe(this, transform, null, null);
        }
        for (BoundingBox box : this.bulletCollisionBoxes) {
            box.renderWireframe(this, transform, null, null);
        }
        if (System.currentTimeMillis() % 1000L > 500L) {
            this.encompassingBox.renderWireframe(this, transform, null, ColorRGB.WHITE);
        }
    }

    @Override
    protected void renderHolographicBoxes(TransformationMatrix transform) {
        if (!this.activePartSlotBoxes.isEmpty()) {
            this.world.beginProfiling("PartHoloboxes", true);
            IWrapperPlayer player = InterfaceManager.clientInterface.getClientPlayer();
            AItemBase heldItem = player.getHeldItem();
            AItemPart heldPart = heldItem instanceof AItemPart ? (AItemPart)heldItem : null;
            boolean holdingScanner = player.isHoldingItemType(JSONItem.ItemComponentType.SCANNER);
            if (heldPart != null || holdingScanner) {
                if (holdingScanner) {
                    for (Map.Entry<BoundingBox, JSONPartDefinition> slotEntry : this.activePartSlotBoxes.entrySet()) {
                        BoundingBox box = slotEntry.getKey();
                        JSONPartDefinition slotDef = slotEntry.getValue();
                        Point3D boxCenterDelta = box.globalCenter.copy().subtract(this.position);
                        boolean isImportant = false;
                        for (String slotType : slotDef.types) {
                            if (!slotType.startsWith("ground") && !slotType.startsWith("engine") && !slotType.startsWith("propeller") && !slotType.startsWith("seat")) continue;
                            isImportant = true;
                            break;
                        }
                        box.renderHolographic(transform, boxCenterDelta, isImportant ? ColorRGB.YELLOW : ColorRGB.DARK_GRAY);
                    }
                } else {
                    for (Map.Entry<BoundingBox, JSONPartDefinition> partSlotEntry : this.activePartSlotBoxes.entrySet()) {
                        boolean isHoldingCorrectTypePart = false;
                        boolean isHoldingCorrectParamPart = false;
                        if (heldPart.isPartValidForPackDef(partSlotEntry.getValue(), this.subDefinition, false)) {
                            isHoldingCorrectTypePart = true;
                            if (heldPart.isPartValidForPackDef(partSlotEntry.getValue(), this.subDefinition, true)) {
                                isHoldingCorrectParamPart = true;
                            }
                        }
                        if (!isHoldingCorrectTypePart) continue;
                        BoundingBox box = partSlotEntry.getKey();
                        Point3D boxCenterDelta = box.globalCenter.copy().subtract(this.position);
                        box.renderHolographic(transform, boxCenterDelta, isHoldingCorrectParamPart ? ColorRGB.GREEN : ColorRGB.RED);
                    }
                }
            }
            this.world.endProfiling();
        }
    }

    public IWrapperEntity getController() {
        for (APart part : this.parts) {
            if (part.rider == null || !part.placementDefinition.isController) continue;
            return part.rider;
        }
        return null;
    }

    @Override
    public IWrapperNBT save(IWrapperNBT data) {
        super.save(data);
        data.setBoolean("spawnedDefaultParts", true);
        for (APart part : this.parts) {
            if (!part.isValid || part.isFake()) continue;
            IWrapperNBT partData = part.save(InterfaceManager.coreInterface.getNewNBTWrapper());
            data.setData("part_" + part.placementSlot, partData);
        }
        return data;
    }
}

