/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.blocks.tileentities.instances;

import java.util.HashMap;
import java.util.Map;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.blocks.components.ABlockBase;
import minecrafttransportsimulator.blocks.instances.BlockPole;
import minecrafttransportsimulator.blocks.tileentities.components.ATileEntityBase;
import minecrafttransportsimulator.blocks.tileentities.components.ATileEntityPole_Component;
import minecrafttransportsimulator.items.components.AItemBase;
import minecrafttransportsimulator.items.instances.ItemPoleComponent;
import minecrafttransportsimulator.jsondefs.JSONItem;
import minecrafttransportsimulator.jsondefs.JSONPoleComponent;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperItemStack;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.instances.PacketEntityGUIRequest;
import minecrafttransportsimulator.packets.instances.PacketTileEntityPoleChange;
import minecrafttransportsimulator.packets.instances.PacketTileEntityPoleCollisionUpdate;
import minecrafttransportsimulator.systems.ConfigSystem;

public class TileEntityPole
extends ATileEntityBase<JSONPoleComponent> {
    public final Map<ABlockBase.Axis, ATileEntityPole_Component> components = new HashMap<ABlockBase.Axis, ATileEntityPole_Component>();
    private float maxTotalLightLevel;

    public TileEntityPole(AWrapperWorld world, Point3D position, IWrapperPlayer placingPlayer, ItemPoleComponent item, IWrapperNBT data) {
        super(world, position, placingPlayer, item, data);
        if (data != null) {
            for (ABlockBase.Axis axis : ABlockBase.Axis.values()) {
                IWrapperNBT componentData = data.getData(axis.name());
                if (componentData == null) continue;
                ATileEntityPole_Component newComponent = ItemPoleComponent.PoleComponentType.createComponent(this, placingPlayer, axis, (ItemPoleComponent)componentData.getPackItem(), componentData);
                this.changeComponent(axis, newComponent);
            }
        } else {
            this.changeComponent(ABlockBase.Axis.NONE, ItemPoleComponent.PoleComponentType.createComponent(this, placingPlayer, ABlockBase.Axis.NONE, (ItemPoleComponent)this.cachedItem, data));
        }
    }

    @Override
    public void update() {
        super.update();
        this.maxTotalLightLevel = 0.0f;
        for (ATileEntityPole_Component component : this.components.values()) {
            component.update();
            this.maxTotalLightLevel = Math.max(this.maxTotalLightLevel, component.getLightProvided());
        }
        if (this.ticksExisted == 1L) {
            this.updateCollision(false);
            for (ABlockBase.Axis axis : ABlockBase.Axis.values()) {
                Object tile;
                if (axis.equals((Object)ABlockBase.Axis.NONE) || !((tile = this.world.getTileEntity(axis.getOffsetPoint(this.position))) instanceof TileEntityPole)) continue;
                ((TileEntityPole)tile).updateCollision(false);
            }
        }
    }

    @Override
    public void remove() {
        super.remove();
        for (ATileEntityPole_Component component : this.components.values()) {
            component.remove();
        }
    }

    @Override
    public void destroy(BoundingBox box) {
        for (ABlockBase.Axis axis : ABlockBase.Axis.values()) {
            ATileEntityPole_Component component;
            if (axis == ABlockBase.Axis.NONE || (component = this.components.get((Object)axis)) == null) continue;
            this.world.spawnItemStack(component.getStack(), this.position);
        }
        super.destroy(box);
    }

    @Override
    public boolean interact(IWrapperPlayer player) {
        ABlockBase.Axis axis = ABlockBase.Axis.getFromRotation(player.getYaw(), ((JSONPoleComponent)this.definition).pole.allowsDiagonals).getOpposite();
        IWrapperItemStack heldStack = player.getHeldStack();
        AItemBase heldItem = heldStack.getItem();
        ATileEntityPole_Component clickedComponent = this.components.get((Object)axis);
        if (!((Boolean)ConfigSystem.settings.general.opSignEditingOnly.value).booleanValue() || player.isOP()) {
            if (player.isHoldingItemType(JSONItem.ItemComponentType.WRENCH) && !player.isSneaking()) {
                if (this.components.containsKey((Object)axis)) {
                    ATileEntityPole_Component component = this.components.get((Object)axis);
                    if (player.isCreative() || player.getInventory().addStack(component.getStack())) {
                        this.changeComponent(axis, null);
                        InterfaceManager.packetInterface.sendToAllClients(new PacketTileEntityPoleChange(this, player, axis, null));
                    }
                    return true;
                }
            } else {
                if (player.isHoldingItemType(JSONItem.ItemComponentType.WRENCH) && player.isSneaking() && ((JSONPoleComponent)clickedComponent.definition).rendering.textObjects != null) {
                    player.sendPacket(new PacketEntityGUIRequest(clickedComponent, player, PacketEntityGUIRequest.EntityGUIType.TEXT_EDITOR));
                    return true;
                }
                if (heldItem instanceof ItemPoleComponent && ((JSONPoleComponent)((ItemPoleComponent)heldItem).definition).pole.type != ItemPoleComponent.PoleComponentType.CORE && !this.components.containsKey((Object)axis)) {
                    ATileEntityPole_Component newComponent = ItemPoleComponent.PoleComponentType.createComponent(this, player, axis, (ItemPoleComponent)heldItem, heldStack.getData());
                    this.changeComponent(axis, newComponent);
                    if (!player.isCreative()) {
                        player.getInventory().removeStack(player.getHeldStack(), 1, false);
                    }
                    InterfaceManager.packetInterface.sendToAllClients(new PacketTileEntityPoleChange(this, player, axis, newComponent.save(InterfaceManager.coreInterface.getNewNBTWrapper())));
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public int getRotationIncrement() {
        return 360;
    }

    @Override
    public float getLightProvided() {
        return this.maxTotalLightLevel;
    }

    public void changeComponent(ABlockBase.Axis newAxis, ATileEntityPole_Component newComponent) {
        if (newComponent != null) {
            this.components.put(newAxis, newComponent);
            newComponent.orientation.set(this.orientation);
            if (newAxis.equals((Object)ABlockBase.Axis.NONE)) {
                newComponent.position.set(this.position);
            } else {
                newComponent.orientation.multiply(newAxis.yRotation);
                newComponent.position.set(0.0, 0.0, (double)((JSONPoleComponent)this.definition).pole.radius + 0.001).rotate(newComponent.orientation).add(this.position);
            }
            this.world.addEntity(newComponent);
        } else if (this.components.containsKey((Object)newAxis)) {
            this.components.remove((Object)newAxis).remove();
        }
    }

    @Override
    public void onNeighborChanged(Point3D otherPosition) {
        this.updateCollision(true);
    }

    public void updateCollision(boolean sendToClient) {
        this.boundingBox.widthRadius = ((JSONPoleComponent)this.definition).pole.radius;
        this.boundingBox.heightRadius = ((JSONPoleComponent)this.definition).pole.radius;
        this.boundingBox.depthRadius = ((JSONPoleComponent)this.definition).pole.radius;
        this.boundingBox.globalCenter.set(this.position);
        this.boundingBox.globalCenter.add(0.0, 0.5, 0.0);
        block8: for (ABlockBase.Axis axis : ABlockBase.Axis.values()) {
            if (!axis.blockBased || !(this.world.getBlock(axis.getOffsetPoint(this.position)) instanceof BlockPole) && !this.world.isBlockSolid(axis.getOffsetPoint(this.position), axis.getOpposite()) && !this.components.containsKey((Object)axis)) continue;
            switch (axis) {
                case NORTH: {
                    if (this.boundingBox.depthRadius == (double)((JSONPoleComponent)this.definition).pole.radius) {
                        this.boundingBox.depthRadius = (0.5 + (double)((JSONPoleComponent)this.definition).pole.radius) / 2.0;
                        this.boundingBox.globalCenter.z = this.position.z - (0.5 - (double)((JSONPoleComponent)this.definition).pole.radius) / 2.0;
                        continue block8;
                    }
                    this.boundingBox.depthRadius = 0.5;
                    this.boundingBox.globalCenter.z = this.position.z;
                    continue block8;
                }
                case SOUTH: {
                    if (this.boundingBox.depthRadius == (double)((JSONPoleComponent)this.definition).pole.radius) {
                        this.boundingBox.depthRadius = (0.5 + (double)((JSONPoleComponent)this.definition).pole.radius) / 2.0;
                        this.boundingBox.globalCenter.z = this.position.z + (0.5 - (double)((JSONPoleComponent)this.definition).pole.radius) / 2.0;
                        continue block8;
                    }
                    this.boundingBox.depthRadius = 0.5;
                    this.boundingBox.globalCenter.z = this.position.z;
                    continue block8;
                }
                case EAST: {
                    if (this.boundingBox.widthRadius == (double)((JSONPoleComponent)this.definition).pole.radius) {
                        this.boundingBox.widthRadius = (0.5 + (double)((JSONPoleComponent)this.definition).pole.radius) / 2.0;
                        this.boundingBox.globalCenter.x = this.position.x + (0.5 - (double)((JSONPoleComponent)this.definition).pole.radius) / 2.0;
                        continue block8;
                    }
                    this.boundingBox.widthRadius = 0.5;
                    this.boundingBox.globalCenter.x = this.position.x;
                    continue block8;
                }
                case WEST: {
                    if (this.boundingBox.widthRadius == (double)((JSONPoleComponent)this.definition).pole.radius) {
                        this.boundingBox.widthRadius = (0.5 + (double)((JSONPoleComponent)this.definition).pole.radius) / 2.0;
                        this.boundingBox.globalCenter.x = this.position.x - (0.5 - (double)((JSONPoleComponent)this.definition).pole.radius) / 2.0;
                        continue block8;
                    }
                    this.boundingBox.widthRadius = 0.5;
                    this.boundingBox.globalCenter.x = this.position.x;
                    continue block8;
                }
                case UP: {
                    if (this.boundingBox.heightRadius == (double)((JSONPoleComponent)this.definition).pole.radius) {
                        this.boundingBox.heightRadius = (0.5 + (double)((JSONPoleComponent)this.definition).pole.radius) / 2.0;
                        this.boundingBox.globalCenter.y = this.position.y + 1.0 - this.boundingBox.heightRadius;
                        continue block8;
                    }
                    this.boundingBox.heightRadius = 0.5;
                    this.boundingBox.globalCenter.y = this.position.y + 0.5;
                    continue block8;
                }
                case DOWN: {
                    if (this.boundingBox.heightRadius == (double)((JSONPoleComponent)this.definition).pole.radius) {
                        this.boundingBox.heightRadius = (0.5 + (double)((JSONPoleComponent)this.definition).pole.radius) / 2.0;
                        this.boundingBox.globalCenter.y = this.position.y + this.boundingBox.heightRadius;
                        continue block8;
                    }
                    this.boundingBox.heightRadius = 0.5;
                    this.boundingBox.globalCenter.y = this.position.y + 0.5;
                    continue block8;
                }
            }
        }
        if (sendToClient && !this.world.isClient()) {
            InterfaceManager.packetInterface.sendToAllClients(new PacketTileEntityPoleCollisionUpdate(this));
        }
    }

    @Override
    public boolean disableRendering() {
        return true;
    }

    @Override
    public IWrapperNBT save(IWrapperNBT data) {
        super.save(data);
        for (Map.Entry<ABlockBase.Axis, ATileEntityPole_Component> connectedObjectEntry : this.components.entrySet()) {
            data.setData(connectedObjectEntry.getKey().name(), connectedObjectEntry.getValue().save(InterfaceManager.coreInterface.getNewNBTWrapper()));
        }
        return data;
    }
}

