/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.baseclasses;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.BoundingBoxHitResult;
import minecrafttransportsimulator.baseclasses.EntityInteractResult;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.entities.components.AEntityA_Base;
import minecrafttransportsimulator.entities.components.AEntityC_Renderable;
import minecrafttransportsimulator.entities.components.AEntityD_Definable;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.entities.components.AEntityG_Towable;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.EntityBullet;
import minecrafttransportsimulator.entities.instances.EntityPlacedPart;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.entities.instances.PartGun;

public class EntityManager {
    public final ConcurrentLinkedQueue<AEntityA_Base> allEntities = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<AEntityA_Base> allTickableEntities = new ConcurrentLinkedQueue();
    public final ConcurrentLinkedQueue<AEntityC_Renderable> renderableEntities = new ConcurrentLinkedQueue();
    private final ConcurrentHashMap<Class<? extends AEntityA_Base>, ConcurrentLinkedQueue<? extends AEntityA_Base>> entitiesByClass = new ConcurrentHashMap();
    private final ConcurrentHashMap<UUID, AEntityA_Base> trackedEntityMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<UUID, PartGun> gunMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<UUID, Map<Integer, EntityBullet>> bulletMap = new ConcurrentHashMap();

    public <EntityType extends AEntityA_Base> void addEntity(EntityType entity) {
        ConcurrentLinkedQueue<AEntityA_Base> classList;
        this.allEntities.add(entity);
        if (entity.shouldAutomaticallyUpdate()) {
            this.allTickableEntities.add(entity);
        }
        if (entity instanceof AEntityC_Renderable) {
            this.renderableEntities.add((AEntityC_Renderable)entity);
        }
        if (entity instanceof PartGun) {
            this.gunMap.put(entity.uniqueUUID, (PartGun)entity);
            this.bulletMap.put(entity.uniqueUUID, new HashMap());
        }
        if (entity instanceof EntityBullet) {
            EntityBullet bullet = (EntityBullet)entity;
            this.bulletMap.get(bullet.gun.uniqueUUID).put(bullet.bulletNumber, bullet);
        }
        if ((classList = this.entitiesByClass.get(entity.getClass())) == null) {
            classList = new ConcurrentLinkedQueue();
            this.entitiesByClass.put(entity.getClass(), classList);
        }
        classList.add(entity);
        if (entity.shouldSync()) {
            this.trackedEntityMap.put(entity.uniqueUUID, entity);
        }
    }

    public <EntityType extends AEntityA_Base> EntityType getEntity(UUID uniqueUUID) {
        return (EntityType)this.trackedEntityMap.get(uniqueUUID);
    }

    public PartGun getBulletGun(UUID gunID) {
        return this.gunMap.get(gunID);
    }

    public EntityBullet getBullet(UUID gunID, int bulletNumber) {
        return this.bulletMap.get(gunID).get(bulletNumber);
    }

    public <EntityType extends AEntityA_Base> ConcurrentLinkedQueue<EntityType> getEntitiesOfType(Class<EntityType> entityClass) {
        ConcurrentLinkedQueue<AEntityA_Base> classListing = this.entitiesByClass.get(entityClass);
        if (classListing == null) {
            classListing = new ConcurrentLinkedQueue();
            this.entitiesByClass.put(entityClass, classListing);
        }
        return classListing;
    }

    public <EntityType extends AEntityA_Base> List<EntityType> getEntitiesExtendingType(Class<EntityType> entityClass) {
        ArrayList list = new ArrayList();
        this.allEntities.forEach(entity -> {
            if (entityClass.isAssignableFrom(entity.getClass())) {
                list.add(entity);
            }
        });
        return list;
    }

    public void tickAll() {
        for (AEntityA_Base entity : this.allTickableEntities) {
            if (entity instanceof AEntityG_Towable && ((AEntityG_Towable)entity).blockMainUpdateCall()) continue;
            entity.world.beginProfiling("MTSEntity_" + entity.uniqueUUID, true);
            entity.update();
            if (entity instanceof AEntityD_Definable) {
                ((AEntityD_Definable)entity).doPostUpdateLogic();
            }
            entity.world.endProfiling();
        }
    }

    public EntityInteractResult getMultipartEntityIntersect(Point3D startPoint, Point3D endPoint) {
        EntityInteractResult closestResult = null;
        BoundingBox vectorBounds = new BoundingBox(startPoint, endPoint);
        ArrayList<AEntityF_Multipart> multiparts = new ArrayList<AEntityF_Multipart>();
        multiparts.addAll(this.getEntitiesOfType(EntityVehicleF_Physics.class));
        multiparts.addAll(this.getEntitiesOfType(EntityPlacedPart.class));
        for (AEntityF_Multipart multipart : multiparts) {
            if (!multipart.encompassingBox.intersects(vectorBounds)) continue;
            for (BoundingBox box : multipart.allInteractionBoxes) {
                BoundingBoxHitResult intersectionPoint;
                if (!box.intersects(vectorBounds) || (intersectionPoint = box.getIntersection(startPoint, endPoint)) == null || closestResult != null && !startPoint.isFirstCloserThanSecond(intersectionPoint.position, closestResult.position)) continue;
                APart part = multipart.getPartWithBox(box);
                closestResult = new EntityInteractResult(part != null ? part : multipart, box, intersectionPoint.position);
            }
        }
        return closestResult;
    }

    public void removeEntity(AEntityA_Base entity) {
        this.allEntities.remove(entity);
        this.allTickableEntities.remove(entity);
        if (entity instanceof AEntityC_Renderable) {
            this.renderableEntities.remove(entity);
        }
        this.entitiesByClass.get(entity.getClass()).remove(entity);
        if (entity.shouldSync()) {
            this.trackedEntityMap.remove(entity.uniqueUUID);
        }
        if (entity instanceof EntityBullet) {
            EntityBullet bullet = (EntityBullet)entity;
            this.bulletMap.get(bullet.gun.uniqueUUID).remove(bullet.bulletNumber);
        }
    }
}

