/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.vehicle.jimphysics;

import com.paneedah.weaponlib.vehicle.EntityVehicle;
import com.paneedah.weaponlib.vehicle.jimphysics.MechanicalClutch;
import com.paneedah.weaponlib.vehicle.jimphysics.VehiclePhysUtil;
import java.util.ArrayList;

public class Transmission {
    public float differentialRatio = 0.0f;
    public float reverseGearRatio = 0.0f;
    public int currentGear = 0;
    public int highestGear = 0;
    public int upshiftRPM = 0;
    public int downshiftRPM = 0;
    public int eUShift = 0;
    public int eDShift = 0;
    public boolean isReverseGear = false;
    public boolean isOnEcoShift = false;
    public boolean declutched = false;
    public float slippage = 1.0f;
    public ArrayList<Gear> vehicleGears = new ArrayList();
    public int startGear = 1;
    public int targetGear = 1;
    public boolean runningAShift = false;
    public int maxShiftTime = 75;
    public int shiftTimer = 0;
    public boolean isNeutral = true;
    public MechanicalClutch clutch = new MechanicalClutch(0.4);
    boolean markedForUpshift = false;
    boolean markedForDownshift = false;

    public Transmission(float diffRatio, float rRatio, int uRPM, int dRPM) {
        this.differentialRatio = diffRatio;
        this.upshiftRPM = uRPM;
        this.reverseGearRatio = rRatio;
        this.downshiftRPM = dRPM;
    }

    public boolean inNeutral() {
        return this.isNeutral;
    }

    public void setNeutral(boolean v) {
        this.isNeutral = v;
    }

    public MechanicalClutch getClutch() {
        return this.clutch;
    }

    public int getCurrentGear() {
        if (this.isReverseGear) {
            return -1;
        }
        return this.currentGear + 1;
    }

    public void addGear(Gear gear) {
        this.vehicleGears.add(gear);
        ++this.highestGear;
    }

    public void declutch() {
        this.declutched = true;
    }

    public void clutch() {
        this.declutched = false;
    }

    public boolean isEngineDeclutched() {
        return this.declutched;
    }

    public void toggleECO() {
        this.isOnEcoShift = !this.isOnEcoShift;
    }

    public void setEcoState(boolean state) {
        this.isOnEcoShift = state;
    }

    public void ecoOff() {
        this.isOnEcoShift = false;
    }

    public void ecoOn() {
        this.isOnEcoShift = true;
    }

    public boolean isEcoModeOn() {
        return this.isOnEcoShift;
    }

    public void upShift() {
        if (this.getCurrentGear() < this.vehicleGears.size()) {
            ++this.currentGear;
        }
    }

    public void downShift() {
        if (this.currentGear > 0) {
            --this.currentGear;
        }
    }

    public void forceShift(int targetGear) {
        this.currentGear = targetGear - 1;
    }

    public void enterReverse() {
        this.isReverseGear = true;
    }

    public void exitReverse() {
        this.isReverseGear = false;
    }

    public void notifyShift() {
        this.runningAShift = true;
    }

    public void tickTransmission() {
        if (this.runningAShift) {
            ++this.shiftTimer;
        }
        if (this.shiftTimer >= this.maxShiftTime) {
            this.runningAShift = false;
            this.shiftTimer = 0;
            this.startGear = this.targetGear;
        }
    }

    public void runAutomaticTransmission(EntityVehicle vehicle, double engineRPM) {
        double median;
        this.tickTransmission();
        if (((this.getCurrentGear() == 1 || this.isReverseGear) && engineRPM <= (double)vehicle.solver.engine.getIdleRPM() || vehicle.solver.getVelocityVector().func_72433_c() == 0.0 && vehicle.throttle == 0.0 && engineRPM < 1100.0) && vehicle.getRealSpeed() < 10.0 && !this.inNeutral()) {
            this.setNeutral(true);
        } else if (vehicle.solver.getVelocityVector().func_72433_c() < 0.1 && vehicle.throttle > 0.5 && this.inNeutral()) {
            vehicle.solver.engineSolver.rpm += 2000.0;
            this.setNeutral(false);
        } else if (vehicle.solver.getVelocityVector().func_72433_c() > 0.1 && vehicle.throttle > 0.2 && this.inNeutral()) {
            this.setNeutral(false);
        }
        if (this.getClutch().getSlippage() == 1.0 || this.getClutch().getSlippage() != 0.0) {
            // empty if block
        }
        if (!vehicle.isBraking) {
            int delta = 0;
            if (vehicle.solver.transmission.isReverseGear) {
                delta = 350;
            }
            double nonStallWheelRatio = VehiclePhysUtil.wheelAngularVelocity(vehicle.getSolver().engineSolver.engineTemplate.getIdleRPM() + delta, this.getCurrentGearRatio(), this.getDifferentialRatio());
            double wheelAngularVelocity = vehicle.getSolver().rearAxel.getWheelAngularVelocity();
            double mu = Math.min(wheelAngularVelocity / nonStallWheelRatio, 1.0);
            double pressure = this.getClutch().engagementPoint + (1.0 - this.getClutch().engagementPoint) * mu;
            this.clutch.applyPedalPressure(1.0 - pressure);
        } else {
            this.clutch.applyPedalPressure(1.0);
        }
        if (vehicle.solver.engineSolver.rpm < 1200.0 && vehicle.throttle < 0.3) {
            this.clutch.applyPedalPressure(1.0);
        }
        if (this.isReverseGear || this.isEngineDeclutched()) {
            return;
        }
        int uShift = 0;
        int dShift = 0;
        if (!this.isOnEcoShift) {
            uShift = this.upshiftRPM;
            dShift = this.downshiftRPM;
        } else {
            uShift = this.eUShift;
            dShift = this.eDShift;
        }
        if (this.markedForUpshift || this.markedForDownshift) {
            this.markedForUpshift = engineRPM > (double)uShift && this.getCurrentGear() != this.highestGear && vehicle.throttle > 0.1;
            this.markedForDownshift = engineRPM < (double)dShift && this.getCurrentGear() != 1;
        }
        if (this.markedForUpshift) {
            if (this.runningAShift) {
                median = (double)this.maxShiftTime / 2.0;
                if ((double)this.shiftTimer > median) {
                    this.startGear = this.getCurrentGear();
                    this.shiftTimer = this.maxShiftTime - this.shiftTimer;
                }
            } else {
                this.startGear = this.getCurrentGear();
            }
            this.upShift();
            vehicle.notifyOfShift(this.getCurrentGear());
            this.targetGear = this.getCurrentGear();
            this.notifyShift();
            this.markedForUpshift = false;
        }
        if (this.markedForDownshift) {
            if (this.runningAShift) {
                median = (double)this.maxShiftTime / 2.0;
                if ((double)this.shiftTimer > median) {
                    this.startGear = this.getCurrentGear();
                    this.shiftTimer = this.maxShiftTime - this.shiftTimer;
                }
            } else {
                this.startGear = this.getCurrentGear();
            }
            this.downShift();
            vehicle.notifyOfShift(this.getCurrentGear());
            this.targetGear = this.getCurrentGear();
            this.notifyShift();
            this.markedForDownshift = false;
        }
        if (engineRPM > (double)uShift && this.getCurrentGear() != this.highestGear && vehicle.throttle > 0.1) {
            this.markedForUpshift = true;
        }
        if (engineRPM < (double)dShift && this.getCurrentGear() != 1) {
            this.markedForDownshift = true;
        }
    }

    public Transmission cloneTransmission() {
        Transmission t = this;
        Transmission newT = new Transmission(t.differentialRatio, t.reverseGearRatio, t.upshiftRPM, t.downshiftRPM);
        for (Gear g : t.vehicleGears) {
            newT.addGear(g);
        }
        return newT;
    }

    public float getCurrentGearRatio() {
        if (this.isReverseGear) {
            return this.reverseGearRatio;
        }
        return this.vehicleGears.get((int)this.currentGear).gearRatio;
    }

    public float getDifferentialRatio() {
        return this.differentialRatio;
    }

    public void gearWithRatio(float gR) {
        this.vehicleGears.add(new Gear(gR));
        ++this.highestGear;
    }

    public Transmission withEcoShift(int upshift, int downShift) {
        this.eUShift = upshift;
        this.eDShift = downShift;
        return this;
    }

    public void getEngineSpeed(float driveWheelSpeed) {
    }

    public Transmission quickSpeed(float ... gears) {
        for (float f : gears) {
            this.gearWithRatio(f);
        }
        return this;
    }

    public Transmission quickSixSpeed(float one, float two, float three, float four, float five, float six) {
        this.gearWithRatio(one);
        this.gearWithRatio(two);
        this.gearWithRatio(three);
        this.gearWithRatio(four);
        this.gearWithRatio(five);
        this.gearWithRatio(six);
        return this;
    }

    public Transmission quickFiveSpeed(float one, float two, float three, float four, float five) {
        this.gearWithRatio(one);
        this.gearWithRatio(two);
        this.gearWithRatio(three);
        this.gearWithRatio(four);
        this.gearWithRatio(five);
        return this;
    }

    public Transmission quickFourSpeed(float one, float two, float three, float four) {
        this.gearWithRatio(one);
        this.gearWithRatio(two);
        this.gearWithRatio(three);
        this.gearWithRatio(four);
        return this;
    }

    class Gear {
        public float gearRatio = 0.0f;

        public Gear(float gR) {
            this.gearRatio = gR;
        }
    }
}

