/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.shader.jim;

import com.paneedah.mwc.proxies.ClientProxy;
import com.paneedah.mwc.utils.ModReference;
import com.paneedah.weaponlib.render.bgl.GLCompatible;
import com.paneedah.weaponlib.shader.jim.Attribute;
import com.paneedah.weaponlib.shader.jim.Shader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.compress.utils.IOUtils;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL20;

public class ShaderLoader {
    public static boolean enableShaders = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Shader loadShader(String name, Attribute ... attributes) {
        if (!enableShaders) {
            return new Shader(0);
        }
        ResourceLocation file = new ResourceLocation("mwc:shaders/" + name);
        int vertexShaderId = GL20.glCreateShader((int)35633);
        int fragmentShaderId = GL20.glCreateShader((int)35632);
        int programId = GL20.glCreateProgram();
        try {
            GL20.glShaderSource((int)vertexShaderId, (ByteBuffer)ShaderLoader.readFileToBuf(new ResourceLocation(file.func_110624_b(), file.func_110623_a() + ".vert")));
            GL20.glCompileShader((int)vertexShaderId);
            if (GL20.glGetShaderi((int)vertexShaderId, (int)35713) == 0) {
                ModReference.LOG.error(GL20.glGetShaderInfoLog((int)vertexShaderId, (int)35716));
                throw new RuntimeException("Error creating vertex shader: " + file);
            }
            GL20.glShaderSource((int)fragmentShaderId, (ByteBuffer)ShaderLoader.readFileToBuf(new ResourceLocation(file.func_110624_b(), file.func_110623_a() + ".frag")));
            GL20.glCompileShader((int)fragmentShaderId);
            if (GL20.glGetShaderi((int)fragmentShaderId, (int)35713) == 0) {
                ModReference.LOG.error(GL20.glGetShaderInfoLog((int)fragmentShaderId, (int)35716));
                throw new RuntimeException("Error creating fragment shader: " + file);
            }
            GL20.glAttachShader((int)programId, (int)vertexShaderId);
            GL20.glAttachShader((int)programId, (int)fragmentShaderId);
            if (attributes != null) {
                for (Attribute attribute : attributes) {
                    GLCompatible.glBindAttribLocation(programId, attribute.getAttributeID(), attribute.getAttributeName());
                }
            }
            GL20.glLinkProgram((int)programId);
            if (GL20.glGetProgrami((int)programId, (int)35714) == 0) {
                ModReference.LOG.error(GL20.glGetProgramInfoLog((int)programId, (int)35716));
                throw new RuntimeException("Error creating fragment shader: " + file);
            }
            ModReference.LOG.debug("Loaded shader successfully for " + file);
            Shader shader = new Shader(programId);
            return shader;
        }
        catch (IOException iOException) {
            GL20.glDeleteProgram((int)programId);
            ModReference.LOG.error("Failed loading shader for " + iOException);
        }
        finally {
            GL20.glDeleteShader((int)vertexShaderId);
            GL20.glDeleteShader((int)fragmentShaderId);
        }
        return new Shader(0);
    }

    private static ByteBuffer readFileToBuf(ResourceLocation file) throws IOException {
        try (InputStream inputStream = ClientProxy.MC.func_110442_L().func_110536_a(file).func_110527_b();){
            byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
            ByteBuffer buffer = BufferUtils.createByteBuffer((int)bytes.length);
            buffer.put(bytes);
            buffer.rewind();
            ByteBuffer byteBuffer = buffer;
            return byteBuffer;
        }
    }
}

