/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.shader;

import com.paneedah.weaponlib.Tuple;
import com.paneedah.weaponlib.shader.DynamicShaderContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.util.ResourceLocation;

public class DynamicShaderGroupSource {
    private ResourceLocation shaderLocation;
    private List<AdvUniform> advUniforms;
    private List<Tuple<String, Function<DynamicShaderContext, Object>>> uniforms;
    private UUID sourceId;

    public DynamicShaderGroupSource(UUID sourceId, ResourceLocation location) {
        this.sourceId = sourceId;
        this.shaderLocation = location;
        this.uniforms = new ArrayList<Tuple<String, Function<DynamicShaderContext, Object>>>();
        this.advUniforms = new ArrayList<AdvUniform>();
    }

    public UUID getSourceId() {
        return this.sourceId;
    }

    public DynamicShaderGroupSource withUniform(String name, Function<DynamicShaderContext, Object> value) {
        this.uniforms.add(new Tuple<String, Function<DynamicShaderContext, Object>>(name, value));
        return this;
    }

    public DynamicShaderGroupSource withAdvUniform(AdvUniform u) {
        this.advUniforms.add(u);
        return this;
    }

    public ResourceLocation getShaderLocation() {
        return this.shaderLocation;
    }

    public List<Tuple<String, Function<DynamicShaderContext, Object>>> getUniforms(DynamicShaderContext context) {
        return Collections.unmodifiableList(this.uniforms);
    }

    public static interface AdvUniform {
        public void apply(DynamicShaderGroupSource var1);
    }
}

