/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.particle;

import com.paneedah.mwc.proxies.ClientProxy;
import com.paneedah.mwc.renderer.ParticleRenderer;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class ExplosionSmokeFX
extends Particle {
    private static final String DEFAULT_SMOKE_TEXTURE = "weaponlib:/com/paneedah/weaponlib/resources/large-smoke.png";
    private static final int columnCount = 4;
    private static final int rowCount = 4;
    private static final TriFunction<Float, Integer, Integer, Float> EXPLOSION_SCALE_UPDATE_FUNCTION = (currentScale, ticks, maxTicks) -> {
        currentScale = currentScale.floatValue() > 25.0f ? Float.valueOf(currentScale.floatValue() * 1.0008f) : (currentScale.floatValue() > 20.0f ? Float.valueOf(currentScale.floatValue() * 1.002f) : (currentScale.floatValue() > 15.0f ? Float.valueOf(currentScale.floatValue() * 1.004f) : (currentScale.floatValue() > 10.0f ? Float.valueOf(currentScale.floatValue() * 1.05f) : Float.valueOf(currentScale.floatValue() * 3.0f))));
        return currentScale;
    };
    private static final TriFunction<Float, Integer, Integer, Float> SMOKE_GRENADE_SCALE_UPDATE_FUNCTION = (currentScale, ticks, maxTicks) -> {
        currentScale = currentScale.floatValue() > 25.0f ? Float.valueOf(currentScale.floatValue() * 1.0008f) : (currentScale.floatValue() > 20.0f ? Float.valueOf(currentScale.floatValue() * 1.002f) : (currentScale.floatValue() > 15.0f ? Float.valueOf(currentScale.floatValue() * 1.004f) : (currentScale.floatValue() > 5.0f ? Float.valueOf(currentScale.floatValue() * 1.05f) : Float.valueOf(currentScale.floatValue() * 2.0f))));
        return currentScale;
    };
    private static final TriFunction<Float, Integer, Integer, Float> EXPLOSION_ALPHA_UPDATE_FUNCTION = (currentAlpha, ticks, maxTicks) -> {
        double alphaRadians = 0.7853981633974483 + Math.PI * (double)ticks.intValue() / (double)maxTicks.intValue();
        return Float.valueOf(0.3f * (float)Math.sin(alphaRadians > Math.PI ? Math.PI : alphaRadians));
    };
    private static final TriFunction<Float, Integer, Integer, Float> SMOKE_GRENADE_ALPHA_UPDATE_FUNCTION = (currentAlpha, ticks, maxTicks) -> {
        double alphaRadians = 0.7853981633974483 + Math.PI * (double)ticks.intValue() / (double)maxTicks.intValue();
        return Float.valueOf(0.3f * (float)Math.sin(alphaRadians > Math.PI ? Math.PI : alphaRadians));
    };
    private String particleTexture;
    private float scale;
    private int imageIndex;
    private Behavior behavior;

    public ExplosionSmokeFX(World par1World, double positionX, double positionY, double positionZ, float scale, float motionX, float motionY, float motionZ, int particleMaxAge, Behavior behavior, String particleTexture) {
        super(par1World, positionX, positionY, positionZ, 0.0, 0.0, 0.0);
        this.field_187129_i = motionX;
        this.field_187130_j = motionY;
        this.field_187131_k = motionZ;
        if (motionX == 0.0f) {
            motionX = 1.0f;
        }
        this.behavior = behavior;
        this.field_70552_h = 1.0f;
        this.field_70553_i = 1.0f;
        this.field_70551_j = 1.0f;
        this.field_82339_as = 0.0f;
        this.scale = scale;
        this.field_70547_e = particleMaxAge == 0 ? 50 + (int)(this.field_187136_p.nextFloat() * 30.0f) : particleMaxAge;
        this.imageIndex = this.field_187136_p.nextInt(16);
        this.particleTexture = particleTexture != null ? particleTexture : DEFAULT_SMOKE_TEXTURE;
    }

    public void func_189213_a() {
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_187112_i();
        }
        this.field_187130_j += 1.0E-5;
        this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
        this.field_187129_i *= 0.799999785423279;
        this.field_187130_j *= 0.9999999785423279;
        this.field_187131_k *= 0.799999785423279;
        this.field_82339_as = ((Float)this.behavior.alphaUpdateFunction.apply(Float.valueOf(this.field_82339_as), this.field_70546_d, this.field_70547_e)).floatValue();
        this.field_70544_f = ((Float)this.behavior.scaleUpdateFunction.apply(Float.valueOf(this.field_70544_f), this.field_70546_d, this.field_70547_e)).floatValue();
        if (this.field_187133_m) {
            this.field_187129_i *= (double)0.7f;
            this.field_187131_k *= (double)0.7f;
        }
    }

    public void func_180434_a(BufferBuilder buffer, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        ClientProxy.MC.func_110434_K().func_110577_a(new ResourceLocation(this.particleTexture));
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDepthMask((boolean)false);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glAlphaFunc((int)516, (float)0.003921569f);
        RenderHelper.func_74518_a();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181704_d);
        float scale = 0.1f * this.field_70544_f * this.scale;
        float x = (float)(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTicks - field_70556_an);
        float y = (float)(this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTicks - field_70554_ao);
        float z = (float)(this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTicks - field_70555_ap);
        int brightness = this.func_189214_a(partialTicks);
        int skyLight = brightness >> 16 & 0xFFFF;
        int blockLight = brightness & 0xFFFF;
        float columnWidth = 0.25f;
        float rowHeight = 0.25f;
        int rowIndex = Math.floorDiv(this.imageIndex, 4);
        int columnIndex = this.imageIndex % 4;
        float u1 = (float)(columnIndex + 1) * columnWidth;
        float v1 = (float)(rowIndex + 1) * rowHeight;
        float u2 = u1;
        float v2 = (float)rowIndex * rowHeight;
        float u3 = (float)columnIndex * columnWidth;
        float v3 = v2;
        float u4 = u3;
        float v4 = v1;
        ParticleRenderer.renderParticle(buffer, x - rotationX * scale - rotationXY * scale, y - rotationZ * scale, z - rotationYZ * scale - rotationXZ * scale, skyLight, blockLight, u1, v1, this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as);
        ParticleRenderer.renderParticle(buffer, x - rotationX * scale + rotationXY * scale, y + rotationZ * scale, z - rotationYZ * scale + rotationXZ * scale, skyLight, blockLight, u2, v2, this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as);
        ParticleRenderer.renderParticle(buffer, x + rotationX * scale + rotationXY * scale, y + rotationZ * scale, z + rotationYZ * scale + rotationXZ * scale, skyLight, blockLight, u3, v3, this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as);
        ParticleRenderer.renderParticle(buffer, x + rotationX * scale - rotationXY * scale, y - rotationZ * scale, z + rotationYZ * scale - rotationXZ * scale, skyLight, blockLight, u4, v4, this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as);
        Tessellator.func_178181_a().func_78381_a();
        RenderHelper.func_74519_b();
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    public int func_70537_b() {
        return 3;
    }

    static /* synthetic */ TriFunction access$200() {
        return EXPLOSION_SCALE_UPDATE_FUNCTION;
    }

    static /* synthetic */ TriFunction access$300() {
        return EXPLOSION_ALPHA_UPDATE_FUNCTION;
    }

    static /* synthetic */ TriFunction access$400() {
        return SMOKE_GRENADE_SCALE_UPDATE_FUNCTION;
    }

    static /* synthetic */ TriFunction access$500() {
        return SMOKE_GRENADE_ALPHA_UPDATE_FUNCTION;
    }

    public static interface TriFunction<T, U, V, R> {
        public R apply(T var1, U var2, V var3);
    }

    public static enum Behavior {
        EXPLOSION(ExplosionSmokeFX.access$200(), ExplosionSmokeFX.access$300()),
        SMOKE_GRENADE(ExplosionSmokeFX.access$400(), ExplosionSmokeFX.access$500());

        private TriFunction<Float, Integer, Integer, Float> scaleUpdateFunction;
        private TriFunction<Float, Integer, Integer, Float> alphaUpdateFunction;

        private Behavior(TriFunction<Float, Integer, Integer, Float> scaleUpdateFunction, TriFunction<Float, Integer, Integer, Float> alphaUpdateFunction) {
            this.scaleUpdateFunction = scaleUpdateFunction;
            this.alphaUpdateFunction = alphaUpdateFunction;
        }
    }
}

