/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.compatibility.graph;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.ClassPath;
import com.paneedah.weaponlib.Pair;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.lwjgl.opengl.GLContext;

public class CompatibilityClassGenerator {
    private boolean loaded = false;
    private ArrayList<Class<?>> classes = new ArrayList();
    private ArrayList<Class<?>> glClasses = new ArrayList();

    public void setup() {
        if (this.loaded) {
            return;
        }
        this.loaded = true;
        try {
            ImmutableSet i = ClassPath.from((ClassLoader)ClassLoader.getSystemClassLoader()).getTopLevelClasses("org.lwjgl.opengl");
            for (ClassPath.ClassInfo classInfo : i) {
                String classInformationString = classInfo.toString();
                Class<?> clazz = null;
                try {
                    clazz = Class.forName(classInformationString);
                }
                catch (Error e) {
                    continue;
                }
                if (this.isGLClass(clazz)) {
                    this.glClasses.add(clazz);
                    continue;
                }
                this.classes.add(clazz);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isGLClass(Class<?> clazz) {
        String simpleName = clazz.getSimpleName();
        return simpleName.length() > 2 && Character.isDigit(simpleName.charAt(3));
    }

    public ArrayList<StringBuilder> findMethods(String methodSearch) {
        return null;
    }

    public ArrayList<Pair<Class<?>, Method>> findStandardOpenGLMethod(String searchTerm) {
        ArrayList array = new ArrayList();
        array.clear();
        for (Class<?> clazz : this.glClasses) {
            for (Method m : clazz.getMethods()) {
                if (!m.getName().contains(searchTerm)) continue;
                array.add(new Pair(clazz, m));
            }
        }
        return array;
    }

    public StringBuilder getIfStatementChecks(String name, String caseName) {
        Field[] fields;
        String[] args = name.split("(?=\\p{Upper})");
        for (int i = 0; i < args.length; ++i) {
            args[i] = args[i].toLowerCase();
        }
        ArrayList argList = (ArrayList)Arrays.asList(args);
        for (String s : args) {
            argList.add(s);
        }
        for (Field f : fields = GLContext.getCapabilities().getClass().getFields()) {
            boolean shouldBreak = false;
            for (int i = 2; i < args.length; ++i) {
                if (!f.getName().contains((CharSequence)argList.get(i))) continue;
                System.out.println("hi " + f.getName());
                shouldBreak = true;
            }
            if (shouldBreak) break;
            System.out.println(f);
        }
        return null;
    }

    public StringBuilder buildOutMethod(Pair<Class<?>, Method> original, String searchTerm) {
        HashMap methodNameMap = new HashMap();
        StringBuilder builder = new StringBuilder();
        builder.append("public static " + original.getSecond().getReturnType().getSimpleName() + " " + original.getSecond().getName());
        builder.append("(");
        StringBuilder parameterBuilder = new StringBuilder();
        parameterBuilder.append("(");
        Parameter[] parameters = original.getSecond().getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            if (i == 0) {
                builder.append(parameters[i].getType().getSimpleName() + " " + parameters[i].getName());
                parameterBuilder.append(parameters[i].getName());
                continue;
            }
            builder.append(", " + parameters[i].getType().getSimpleName() + " " + parameters[i].getName());
            parameterBuilder.append(", " + parameters[i].getName());
        }
        ArrayList<Pair<Class<?>, Method>> methods = this.getExtensions(original, searchTerm);
        methods.add(original);
        parameterBuilder.append(")");
        builder.append(") {\n");
        builder.append("\tswitch(case) {");
        for (Pair<Class<?>, Method> pair : methods) {
            String genericName = pair.getFirst().getSimpleName();
            builder.append("\n\t\tcase ");
            if (genericName.contains("ARB")) {
                builder.append("ARB:");
            } else if (genericName.contains("EXT")) {
                builder.append("EXT:");
            } else if (genericName.contains("APPLE")) {
                builder.append("APPLE:");
            } else {
                builder.append("NORMAL:");
            }
            if (!original.getSecond().getReturnType().toString().equals("void")) {
                builder.append("\n\t\t\treturn " + genericName + "." + pair.getSecond().getName() + parameterBuilder.toString() + ";");
                continue;
            }
            builder.append("\n\t\t\t" + genericName + "." + pair.getSecond().getName() + parameterBuilder.toString() + ";");
            builder.append("\n\t\t\tbreak;");
        }
        builder.append("\n\t}");
        if (original.getSecond().getReturnType().toString().equals("int")) {
            builder.append("\n\treturn 0;");
        } else if (original.getSecond().getReturnType().toString().equals("boolean")) {
            builder.append("\n\treturn false;");
        } else {
            builder.append("\n\treturn;");
        }
        builder.append("\n}");
        return builder;
    }

    public boolean isMethodEquivalent(Method a, Method b) {
        if (!a.getReturnType().toString().equals(b.getReturnType().toString())) {
            return false;
        }
        if (a.getParameterCount() != b.getParameterCount()) {
            return false;
        }
        for (int i = 0; i < a.getParameterCount(); ++i) {
            if (a.getParameters()[i].toString().equals(b.getParameters()[i].toString())) continue;
            return false;
        }
        return true;
    }

    public ArrayList<Pair<Class<?>, Method>> getExtensions(Pair<Class<?>, Method> original, String search) {
        ArrayList extensionsList = new ArrayList();
        for (Class<?> clazz : this.classes) {
            for (Method m : clazz.getMethods()) {
                if (!m.getName().contains(search) || !this.isMethodEquivalent(m, original.getSecond())) continue;
                extensionsList.add(new Pair(clazz, m));
            }
        }
        return extensionsList;
    }
}

