/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.animation.movement;

import com.paneedah.weaponlib.ClientEventHandler;
import com.paneedah.weaponlib.PlayerWeaponInstance;
import com.paneedah.weaponlib.RenderContext;
import com.paneedah.weaponlib.RenderableState;
import com.paneedah.weaponlib.WeaponRenderer;
import com.paneedah.weaponlib.animation.ClientValueRepo;
import com.paneedah.weaponlib.animation.jim.BBLoader;
import com.paneedah.weaponlib.animation.jim.KeyedAnimation;
import com.paneedah.weaponlib.compatibility.RecoilParam;
import com.paneedah.weaponlib.numerical.LissajousCurve;
import com.paneedah.weaponlib.numerical.SpringValue;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.opengl.GL11;

public class WeaponRotationHandler {
    private static final float HALF_PI = 1.5707964f;
    public static final KeyedAnimation WALKING_ANIMATION = new KeyedAnimation(BBLoader.getAnimation("universal", "walkforward", "main"));
    public static final KeyedAnimation RUNNING_ANIMATION = new KeyedAnimation(BBLoader.getAnimation("universal", "running", "main"));
    public static final KeyedAnimation STRAFING_ANIMATION = new KeyedAnimation(BBLoader.getAnimation("universal", "walk", "main"));
    private static final Vec3d MOVEMENT_ANIMATION_ROTATION_POINT = new Vec3d(-0.1, -1.0, 0.0);
    private static final Vec3d SWAY_ANIMATION_ROTATION_POINT = new Vec3d(0.0, 0.0, 1.5);
    private static final Vec3d RECOIL_ANIMATION_ROTATION_POINT = new Vec3d(0.0, 1.0, 0.0);
    private static final float WALKING_SWAY_COMPONENT_DIVISOR = 0.033f;
    private static final double RECOIL_ANIMATION_AMPLITUDE = 0.008;
    private static final float SWAY_AMPLITUDE_NORMAL = 0.15f;
    private static final float SWAY_AMPLITUDE_OPTICAL_ADS = 0.03f;
    private static final float DIVISOR_MULTIPLIER_OPTICAL = 0.33f;
    private static final float RECOVERY_SPRING_ADS_DAMPING = 5.0f;
    private static final float FORWARD_MAGNITUDE_ADS_DIVISOR = 0.2f;
    private static final float STRAFE_MAGNITUDE_ADS_DIVISOR = 0.33f;
    private static final float RECOIL_AMPLITUDE_ADS_DIVISOR = 0.33f;
    private static final float WEAPON_RECOVERY_ADS_DIVISOR = 0.5f;
    private static final float WALKING_SWAY_ADS_DIVISOR = 0.25f;

    public static void applyRotationAtPoint(float xOffset, float yOffset, float zOffset, float xRotation, float yRotation, float zRotation) {
        GL11.glTranslatef((float)(-xOffset), (float)(-yOffset), (float)(-zOffset));
        GL11.glRotatef((float)xRotation, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)yRotation, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)zRotation, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)xOffset, (float)yOffset, (float)zOffset);
    }

    public static void applyRotationAtPoint(Vec3d offset, float x, float y, float z) {
        WeaponRotationHandler.applyRotationAtPoint((float)offset.field_72450_a, (float)offset.field_72448_b, (float)offset.field_72449_c, x, y, z);
    }

    public void run(RenderContext<RenderableState> renderContext, WeaponRenderer.StateDescriptor stateDescriptor) {
        if (ClientEventHandler.cancelSway) {
            return;
        }
        PlayerWeaponInstance pwi = renderContext.getWeaponInstance();
        RecoilParam params = pwi.getRecoilParameters();
        float forwardMagnitude = ClientValueRepo.forward.getLerpedFloat();
        float strafeMagnitude = ClientValueRepo.strafe.getLerpedFloat();
        float runningMagnitude = ClientValueRepo.running.getLerpedFloat();
        float swayAmplitude = 0.15f;
        float walkingSwayAmplitude = strafeMagnitude * 0.033f + forwardMagnitude * 0.033f;
        float recoilAmplitude = ClientValueRepo.gunPow.getLerpedFloat();
        float weaponRecoveryAmplitude = ClientValueRepo.weaponRecovery.getLerpedFloat() / 15.0f;
        float muzzleClimbDivisor = (float)params.getMuzzleClimbDivisor();
        float rotationYDivisor = (float)params.getWeaponRotationX();
        float rotationZDivisor = (float)params.getWeaponRotationY();
        SpringValue recoverySpring = ClientValueRepo.weaponRecovery;
        if (renderContext.getWeaponInstance().isAimed()) {
            float divisorMultiplier = 1.0f;
            if (renderContext.getWeaponInstance().getScope() != null && renderContext.getWeaponInstance().getScope().isOptical()) {
                divisorMultiplier = 0.33f;
                swayAmplitude = 0.03f;
                walkingSwayAmplitude *= 0.33f;
            }
            divisorMultiplier = (float)((double)divisorMultiplier / params.getADSSimilarity());
            recoverySpring.setDamping(5.0);
            forwardMagnitude *= 0.2f * divisorMultiplier;
            strafeMagnitude *= 0.33f * divisorMultiplier;
            recoilAmplitude *= 0.33f * divisorMultiplier;
            weaponRecoveryAmplitude *= 0.5f * divisorMultiplier;
            walkingSwayAmplitude *= 0.25f * divisorMultiplier;
        }
        double gunSwayX = LissajousCurve.getXOffsetOnCurve(swayAmplitude, 0.25, Math.PI, 0.0, ClientValueRepo.TICKER.getLerpedFloat());
        double gunSwayY = LissajousCurve.getXOffsetOnCurve(swayAmplitude, 0.5, Math.PI, 1.5707963705062866, ClientValueRepo.TICKER.getLerpedFloat());
        double walkSwayX = LissajousCurve.getXOffsetOnCurve(walkingSwayAmplitude, 0.5, Math.PI, 0.0, ClientValueRepo.TICKER.getLerpedFloat());
        double walkSwayY = LissajousCurve.getXOffsetOnCurve(walkingSwayAmplitude, 0.25, Math.PI, 1.5707963705062866, ClientValueRepo.TICKER.getLerpedFloat());
        Vec3d stressVector = ClientValueRepo.stressVec.getInterpolatedVector(2.0);
        Vec3d recoilRotation = ClientValueRepo.recoilRotationVector.getInterpolatedVector(1.0);
        STRAFING_ANIMATION.doPositioning(strafeMagnitude, MOVEMENT_ANIMATION_ROTATION_POINT);
        WALKING_ANIMATION.doPositioning(Math.max(forwardMagnitude - runningMagnitude, 0.0f), MOVEMENT_ANIMATION_ROTATION_POINT);
        RUNNING_ANIMATION.doPositioning(Math.max(runningMagnitude, 0.0f), MOVEMENT_ANIMATION_ROTATION_POINT);
        GlStateManager.func_179137_b((double)walkSwayY, (double)walkSwayX, (double)0.0);
        WeaponRotationHandler.applyRotationAtPoint(SWAY_ANIMATION_ROTATION_POINT, (float)gunSwayX, (float)gunSwayY, 0.0f);
        GlStateManager.func_179114_b((float)((float)ClientValueRepo.xInertia.getLerpedPosition()), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)ClientValueRepo.yInertia.getLerpedPosition()), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)(weaponRecoveryAmplitude / 5.0f), (float)weaponRecoveryAmplitude);
        GlStateManager.func_179114_b((float)(weaponRecoveryAmplitude * 5.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179137_b((double)stressVector.field_72450_a, (double)stressVector.field_72448_b, (double)stressVector.field_72449_c);
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)((double)recoilAmplitude * 0.008));
        WeaponRotationHandler.applyRotationAtPoint(RECOIL_ANIMATION_ROTATION_POINT, (float)recoilRotation.field_72450_a, (float)recoilRotation.field_72448_b, (float)recoilRotation.field_72449_c);
        WeaponRotationHandler.applyRotationAtPoint(RECOIL_ANIMATION_ROTATION_POINT, -recoilAmplitude / muzzleClimbDivisor, recoilAmplitude * rotationYDivisor, recoilAmplitude * rotationZDivisor);
    }
}

