/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.animation;

import com.paneedah.weaponlib.animation.Interpolation;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;

public class MultipartTransition<Part, Context> {
    private static final Consumer<?> DEFAULT_POSITION = c -> {};
    public Context cont;
    private Map<Part, Consumer<Context>> multipartPositionFunctions = new HashMap<Part, Consumer<Context>>();
    private Map<Part, Part> attachedTo = new HashMap<Part, Part>();
    private long duration;
    private long pause;
    public SoundEvent sound;
    public Vec3d beizer;
    public Interpolation interp = Interpolation.SMOOTHSTEP;

    public static <Context> Consumer<Context> anchoredPosition() {
        return DEFAULT_POSITION;
    }

    public MultipartTransition(Part part, Consumer<Context> positionFunction, long duration, long pause) {
        this.duration = duration;
        this.pause = pause;
        this.multipartPositionFunctions.put(part, positionFunction);
    }

    public MultipartTransition(Part part, Consumer<Context> positionFunction, long duration) {
        this(part, positionFunction, duration, 0L);
    }

    public MultipartTransition(long duration, long pause) {
        this.duration = duration;
        this.pause = pause;
    }

    public MultipartTransition(long duration, long pause, Interpolation interp) {
        this.duration = duration;
        this.pause = pause;
        this.interp = interp;
    }

    public MultipartTransition(long duration, long pause, Vec3d beizer) {
        this.duration = duration;
        this.pause = pause;
        this.beizer = beizer;
    }

    public boolean animationUsesBeizer() {
        return this.beizer != null;
    }

    public Interpolation getInterpolationType() {
        return this.interp;
    }

    public MultipartTransition(long duration) {
        this(duration, 0L);
    }

    public MultipartTransition<Part, Context> withPartPositionFunction(Part part, Consumer<Context> positionFunction) {
        return this.withPartPositionFunction(part, null, positionFunction);
    }

    public MultipartTransition<Part, Context> withPartPositionFunction(Part part, Part attachedTo, Consumer<Context> positionFunction) {
        this.multipartPositionFunctions.put(part, positionFunction);
        this.attachedTo.put(part, attachedTo);
        return this;
    }

    public void position(Part part, Context context) {
        Consumer<Context> positionFunction = this.multipartPositionFunctions.get(part);
        if (positionFunction == null) {
            positionFunction = MultipartTransition.anchoredPosition();
        }
        positionFunction.accept(context);
    }

    public Consumer<Context> getPositioning(Part part) {
        return this.multipartPositionFunctions.get(part);
    }

    public Context getContext() {
        return this.cont;
    }

    public long getDuration() {
        return this.duration;
    }

    public long getPause() {
        return this.pause;
    }

    public Part getAttachedTo(Part part) {
        return this.attachedTo.get(part);
    }
}

