/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib;

import com.paneedah.mwc.network.TypeRegistry;
import com.paneedah.mwc.network.UniversalObject;
import com.paneedah.mwc.utils.ModReference;
import com.paneedah.weaponlib.PlayerWeaponInstance;
import com.paneedah.weaponlib.perspective.Perspective;
import com.paneedah.weaponlib.state.ExtendedState;
import com.paneedah.weaponlib.state.ManagedState;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class PlayerItemInstance<S extends ManagedState<S>>
extends UniversalObject
implements ExtendedState<S> {
    protected S state;
    protected long stateUpdateTimestamp = System.currentTimeMillis();
    private long updateId;
    protected EntityLivingBase player;
    protected Item item;
    protected int itemInventoryIndex;
    private PlayerItemInstance<S> preparedState;
    private long syncStartTimestamp;
    protected long updateTimestamp;
    protected long reloadUpdateTimestamp;
    protected boolean compoundMagSwapCompleted = false;

    public PlayerItemInstance() {
    }

    public PlayerItemInstance(int itemInventoryIndex, EntityLivingBase player) {
        this.itemInventoryIndex = itemInventoryIndex;
        this.player = player;
        ItemStack itemStack = player.func_184614_ca();
        if (itemStack != null) {
            this.item = itemStack.func_77973_b();
        }
    }

    public PlayerItemInstance(int itemInventoryIndex, EntityLivingBase player, ItemStack itemStack) {
        this.itemInventoryIndex = itemInventoryIndex;
        this.player = player;
        if (itemStack != null) {
            this.item = itemStack.func_77973_b();
        }
    }

    public ItemStack getItemStack() {
        return this.player instanceof EntityPlayer ? ((EntityPlayer)this.player).field_71071_by.func_70301_a(this.itemInventoryIndex) : null;
    }

    protected <T extends PlayerItemInstance<S>> T getPreparedState() {
        return (T)this.preparedState;
    }

    public boolean shouldHaveInstanceTags() {
        return true;
    }

    @Override
    public void read(ByteBuf byteBuf) {
        super.read(byteBuf);
        this.item = Item.func_150899_d((int)byteBuf.readInt());
        this.itemInventoryIndex = byteBuf.readInt();
        this.updateId = byteBuf.readLong();
        this.state = (ManagedState)TypeRegistry.getINSTANCE().fromBytes(byteBuf);
    }

    @Override
    public void write(ByteBuf byteBuf) {
        super.write(byteBuf);
        byteBuf.writeInt(Item.func_150891_b((Item)this.item));
        byteBuf.writeInt(this.itemInventoryIndex);
        byteBuf.writeLong(this.updateId);
        TypeRegistry.getINSTANCE().toBytes(this.state, byteBuf);
    }

    @Override
    public boolean setState(S state) {
        this.state = state;
        this.stateUpdateTimestamp = System.currentTimeMillis();
        this.markDirty();
        if (this.preparedState != null) {
            if (this.preparedState.getState().commitPhase() == state) {
                ModReference.LOG.debug("Committing state {} to {}", this.preparedState.getState(), this.preparedState.getState().commitPhase());
                this.updateWith(this.preparedState, false);
            } else {
                this.rollback();
            }
            this.preparedState = null;
        } else {
            ModReference.LOG.warn("Prepared state is null for PlayerItemInstance: {}", (Object)this);
        }
        return false;
    }

    protected void rollback() {
        ModReference.LOG.warn("Attempted rolling back, but this method is empty. State: {}, Prepared State: {}, Prepared State State: {}, Prepared State State Commit Phase: {}", this.state, this.preparedState, this.preparedState.getState(), this.preparedState.getState().commitPhase());
    }

    protected void updateWith(PlayerItemInstance<S> otherState, boolean updateManagedState) {
        if (updateManagedState) {
            this.setState(otherState.getState());
        }
    }

    @Override
    public S getState() {
        return this.state;
    }

    @Override
    public long getStateUpdateTimestamp() {
        return this.stateUpdateTimestamp;
    }

    public void markReloadDirt() {
        this.reloadUpdateTimestamp = System.currentTimeMillis();
    }

    public long getReloadTimestamp() {
        return this.reloadUpdateTimestamp;
    }

    protected void markDirty() {
        ++this.updateId;
        this.updateTimestamp = System.currentTimeMillis();
    }

    protected void markClean() {
        this.updateId = 0L;
    }

    @Override
    public <E extends ExtendedState<S>> void prepareTransaction(E preparedExtendedState) {
        this.setState(preparedExtendedState.getState());
        this.preparedState = (PlayerItemInstance)preparedExtendedState;
    }

    public void completeMagSwap() {
        this.compoundMagSwapCompleted = true;
    }

    public void markMagSwapReady() {
        this.compoundMagSwapCompleted = false;
    }

    public boolean isMagSwapDone() {
        return this.compoundMagSwapCompleted;
    }

    public void setSyncStartTimestamp(long syncStartTimestamp) {
        this.syncStartTimestamp = syncStartTimestamp;
    }

    public Class<? extends Perspective<?>> getRequiredPerspectiveType() {
        return null;
    }

    protected void reconcile() {
        ModReference.LOG.warn("Reconciling PlayerItemInstance: {}, but this method is empty", (Object)this);
    }

    public long getUpdateId() {
        return this.updateId;
    }

    public EntityLivingBase getPlayer() {
        return this.player;
    }

    public void setPlayer(EntityLivingBase player) {
        this.player = player;
    }

    public Item getItem() {
        return this.item;
    }

    public int getItemInventoryIndex() {
        return this.itemInventoryIndex;
    }

    public void setItemInventoryIndex(int itemInventoryIndex) {
        this.itemInventoryIndex = itemInventoryIndex;
    }

    public long getSyncStartTimestamp() {
        return this.syncStartTimestamp;
    }

    public long getUpdateTimestamp() {
        return this.updateTimestamp;
    }

    static {
        TypeRegistry.getINSTANCE().register(PlayerItemInstance.class);
        TypeRegistry.getINSTANCE().register(PlayerWeaponInstance.class);
    }
}

