/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib;

import com.paneedah.weaponlib.AttachmentBuilder;
import com.paneedah.weaponlib.AttachmentCategory;
import com.paneedah.weaponlib.ItemAttachment;
import com.paneedah.weaponlib.ItemBullet;
import com.paneedah.weaponlib.MagazineState;
import com.paneedah.weaponlib.ModContext;
import com.paneedah.weaponlib.Part;
import com.paneedah.weaponlib.PlayerItemInstanceFactory;
import com.paneedah.weaponlib.PlayerMagazineInstance;
import com.paneedah.weaponlib.Reloadable;
import com.paneedah.weaponlib.Tags;
import com.paneedah.weaponlib.Updatable;
import com.paneedah.weaponlib.Weapon;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.model.ModelBase;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemMagazine
extends ItemAttachment<Weapon>
implements PlayerItemInstanceFactory<PlayerMagazineInstance, MagazineState>,
Reloadable,
Updatable,
Part {
    private ModContext modContext;
    private final int capacity;
    private List<ItemBullet> compatibleBullets;
    private SoundEvent reloadSound;
    private SoundEvent unloadSound;

    ItemMagazine(ModelBase model, String textureName, int capacity) {
        this(model, textureName, capacity, null, null);
    }

    ItemMagazine(ModelBase model, String textureName, int capacity, ItemAttachment.ApplyHandler<Weapon> apply, ItemAttachment.ApplyHandler<Weapon> remove) {
        super(AttachmentCategory.MAGAZINE, model, textureName, null, apply, remove);
        this.capacity = capacity;
        this.func_77625_d(1);
    }

    public ItemStack create(int ammunition) {
        ItemStack itemStack = new ItemStack((Item)this);
        this.initializeTag(itemStack, ammunition);
        return itemStack;
    }

    public ItemStack create() {
        return this.create(this.capacity);
    }

    private void initializeTag(ItemStack itemStack, int initialAmmo) {
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
            Tags.setAmmo(itemStack, initialAmmo);
        }
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        this.initializeTag(stack, 0);
    }

    public List<ItemBullet> getCompatibleBullets() {
        return this.compatibleBullets;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public SoundEvent getReloadSound() {
        return this.reloadSound;
    }

    public SoundEvent getUnloadSound() {
        return this.unloadSound;
    }

    @Override
    public Part getRenderablePart() {
        return this;
    }

    @Override
    public PlayerMagazineInstance createItemInstance(EntityLivingBase player, ItemStack itemStack, int slot) {
        PlayerMagazineInstance instance = new PlayerMagazineInstance(slot, player, itemStack);
        instance.setState(MagazineState.READY);
        return instance;
    }

    @Override
    public void update(EntityPlayer player) {
        this.modContext.getMagazineReloadAspect().updateMainHeldItem(player);
    }

    @Override
    public void reloadMainHeldItemForPlayer(EntityPlayer player) {
        this.modContext.getMagazineReloadAspect().reloadMainHeldItem(player);
    }

    @Override
    public void unloadMainHeldItemForPlayer(EntityPlayer player) {
        this.modContext.getMagazineReloadAspect().unloadMainHeldItem(player);
    }

    public static final class Builder
    extends AttachmentBuilder<Weapon> {
        private int capacity;
        private final List<ItemBullet> compatibleBullets = new ArrayList<ItemBullet>();
        private String reloadSound;
        private String unloadSound;

        public Builder withCapacity(int capacity) {
            this.capacity = capacity;
            return this;
        }

        public Builder withCompatibleBullet(ItemBullet compatibleBullet) {
            this.compatibleBullets.add(compatibleBullet);
            return this;
        }

        public Builder withUnloadSound(String unloadSound) {
            this.unloadSound = unloadSound;
            return this;
        }

        public Builder withReloadSound(String reloadSound) {
            this.reloadSound = reloadSound;
            return this;
        }

        @Override
        protected ItemAttachment<Weapon> createAttachment(ModContext modContext) {
            ItemMagazine magazine = new ItemMagazine(this.getModel(), this.getTextureName(), this.capacity);
            magazine.compatibleBullets = this.compatibleBullets;
            if (this.reloadSound != null) {
                magazine.reloadSound = modContext.registerSound(this.reloadSound);
            }
            if (this.unloadSound != null) {
                magazine.unloadSound = modContext.registerSound(this.unloadSound);
            }
            magazine.modContext = modContext;
            this.withInformationProvider(stack -> TextFormatting.RED + "Ammo: " + TextFormatting.GRAY + Tags.getAmmo(stack) + "/" + this.capacity);
            return magazine;
        }
    }
}

