/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib;

import akka.japi.Predicate;
import com.paneedah.weaponlib.SecondaryEntityRegistry;
import com.paneedah.weaponlib.compatibility.ModelRegistryServerInterchange;
import com.paneedah.weaponlib.crafting.CraftingEntry;
import com.paneedah.weaponlib.crafting.CraftingGroup;
import com.paneedah.weaponlib.crafting.CraftingRegistry;
import com.paneedah.weaponlib.crafting.IModernCraftingRecipe;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class HighIQSpawnEgg
extends Item
implements IModernCraftingRecipe {
    private CraftingEntry[] modernRecipe;
    private CraftingGroup craftGroup;
    private String entitySpawnName;
    private Predicate<Block> blockPredicate;
    private int spawnID;

    public int getID() {
        return this.spawnID;
    }

    public void setID(int i) {
        this.spawnID = i;
    }

    public String getEntitySpawnName() {
        return this.entitySpawnName;
    }

    public void setEntitySpawnName(String entitySpawnName) {
        this.entitySpawnName = entitySpawnName;
    }

    public Predicate<Block> getBlockPredicate() {
        return this.blockPredicate;
    }

    public void setBlockPredicate(Predicate<Block> blockPredicate) {
        this.blockPredicate = blockPredicate;
    }

    /*
     * Loose catch block
     */
    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        block8: {
            if (hand == EnumHand.OFF_HAND) {
                return EnumActionResult.FAIL;
            }
            if (this.blockPredicate.test((Object)worldIn.func_180495_p(pos).func_177230_c())) break block8;
            return EnumActionResult.FAIL;
            {
                catch (Exception e) {
                    e.printStackTrace();
                    return EnumActionResult.PASS;
                }
            }
        }
        try {
            if (!worldIn.field_72995_K) {
                NBTTagCompound btc = new NBTTagCompound();
                btc.func_74778_a("id", "mwc:" + this.getEntitySpawnName());
                Entity entity = AnvilChunkLoader.func_186054_a((NBTTagCompound)btc, (World)worldIn, (double)((double)pos.func_177958_n() + 0.5), (double)pos.func_177984_a().func_177956_o(), (double)((double)pos.func_177952_p() + 0.5), (boolean)true);
                entity.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177984_a().func_177956_o(), (double)pos.func_177952_p() + 0.5);
                if (entity instanceof EntityLiving) {
                    ((EntityLiving)entity).func_180482_a(worldIn.func_175649_E(new BlockPos(entity)), (IEntityLivingData)null);
                }
            }
            player.func_184614_ca().func_190918_g(1);
            return EnumActionResult.SUCCESS;
        }
        catch (Exception e) {
            System.err.println("Unable to spawn entity with name: " + this.getEntitySpawnName());
            return super.func_180614_a(player, worldIn, pos, hand, facing, hitX, hitY, hitZ);
        }
    }

    @Override
    public CraftingEntry[] getModernRecipe() {
        return this.modernRecipe;
    }

    @Override
    public ItemStack getItemStack() {
        return new ItemStack((Item)this);
    }

    @Override
    public CraftingGroup getCraftingGroup() {
        return this.craftGroup;
    }

    @Override
    public void setCraftingRecipe(CraftingEntry[] recipe) {
        this.modernRecipe = recipe;
    }

    @Override
    public void setCraftingGroup(CraftingGroup group) {
        this.craftGroup = group;
    }

    public static class Builder {
        private String entitySpawnName;
        private Predicate<Block> blockPredicate;
        private String registryName;
        private CreativeTabs creativeTab;
        private int id;

        public Builder withEntitySpawnName(String name) {
            this.entitySpawnName = name;
            return this;
        }

        public Builder withBlockPredicate(Predicate<Block> predicate) {
            this.blockPredicate = predicate;
            return this;
        }

        public Builder withItemName(String name) {
            this.registryName = name;
            return this;
        }

        public Builder withCreativeTab(CreativeTabs tab) {
            this.creativeTab = tab;
            return this;
        }

        public HighIQSpawnEgg build() {
            HighIQSpawnEgg egg = new HighIQSpawnEgg();
            egg.setBlockPredicate(this.blockPredicate);
            egg.setEntitySpawnName(this.entitySpawnName);
            egg.func_77637_a(this.creativeTab);
            egg.func_77655_b(this.registryName);
            egg.setRegistryName("mwc", this.registryName);
            egg.setID(this.id);
            SecondaryEntityRegistry.pickupMap.put(this.id, egg);
            CraftingRegistry.registerHook(egg);
            ForgeRegistries.ITEMS.register((IForgeRegistryEntry)egg);
            ModelRegistryServerInterchange.ITEM_MODEL_REG.add(egg);
            return egg;
        }

        public Builder withID(int i) {
            this.id = i;
            return this;
        }
    }
}

