/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib;

import com.paneedah.mwc.MWC;
import com.paneedah.mwc.network.messages.BlockHitMessage;
import com.paneedah.mwc.utils.MWCUtil;
import com.paneedah.weaponlib.config.ModernConfigManager;
import io.netty.buffer.ByteBuf;
import io.redstudioragnarok.redcore.vectors.Vector3D;
import io.redstudioragnarok.redcore.vectors.Vector3F;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public abstract class EntityProjectile
extends Entity
implements IProjectile,
IEntityAdditionalSpawnData {
    private static final String TAG_GRAVITY_VELOCITY = "gravityVelocity";
    private static final int MAX_TICKS = 200;
    private static final int DEFAULT_MAX_LIFETIME = 5000;
    private int xTile = -1;
    private int yTile = -1;
    private int zTile = -1;
    protected boolean inGround;
    public int throwableShake;
    protected EntityLivingBase thrower;
    private String throwerName;
    private int ticksInAir;
    protected float gravityVelocity;
    protected float velocity;
    protected float inaccuracy;
    private long timestamp;
    private double aimTan;
    protected long maxLifetime = 5000L;

    public EntityProjectile(World world) {
        super(world);
        this.func_70105_a(0.25f, 0.25f);
        this.timestamp = System.currentTimeMillis();
    }

    public EntityProjectile(World world, EntityLivingBase thrower, float velocity, float gravityVelocity, float inaccuracy) {
        this(world);
        this.thrower = thrower;
        this.velocity = velocity;
        this.gravityVelocity = gravityVelocity;
        this.inaccuracy = inaccuracy;
    }

    public void setPositionAndDirection(boolean isAiming) {
        double x = this.thrower.field_70165_t;
        double y = this.thrower.field_70163_u + (double)this.thrower.func_70047_e();
        double z = this.thrower.field_70161_v;
        this.func_70080_a(x -= Math.cos((double)(this.thrower.field_70177_z / 180.0f) * Math.PI) * (isAiming ? 0.0 : 0.16), y -= isAiming ? 0.0 : 0.1, z -= Math.sin((double)(this.thrower.field_70177_z / 180.0f) * Math.PI) * (isAiming ? 0.0 : 0.16), this.thrower.field_70177_z, this.thrower.field_70125_A);
        this.field_70159_w = -Math.sin((double)(this.field_70177_z / 180.0f) * Math.PI) * Math.cos((double)(this.field_70125_A / 180.0f) * Math.PI);
        this.field_70181_x = -Math.sin((double)(this.field_70125_A / 180.0f) * Math.PI);
        this.field_70179_y = Math.cos((double)(this.field_70177_z / 180.0f) * Math.PI) * Math.cos((double)(this.field_70125_A / 180.0f) * Math.PI);
        this.setThrowableHeading(this.field_70159_w, this.field_70181_x, this.field_70179_y, this.velocity, this.inaccuracy);
    }

    public void setThrowableHeading(double x, double y, double z, float velocity, float inaccuracy) {
        float f2 = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        x /= (double)f2;
        y /= (double)f2;
        z /= (double)f2;
        x += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        y += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        z += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        this.field_70159_w = x *= (double)velocity;
        this.field_70181_x = y *= (double)velocity;
        this.field_70179_y = z *= (double)velocity;
        float f3 = MathHelper.func_76133_a((double)(x * x + z * z));
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(x, z) * 180.0 / Math.PI);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(y, f3) * 180.0 / Math.PI);
    }

    public void func_70016_h(double mX, double mY, double mZ) {
        this.field_70159_w = mX;
        this.field_70181_x = mY;
        this.field_70179_y = mZ;
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(mX * mX + mZ * mZ));
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(mX, mZ) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(mY, f) * 180.0 / Math.PI);
        }
    }

    public void func_70071_h_() {
        Entity entity;
        IBlockState state;
        Vec3d motion;
        Vec3d end;
        Vec3d start;
        RayTraceResult rtr;
        if (this.field_70173_aa > 200) {
            return;
        }
        this.field_70142_S = this.field_70165_t;
        this.field_70137_T = this.field_70163_u;
        this.field_70136_U = this.field_70161_v;
        super.func_70071_h_();
        if (this.throwableShake > 0) {
            --this.throwableShake;
        }
        if (this.inGround) {
            this.inGround = false;
            this.field_70159_w *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
            this.field_70181_x *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
            this.field_70179_y *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
            this.ticksInAir = 0;
        } else {
            ++this.ticksInAir;
        }
        Vector3D vec3 = new Vector3D(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vector3D vec31 = new Vector3D(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        RayTraceResult movingobjectposition = MWCUtil.rayTraceBlocks(this.field_70170_p, vec3, vec31, (block, blockMetadata) -> this.canCollideWithBlock(null, (Block)block, null, (IBlockState)blockMetadata));
        if (ModernConfigManager.bulletBreakGlass && !this.field_70170_p.field_72995_K && (rtr = this.field_70170_p.func_147447_a(start = new Vec3d(this.field_70169_q, this.field_70167_r, this.field_70166_s), end = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v).func_178787_e(motion = new Vec3d(this.field_70159_w, this.field_70181_x, this.field_70179_y)), false, true, false)) != null && (state = this.field_70170_p.func_180495_p(rtr.func_178782_a())).func_185904_a() == Material.field_151592_s) {
            if (ModernConfigManager.bulletBreakGlass) {
                this.field_70170_p.func_175655_b(rtr.func_178782_a(), true);
            }
            MWC.CHANNEL.sendToAllAround((IMessage)new BlockHitMessage(rtr.func_178782_a(), new Vector3F(rtr.field_72307_f), rtr.field_178784_b), new NetworkRegistry.TargetPoint(this.field_71093_bK, this.field_70165_t, this.field_70163_u, this.field_70161_v, 20.0));
        }
        vec3 = new Vector3D(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        vec31 = new Vector3D(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        if (movingobjectposition != null) {
            vec31 = new Vector3D(movingobjectposition.field_72307_f);
        }
        if (!this.field_70170_p.field_72995_K && (entity = this.getRayTraceEntities(vec3, vec31)) != null) {
            movingobjectposition = new RayTraceResult(entity);
        }
        if (movingobjectposition != null) {
            this.onImpact(movingobjectposition);
        }
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        float f1 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
        this.field_70125_A = (float)(Math.atan2(this.field_70181_x, f1) * 180.0 / Math.PI);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
        float f2 = 0.99f;
        float f3 = this.gravityVelocity;
        if (this.func_70090_H()) {
            for (int i = 0; i < 4; ++i) {
                float f4 = 0.25f;
                EnumParticleTypes particleType = EnumParticleTypes.func_186831_a((String)"bubble");
                if (particleType == null) continue;
                this.field_70170_p.func_175688_a(particleType, this.field_70165_t - this.field_70159_w * (double)f4, this.field_70163_u - this.field_70181_x * (double)f4, this.field_70161_v - this.field_70179_y * (double)f4, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
            }
            f2 = 0.8f;
        }
        this.field_70159_w *= (double)f2;
        this.field_70181_x *= (double)f2;
        this.field_70179_y *= (double)f2;
        this.field_70181_x -= (double)f3;
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    private Entity getRayTraceEntities(Vector3D vec3, Vector3D vec31) {
        Entity entity = null;
        List list = this.field_70170_p.func_72839_b(entity, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72321_a(1.0, 1.0, 1.0));
        double d0 = 0.0;
        EntityLivingBase entitylivingbase = this.getThrower();
        for (Object o : list) {
            double d1;
            Entity entity1 = (Entity)o;
            boolean flag = true;
            if (entity1 instanceof EntityLivingBase) {
                EntityLivingBase elb = (EntityLivingBase)entity1;
                boolean bl = flag = elb.field_70725_aQ == 0;
            }
            if (!flag || !entity1.func_70067_L() || entity1 == entitylivingbase && this.ticksInAir < 5) continue;
            float f1 = 0.15f;
            float f2 = -0.15f;
            AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_72321_a((double)f1, (double)f1, (double)f1);
            RayTraceResult movingobjectposition = axisalignedbb.func_72327_a(vec3.toVec3d(), vec31.toVec3d());
            AxisAlignedBB axisalignedbb1 = entity1.func_174813_aQ().func_72321_a((double)f2, (double)f2, (double)f2);
            RayTraceResult movingobjectposition1 = axisalignedbb1.func_72327_a(vec3.toVec3d(), vec31.toVec3d());
            if (movingobjectposition != null) {
                d1 = vec3.distanceTo(new Vector3D(movingobjectposition.field_72307_f));
                if (!(d1 < d0) && d0 != 0.0) continue;
                entity = entity1;
                d0 = d1;
                continue;
            }
            if (movingobjectposition1 == null || !((d1 = vec3.distanceTo(new Vector3D(movingobjectposition1.field_72307_f))) < d0) && d0 != 0.0) continue;
            entity = entity1;
            d0 = d1;
        }
        return entity;
    }

    protected abstract void onImpact(RayTraceResult var1);

    public void func_70014_b(NBTTagCompound tagCompound) {
        tagCompound.func_74772_a("timestamp", this.timestamp);
        tagCompound.func_74777_a("xTile", (short)this.xTile);
        tagCompound.func_74777_a("yTile", (short)this.yTile);
        tagCompound.func_74777_a("zTile", (short)this.zTile);
        tagCompound.func_74774_a("shake", (byte)this.throwableShake);
        tagCompound.func_74774_a("inGround", (byte)(this.inGround ? 1 : 0));
        if ((this.throwerName == null || this.throwerName.length() == 0) && this.thrower != null && this.thrower instanceof EntityPlayer) {
            this.throwerName = ((EntityPlayer)this.thrower).func_70005_c_();
        }
        tagCompound.func_74778_a("ownerName", this.throwerName == null ? "" : this.throwerName);
        tagCompound.func_74776_a(TAG_GRAVITY_VELOCITY, this.gravityVelocity);
        tagCompound.func_74780_a("aimTan", this.aimTan);
    }

    public void func_70037_a(NBTTagCompound tagCompound) {
        this.xTile = tagCompound.func_74765_d("xTile");
        this.yTile = tagCompound.func_74765_d("yTile");
        this.zTile = tagCompound.func_74765_d("zTile");
        this.throwableShake = tagCompound.func_74771_c("shake") & 0xFF;
        this.inGround = tagCompound.func_74771_c("inGround") == 1;
        this.throwerName = tagCompound.func_74779_i("ownerName");
        if (this.throwerName != null && this.throwerName.length() == 0) {
            this.throwerName = null;
        }
        this.gravityVelocity = tagCompound.func_74760_g(TAG_GRAVITY_VELOCITY);
        this.timestamp = tagCompound.func_74763_f("timestamp");
        this.aimTan = tagCompound.func_74769_h("aimTan");
        if (System.currentTimeMillis() > this.timestamp + this.maxLifetime) {
            this.func_70106_y();
        }
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeFloat(this.gravityVelocity);
        buffer.writeDouble(this.aimTan);
    }

    public void readSpawnData(ByteBuf buffer) {
        this.gravityVelocity = buffer.readFloat();
        this.aimTan = buffer.readDouble();
    }

    public float getShadowSize() {
        return 0.0f;
    }

    public double getAimTan() {
        return this.aimTan;
    }

    public EntityLivingBase getThrower() {
        if (this.thrower == null && this.throwerName != null && this.throwerName.length() > 0) {
            this.thrower = this.field_70170_p.func_72924_a(this.throwerName);
        }
        return this.thrower;
    }

    protected void func_70088_a() {
    }

    public boolean func_70112_a(double p_70112_1_) {
        double d1 = this.func_174813_aQ().func_72320_b() * 4.0;
        return p_70112_1_ < (d1 *= 64.0) * d1;
    }

    public boolean canCollideWithBlock(List<BlockPos> violators, Block block, BlockPos pos, IBlockState iBlockState) {
        return block.func_176209_a(iBlockState, false);
    }
}

