/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.mwc.equipment.inventory;

import com.paneedah.mwc.equipment.inventory.EquipmentInventory;
import com.paneedah.mwc.equipment.inventory.EquipmentSlot;
import com.paneedah.mwc.items.equipment.carryable.ItemBackpack;
import com.paneedah.mwc.items.equipment.carryable.ItemBelt;
import com.paneedah.weaponlib.ItemVest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EquipmentContainer
extends Container {
    private EquipmentInventory equipmentInventory;
    private int customSlotStartIndex;
    private int customSlotEndIndex;
    private int armorSlotStartIndex;
    private int armorSlotEndIndex;
    private int standardInventorySlotStartIndex;
    private int standardInventorySlotEndIndex;
    private int hotbarSlotStartIndex;
    private int hotbarSlotEndIndex;
    private List<Slot> customSlots;

    public EquipmentContainer(EntityPlayer player, InventoryPlayer inventoryPlayer, EquipmentInventory equipmentInventory) {
        this.equipmentInventory = equipmentInventory;
        this.customSlots = this.createCustomSlots(equipmentInventory);
        this.customSlots.forEach(slot -> this.func_75146_a((Slot)slot));
        this.customSlotStartIndex = 0;
        this.customSlotEndIndex = this.customSlotStartIndex + this.customSlots.size() - 1;
        List<Slot> armorSlots = this.createArmorSlots(player, inventoryPlayer);
        this.armorSlotStartIndex = equipmentInventory.func_70302_i_();
        this.armorSlotEndIndex = this.armorSlotStartIndex + armorSlots.size() - 1;
        List<Slot> standardInventorySlots = this.createStandardInventorySlots(inventoryPlayer);
        standardInventorySlots.forEach(slot -> this.func_75146_a((Slot)slot));
        this.standardInventorySlotStartIndex = this.armorSlotEndIndex + 1;
        this.standardInventorySlotEndIndex = this.standardInventorySlotStartIndex + standardInventorySlots.size() - 1;
        List<Slot> hotbarSlots = this.createHotbarSlots(inventoryPlayer);
        hotbarSlots.forEach(slot -> this.func_75146_a((Slot)slot));
        this.hotbarSlotStartIndex = this.standardInventorySlotEndIndex + 1;
        this.hotbarSlotEndIndex = this.hotbarSlotStartIndex + hotbarSlots.size() - 1;
    }

    protected List<Slot> createCustomSlots(EquipmentInventory inventoryCustom) {
        return Arrays.asList(new Slot[]{new EquipmentSlot(ItemBackpack.class, inventoryCustom, 0, 80, 8), new EquipmentSlot(ItemBelt.class, inventoryCustom, 1, 80, 26), new EquipmentSlot(ItemVest.class, inventoryCustom, 2, 80, 44)});
    }

    protected List<Slot> createHotbarSlots(InventoryPlayer inventoryPlayer) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        for (int i = 0; i < 9; ++i) {
            slots.add(new Slot((IInventory)inventoryPlayer, i, 8 + i * 18, 142));
        }
        return slots;
    }

    protected List<Slot> createStandardInventorySlots(InventoryPlayer inventoryPlayer) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                slots.add(new Slot((IInventory)inventoryPlayer, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        return slots;
    }

    protected List<Slot> createArmorSlots(final EntityPlayer player, InventoryPlayer inventoryPlayer) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        for (int i = 0; i < 4; ++i) {
            final EntityEquipmentSlot entityequipmentslot = (new EntityEquipmentSlot[]{EntityEquipmentSlot.HEAD, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET})[i];
            this.func_75146_a(new Slot((IInventory)inventoryPlayer, inventoryPlayer.func_70302_i_() - 1 - i - 1, 8, 8 + i * 18){

                public int func_75219_a() {
                    return 1;
                }

                public boolean func_75214_a(ItemStack stack) {
                    return stack.func_77973_b().isValidArmor(stack, entityequipmentslot, (Entity)player);
                }

                public boolean func_82869_a(EntityPlayer playerIn) {
                    ItemStack itemstack = this.func_75211_c();
                    return !itemstack.func_190926_b() && !playerIn.func_184812_l_() && EnchantmentHelper.func_190938_b((ItemStack)itemstack) ? false : super.func_82869_a(playerIn);
                }

                @Nullable
                @SideOnly(value=Side.CLIENT)
                public String func_178171_c() {
                    return ItemArmor.field_94603_a[entityequipmentslot.func_188454_b()];
                }
            });
        }
        return slots;
    }

    public boolean func_75145_c(EntityPlayer player) {
        return true;
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotIndex) {
        ItemStack itemstack = null;
        try {
            Slot slot = (Slot)this.field_75151_b.get(slotIndex);
            if (slot != null && slot.func_75216_d()) {
                ItemStack itemstack1 = slot.func_75211_c();
                itemstack = itemstack1.func_77946_l();
                if (slotIndex < this.standardInventorySlotStartIndex) {
                    if (!this.func_75135_a(itemstack1, this.standardInventorySlotStartIndex, this.hotbarSlotEndIndex + 1, true)) {
                        return new ItemStack(Items.field_190931_a);
                    }
                    slot.func_75220_a(itemstack1, itemstack);
                } else if (this.customSlots.stream().anyMatch(s -> s.func_75214_a(itemstack1))) {
                    if (!this.func_75135_a(itemstack1, this.customSlotStartIndex, this.customSlotEndIndex + 1, false)) {
                        return new ItemStack(Items.field_190931_a);
                    }
                } else if (itemstack1.func_77973_b() instanceof ItemArmor) {
                    ItemArmor armor = (ItemArmor)itemstack1.func_77973_b();
                    int ordinal = 4 - armor.func_185083_B_().func_188452_c();
                    if (!this.func_75135_a(itemstack1, this.armorSlotStartIndex + ordinal, this.armorSlotStartIndex + ordinal + 1, false)) {
                        if (!this.func_75135_a(itemstack1, 0, this.field_75151_b.size() - 1, false)) {
                            return ItemStack.field_190927_a;
                        }
                        return ItemStack.field_190927_a;
                    }
                } else if (slotIndex >= this.standardInventorySlotStartIndex && slotIndex < this.hotbarSlotStartIndex ? !this.func_75135_a(itemstack1, this.hotbarSlotStartIndex, this.hotbarSlotEndIndex + 1, false) : slotIndex >= this.hotbarSlotStartIndex && slotIndex < this.hotbarSlotEndIndex + 1 && !this.func_75135_a(itemstack1, this.standardInventorySlotStartIndex, this.standardInventorySlotEndIndex + 1, false)) {
                    return new ItemStack(Items.field_190931_a);
                }
                if (itemstack1.func_190916_E() == 0) {
                    slot.func_75215_d(new ItemStack(Items.field_190931_a));
                } else {
                    slot.func_75218_e();
                }
                if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                    return null;
                }
                slot.func_190901_a(player, itemstack1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return itemstack != null ? itemstack : new ItemStack(Items.field_190931_a);
    }
}

