/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.playerrevive;

import com.creativemd.creativecore.common.config.holder.CreativeConfigRegistry;
import com.creativemd.creativecore.common.gui.container.SubContainer;
import com.creativemd.creativecore.common.gui.container.SubGui;
import com.creativemd.creativecore.common.gui.opener.CustomGuiHandler;
import com.creativemd.creativecore.common.gui.opener.GuiHandler;
import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.playerrevive.PlayerReviveConfig;
import com.creativemd.playerrevive.api.IRevival;
import com.creativemd.playerrevive.api.capability.CapaRevive;
import com.creativemd.playerrevive.gui.SubContainerRevive;
import com.creativemd.playerrevive.gui.SubGuiRevive;
import com.creativemd.playerrevive.packet.ReviveUpdatePacket;
import com.creativemd.playerrevive.server.PlayerReviveServer;
import com.creativemd.playerrevive.server.ReviveEventServer;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(modid="playerrevive", version="1.0", name="Player Revive", acceptedMinecraftVersions="", dependencies="required-after:creativecore", guiFactory="com.creativemd.playerrevive.PlayerReviveSettings")
@Mod.EventBusSubscriber
public class PlayerRevive {
    @SidedProxy(clientSide="com.creativemd.playerrevive.client.PlayerReviveClient", serverSide="com.creativemd.playerrevive.server.PlayerReviveServer")
    public static PlayerReviveServer proxy;
    public static SoundEvent deathSound;
    public static SoundEvent revivedSound;
    public static final String modid = "playerrevive";
    public static final String version = "1.0";
    public static PlayerReviveConfig CONFIG;

    @SubscribeEvent
    public static void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new SoundEvent[]{deathSound, revivedSound});
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandBase(){

            public String func_71518_a(ICommandSender sender) {
                return "revive a bleeding player";
            }

            public String func_71517_b() {
                return "revive";
            }

            public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
                EntityPlayer player = null;
                if (args.length == 1) {
                    player = server.func_184103_al().func_152612_a(args[0]);
                } else if (sender instanceof EntityPlayer) {
                    player = (EntityPlayer)sender;
                }
                if (player != null) {
                    PlayerReviveServer.revive(player);
                }
            }

            public boolean func_82358_a(String[] args, int index) {
                return index == 1;
            }

            public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
                if (args.length == 1) {
                    return 1.func_71530_a((String[])args, (String[])server.func_71213_z());
                }
                return Collections.emptyList();
            }
        });
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        CreativeCorePacket.registerPacket(ReviveUpdatePacket.class);
        GuiHandler.registerGuiHandler((String)"plrevive", (CustomGuiHandler)new CustomGuiHandler(){

            @SideOnly(value=Side.CLIENT)
            public SubGui getGui(EntityPlayer player, NBTTagCompound nbt) {
                return new SubGuiRevive();
            }

            public SubContainer getContainer(EntityPlayer player, NBTTagCompound nbt) {
                return new SubContainerRevive(player, PlayerReviveServer.getRevival(player), false);
            }
        });
        GuiHandler.registerGuiHandler((String)"plreviver", (CustomGuiHandler)new CustomGuiHandler(){

            @SideOnly(value=Side.CLIENT)
            public SubGui getGui(EntityPlayer player, NBTTagCompound nbt) {
                return new SubGuiRevive();
            }

            public SubContainer getContainer(EntityPlayer player, NBTTagCompound nbt) {
                IRevival revive = null;
                revive = player.field_70170_p.field_72995_K ? PlayerReviveServer.getRevival(player.field_70170_p.func_152378_a(UUID.fromString(nbt.func_74779_i("uuid")))) : PlayerReviveServer.getRevival((EntityPlayer)player.func_184102_h().func_184103_al().func_177451_a(UUID.fromString(nbt.func_74779_i("uuid"))));
                return new SubContainerRevive(player, revive, true);
            }
        });
        CapaRevive.register();
        CONFIG = new PlayerReviveConfig();
        CreativeConfigRegistry.ROOT.registerValue(modid, (Object)CONFIG);
        MinecraftForge.EVENT_BUS.register((Object)new ReviveEventServer());
        proxy.loadSide();
    }

    static {
        deathSound = (SoundEvent)new SoundEvent(new ResourceLocation(modid, "death")).setRegistryName(new ResourceLocation(modid, "death"));
        revivedSound = (SoundEvent)new SoundEvent(new ResourceLocation(modid, "revived")).setRegistryName(new ResourceLocation(modid, "revived"));
    }
}

