/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.client.model.paint.loaders.customs;

import com.silvaniastudios.roads.blocks.diagonal.ShapeLibrary;
import com.silvaniastudios.roads.blocks.paint.PaintBlockBase;
import com.silvaniastudios.roads.blocks.paint.customs.CustomPaintBlock;
import com.silvaniastudios.roads.blocks.paint.customs.ICustomBlock;
import com.silvaniastudios.roads.client.model.paint.PaintBakedModelBase;
import com.silvaniastudios.roads.client.render.Quad;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.model.IModelState;

class CustomPaintBakedModel
extends PaintBakedModelBase {
    public CustomPaintBakedModel(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        super(state, format, bakedTextureGetter);
        this.populateSprites();
    }

    @Override
    protected List<BakedQuad> packQuads(IBlockState state) {
        int yRot;
        int xRot;
        TextureAtlasSprite tex;
        boolean[][] grid;
        if (state != null) {
            int colId = ((PaintBlockBase)state.func_177230_c()).getColour().getId();
            grid = ((ICustomBlock)state.func_177230_c()).getGrid(0).getGrid();
            tex = this.sprites[colId];
            EnumFacing rotState = (EnumFacing)state.func_177229_b((IProperty)CustomPaintBlock.FACING);
            xRot = 0;
            yRot = 45;
            switch (rotState) {
                case NORTH: {
                    yRot = 0;
                    break;
                }
                case EAST: {
                    yRot = 270;
                    break;
                }
                case SOUTH: {
                    yRot = 180;
                    break;
                }
                case WEST: {
                    yRot = 90;
                }
            }
        } else {
            return this.handleItemRendering();
        }
        List<Quad> rawQuads = ShapeLibrary.shapeFromGrid(grid, 0.015625f, tex, this.format, false);
        List<BakedQuad> quads = this.shapeBuilder(rawQuads, new ArrayList<BakedQuad>(), xRot, yRot);
        return quads;
    }
}

