/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.client.gui.paintgun;

import com.silvaniastudios.roads.blocks.PaintColour;
import com.silvaniastudios.roads.blocks.paint.LargeTextPaintBlock;
import com.silvaniastudios.roads.blocks.paint.PaintBlockBase;
import com.silvaniastudios.roads.client.gui.GuiScrollingList_Mod;
import com.silvaniastudios.roads.client.gui.paintgun.GuiPaintGun;
import com.silvaniastudios.roads.items.RoadItemBlock;
import com.silvaniastudios.roads.registries.PaintIconObject;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class PaintGunPaintList
extends GuiScrollingList_Mod {
    private FontRenderer fontRenderer;
    private Minecraft client;
    private GuiPaintGun gui;
    private ArrayList<PaintIconObject> paints;
    private boolean enabled = false;
    private static final ResourceLocation TEXTURE_WIDGET = new ResourceLocation("furenikusroads", "textures/gui/paint_list.png");

    public PaintGunPaintList(int width, int height, int top, int left, int entryHeight, int screenWidth, int screenHeight, FontRenderer font, Minecraft mc, GuiPaintGun gui, ArrayList<PaintIconObject> paints, ArrayList<String> tooltipList) {
        super(mc, width, height, top, height + top, left, entryHeight, screenWidth, screenHeight, tooltipList);
        this.fontRenderer = font;
        this.client = mc;
        this.gui = gui;
        this.paints = paints;
    }

    public void setEnabled(boolean b) {
        this.enabled = b;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    protected int getSize() {
        return (int)Math.ceil((double)this.paints.size() / 5.0);
    }

    @Override
    protected void elementClicked(int index, boolean doubleClick) {
        int slot = index * 5 + (this.mouseX - this.left) / 25;
        if (slot < this.paints.size()) {
            this.gui.setSelectedId(slot);
        }
    }

    @Override
    protected boolean isSelected(int index) {
        return false;
    }

    @Override
    protected void drawBackground() {
    }

    @Override
    protected void drawSlot(int slotIdx, int entryRight, int slotTop, int slotBuffer, Tessellator tess) {
        int horizontal;
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2912);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int left = entryRight - this.listWidth + 7;
        int slot = slotIdx * 5;
        this.client.func_110434_K().func_110577_a(TEXTURE_WIDGET);
        for (horizontal = 0; horizontal < 5; ++horizontal) {
            if (slot + horizontal >= this.paints.size()) continue;
            int yOffset = 0;
            if (this.gui.getCategoryId() == this.gui.getSelectedCategoryId() && this.gui.getSlotId() == slot + horizontal) {
                yOffset = 48;
            }
            PaintIconObject paint = this.paints.get(slot + horizontal);
            ItemStack stack = new ItemStack((Block)paint.getPaint(), 1, paint.getMeta());
            if (this.mouseY >= slotTop && this.mouseY <= slotTop + this.slotHeight && this.mouseX >= left + horizontal * 25 && this.mouseX <= left + horizontal * 25 + 24) {
                yOffset += 24;
                if (stack.func_77973_b() instanceof RoadItemBlock) {
                    RoadItemBlock ib = (RoadItemBlock)stack.func_77973_b();
                    this.tooltipList.add(PaintColour.getFromName(this.gui.getSelectedColour()).getFormat() + ib.getUnformattedDisplayName(stack));
                }
            }
            if (paint.getPaint().canConnect(paint.getIndex()) || paint.getPaint() instanceof LargeTextPaintBlock && paint.getMeta() != 0) {
                this.gui.func_73729_b(left + horizontal * 25, slotTop, 24, yOffset, 24, 24);
                continue;
            }
            this.gui.func_73729_b(left + horizontal * 25, slotTop, 0, yOffset, 24, 24);
        }
        for (horizontal = 0; horizontal < 5; ++horizontal) {
            if (slot + horizontal >= this.paints.size()) continue;
            PaintBlockBase paint = this.gui.getSelectedColour().equals("white") ? this.paints.get(slot + horizontal).getPaint() : this.paints.get(slot + horizontal).getRecolouredPaint(this.gui.getSelectedColour());
            this.drawItemStack(new ItemStack((Block)paint, 1, this.paints.get(slot + horizontal).getMeta()), left + horizontal * 25 + 4, slotTop + 4);
        }
    }
}

