/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.blocks.decorative;

import com.silvaniastudios.roads.FurenikusRoads;
import com.silvaniastudios.roads.blocks.BlockBase;
import com.silvaniastudios.roads.blocks.NonPaintRoadTopBlock;
import com.silvaniastudios.roads.blocks.decorative.CurbBlock;
import com.silvaniastudios.roads.blocks.enums.IConnectable;
import com.silvaniastudios.roads.blocks.paint.PaintBlockBase;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;

public class ConcreteBarrierBlock
extends BlockBase
implements IConnectable {
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");

    public ConcreteBarrierBlock(String name) {
        super(name, Material.field_151573_f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(false)));
        this.func_149647_a(FurenikusRoads.tab_road_parts);
        this.func_149711_c(1.5f);
        this.setHarvestLevel("pickaxe", 1);
    }

    public boolean canConnectTo(IBlockAccess worldIn, BlockPos pos, boolean checkingLevel) {
        IBlockState state = worldIn.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (checkingLevel && (block instanceof IConnectable || block.func_149662_c(state))) {
            return true;
        }
        return block instanceof IConnectable;
    }

    private boolean canBarrierConnectTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        BlockPos offset = pos.func_177972_a(facing);
        return this.canConnectTo(world, offset, true) || this.canConnectTo(world, offset.func_177972_a(EnumFacing.DOWN), false) || this.canConnectTo(world, offset.func_177972_a(EnumFacing.UP), false);
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{NORTH, EAST, WEST, SOUTH});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(this.canBarrierConnectTo(worldIn, pos, EnumFacing.NORTH))).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(this.canBarrierConnectTo(worldIn, pos, EnumFacing.EAST))).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(this.canBarrierConnectTo(worldIn, pos, EnumFacing.SOUTH))).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(this.canBarrierConnectTo(worldIn, pos, EnumFacing.WEST)));
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.getBox(state, world, pos);
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.getBox(state, world, pos);
    }

    private AxisAlignedBB getBox(IBlockState state, IBlockAccess world, BlockPos pos) {
        boolean north = this.canBarrierConnectTo(world, pos, EnumFacing.NORTH);
        boolean east = this.canBarrierConnectTo(world, pos, EnumFacing.EAST);
        boolean south = this.canBarrierConnectTo(world, pos, EnumFacing.SOUTH);
        boolean west = this.canBarrierConnectTo(world, pos, EnumFacing.WEST);
        double xLow = 0.0;
        double zLow = 0.0;
        double xHigh = 1.0;
        double zHigh = 1.0;
        zLow = north ? 0.0 : 0.3359375;
        xHigh = east ? 1.0 : 0.6640625;
        zHigh = south ? 1.0 : 0.6640625;
        xLow = west ? 0.0 : 0.3359375;
        return new AxisAlignedBB(xLow, -1.0 + this.getBlockBelowHeight(world, pos), zLow, xHigh, -1.0 + this.getBlockBelowHeight(world, pos) + 1.0, zHigh);
    }

    public Block.EnumOffsetType func_176218_Q() {
        return Block.EnumOffsetType.XYZ;
    }

    public Vec3d func_190949_e(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        double offset = 1.0 - this.getBlockBelowHeight(worldIn, pos);
        return new Vec3d(0.0, -offset, 0.0);
    }

    public double getBlockBelowHeight(IBlockAccess worldIn, BlockPos pos) {
        IBlockState underState = worldIn.func_180495_p(pos.func_177972_a(EnumFacing.DOWN));
        Block underBlock = underState.func_177230_c();
        double extraOffset = 0.0;
        if (underBlock instanceof PaintBlockBase || underBlock instanceof NonPaintRoadTopBlock || underBlock instanceof CurbBlock) {
            extraOffset = 0.062;
        }
        return underBlock.func_185496_a((IBlockState)underState, (IBlockAccess)worldIn, (BlockPos)pos.func_177972_a((EnumFacing)EnumFacing.DOWN)).field_72337_e - extraOffset;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }
}

